/*
 * Decompiled with CFR 0.152.
 */
package org.apache.manifoldcf.core.interfaces;

import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Locale;
import org.apache.manifoldcf.core.interfaces.ConfigParams;
import org.apache.manifoldcf.core.interfaces.IConnector;
import org.apache.manifoldcf.core.interfaces.IHTTPOutput;
import org.apache.manifoldcf.core.interfaces.IPostParameters;
import org.apache.manifoldcf.core.interfaces.IThreadContext;
import org.apache.manifoldcf.core.interfaces.ManifoldCFException;
import org.apache.manifoldcf.core.system.ManifoldCF;

public abstract class ConnectorFactory<T extends IConnector> {
    public static final String _rcsid = "@(#)$Id: OutputConnectorFactory.java 988245 2010-08-23 18:39:35Z kwright $";

    protected ConnectorFactory() {
    }

    protected abstract boolean isInstalled(IThreadContext var1, String var2) throws ManifoldCFException;

    protected void installThis(IThreadContext threadContext, String className) throws ManifoldCFException {
        T connector = this.getThisConnectorNoCheck(className);
        connector.install(threadContext);
    }

    protected void deinstallThis(IThreadContext threadContext, String className) throws ManifoldCFException {
        T connector = this.getThisConnectorNoCheck(className);
        connector.deinstall(threadContext);
    }

    protected void outputThisConfigurationHeader(IThreadContext threadContext, String className, IHTTPOutput out, Locale locale, ConfigParams parameters, ArrayList tabsArray) throws ManifoldCFException, IOException {
        T connector = this.getThisConnector(threadContext, className);
        if (connector == null) {
            return;
        }
        connector.outputConfigurationHeader(threadContext, out, locale, parameters, tabsArray);
    }

    protected void outputThisConfigurationBody(IThreadContext threadContext, String className, IHTTPOutput out, Locale locale, ConfigParams parameters, String tabName) throws ManifoldCFException, IOException {
        T connector = this.getThisConnector(threadContext, className);
        if (connector == null) {
            return;
        }
        connector.outputConfigurationBody(threadContext, out, locale, parameters, tabName);
    }

    protected String processThisConfigurationPost(IThreadContext threadContext, String className, IPostParameters variableContext, Locale locale, ConfigParams configParams) throws ManifoldCFException {
        T connector = this.getThisConnector(threadContext, className);
        if (connector == null) {
            return null;
        }
        return connector.processConfigurationPost(threadContext, variableContext, locale, configParams);
    }

    protected void viewThisConfiguration(IThreadContext threadContext, String className, IHTTPOutput out, Locale locale, ConfigParams configParams) throws ManifoldCFException, IOException {
        T connector = this.getThisConnector(threadContext, className);
        if (connector == null) {
            return;
        }
        connector.viewConfiguration(threadContext, out, locale, configParams);
    }

    protected T getThisConnectorNoCheck(String className) throws ManifoldCFException {
        T rval = this.getThisConnectorRaw(className);
        if (rval == null) {
            throw new ManifoldCFException("No connector class '" + className + "' was found.");
        }
        return rval;
    }

    protected T getThisConnector(IThreadContext threadContext, String className) throws ManifoldCFException {
        if (!this.isInstalled(threadContext, className)) {
            return null;
        }
        return this.getThisConnectorRaw(className);
    }

    protected T getThisConnectorRaw(String className) throws ManifoldCFException {
        try {
            Class theClass = ManifoldCF.findClass(className);
            Class[] argumentClasses = new Class[]{};
            Constructor c = theClass.getConstructor(argumentClasses);
            Object[] arguments = new Object[]{};
            Object o = c.newInstance(arguments);
            try {
                return (T)((IConnector)o);
            }
            catch (ClassCastException e) {
                throw new ManifoldCFException("Class '" + className + "' does not implement IConnector.");
            }
        }
        catch (InvocationTargetException e) {
            Throwable z = e.getTargetException();
            if (z instanceof Error) {
                throw (Error)z;
            }
            if (z instanceof RuntimeException) {
                throw (RuntimeException)z;
            }
            if (z instanceof ManifoldCFException) {
                throw (ManifoldCFException)z;
            }
            throw new RuntimeException("Unknown exception type: " + z.getClass().getName() + ": " + z.getMessage(), z);
        }
        catch (ClassNotFoundException e) {
            return null;
        }
        catch (NoSuchMethodException e) {
            throw new ManifoldCFException("No appropriate constructor for IConnector implementation '" + className + "'.  Need xxx().", e);
        }
        catch (SecurityException e) {
            throw new ManifoldCFException("Protected constructor for IConnector implementation '" + className + "'", e);
        }
        catch (IllegalAccessException e) {
            throw new ManifoldCFException("Unavailable constructor for IConnector implementation '" + className + "'", e);
        }
        catch (IllegalArgumentException e) {
            throw new ManifoldCFException("Shouldn't happen!!!", e);
        }
        catch (InstantiationException e) {
            throw new ManifoldCFException("InstantiationException for IConnector implementation '" + className + "'", e);
        }
        catch (ExceptionInInitializerError e) {
            throw new ManifoldCFException("ExceptionInInitializerError for IConnector implementation '" + className + "'", e);
        }
    }
}

