/*
 * Decompiled with CFR 0.152.
 */
package org.apache.manifoldcf.core.lockmanager;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.util.List;
import org.apache.manifoldcf.core.interfaces.ILockManager;
import org.apache.manifoldcf.core.interfaces.IServiceCleanup;
import org.apache.manifoldcf.core.interfaces.IServiceDataAcceptor;
import org.apache.manifoldcf.core.interfaces.IShutdownHook;
import org.apache.manifoldcf.core.interfaces.IThreadContext;
import org.apache.manifoldcf.core.interfaces.ManifoldCFConfiguration;
import org.apache.manifoldcf.core.interfaces.ManifoldCFException;
import org.apache.manifoldcf.core.interfaces.ThreadContextFactory;
import org.apache.manifoldcf.core.lockmanager.BaseLockManager;
import org.apache.manifoldcf.core.lockmanager.LockPool;
import org.apache.manifoldcf.core.lockmanager.ZooKeeperConnection;
import org.apache.manifoldcf.core.lockmanager.ZooKeeperConnectionPool;
import org.apache.manifoldcf.core.lockmanager.ZooKeeperEphemeralNodePool;
import org.apache.manifoldcf.core.lockmanager.ZooKeeperLockObjectFactory;
import org.apache.manifoldcf.core.system.ManifoldCF;

public class ZooKeeperLockManager
extends BaseLockManager
implements ILockManager {
    public static final String _rcsid = "@(#)$Id: LockManager.java 988245 2010-08-23 18:39:35Z kwright $";
    protected static final String zookeeperConnectStringParameter = "org.apache.manifoldcf.zookeeper.connectstring";
    protected static final String zookeeperSessionTimeoutParameter = "org.apache.manifoldcf.zookeeper.sessiontimeout";
    private static final String CONFIGURATION_PATH = "/org.apache.manifoldcf.configuration";
    private static final String RESOURCE_PATH_PREFIX = "/org.apache.manifoldcf.resources-";
    private static final String FLAG_PATH_PREFIX = "/org.apache.manifoldcf.flags-";
    private static final String SERVICETYPE_LOCK_PATH_PREFIX = "/org.apache.manifoldcf.servicelock-";
    private static final String SERVICETYPE_ACTIVE_PATH_PREFIX = "/org.apache.manifoldcf.serviceactive-";
    private static final String SERVICETYPE_REGISTER_PATH_PREFIX = "/org.apache.manifoldcf.service-";
    private static final String SERVICETYPE_ANONYMOUS_COUNTER_PREFIX = "/org.apache.manifoldcf.serviceanon-";
    protected static final String anonymousServiceNamePrefix = "_ANON_";
    protected static Integer connectionPoolLock = new Integer(0);
    protected static ZooKeeperConnectionPool pool = null;
    protected static Integer zookeeperPoolLocker = new Integer(0);
    protected static LockPool myZooKeeperLocks = null;
    protected static Integer ephemeralPoolLocker = new Integer(0);
    protected static ZooKeeperEphemeralNodePool myEphemeralNodes = null;
    protected ManifoldCFConfiguration cachedConfiguration = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ZooKeeperLockManager() throws ManifoldCFException {
        Integer n = connectionPoolLock;
        synchronized (n) {
            if (pool == null) {
                String connectString = ManifoldCF.getStringProperty(zookeeperConnectStringParameter, null);
                if (connectString == null) {
                    throw new ManifoldCFException("Zookeeper lock manager requires a valid org.apache.manifoldcf.zookeeper.connectstring property");
                }
                int sessionTimeout = ManifoldCF.getIntProperty(zookeeperSessionTimeoutParameter, 300000);
                ManifoldCF.addShutdownHook(new ZooKeeperShutdown());
                pool = new ZooKeeperConnectionPool(connectString, sessionTimeout);
            }
        }
        n = zookeeperPoolLocker;
        synchronized (n) {
            if (myZooKeeperLocks == null) {
                myZooKeeperLocks = new LockPool(new ZooKeeperLockObjectFactory(pool));
            }
        }
        n = ephemeralPoolLocker;
        synchronized (n) {
            if (myEphemeralNodes == null) {
                myEphemeralNodes = new ZooKeeperEphemeralNodePool(pool);
            }
        }
    }

    @Override
    public String registerServiceBeginServiceActivity(String serviceType, String serviceName, IServiceCleanup cleanup) throws ManifoldCFException {
        return this.registerServiceBeginServiceActivity(serviceType, serviceName, null, cleanup);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive exception aggregation
     */
    @Override
    public String registerServiceBeginServiceActivity(String serviceType, String serviceName, byte[] initialData, IServiceCleanup cleanup) throws ManifoldCFException {
        try {
            ZooKeeperConnection connection = pool.grab();
            try {
                String string;
                this.enterServiceRegistryWriteLock(connection, serviceType);
                try {
                    String encodedServiceName;
                    String activePath;
                    if (serviceName == null) {
                        serviceName = this.constructUniqueServiceName(connection, serviceType);
                    }
                    if (connection.checkNodeExists(activePath = ZooKeeperLockManager.buildServiceTypeActivePath(serviceType, encodedServiceName = ZooKeeperConnection.zooKeeperSafeName(serviceName)))) {
                        throw new ManifoldCFException("Service '" + serviceName + "' of type '" + serviceType + "' is already active");
                    }
                    String registrationNodePath = ZooKeeperLockManager.buildServiceTypeRegistrationPath(serviceType);
                    List<String> children = connection.getChildren(registrationNodePath);
                    boolean foundService = false;
                    boolean foundActiveService = false;
                    for (String encodedRegisteredServiceName : children) {
                        if (encodedRegisteredServiceName.equals(encodedServiceName)) {
                            foundService = true;
                        }
                        if (!connection.checkNodeExists(ZooKeeperLockManager.buildServiceTypeActivePath(serviceType, encodedRegisteredServiceName))) continue;
                        foundActiveService = true;
                    }
                    boolean unregisterAll = false;
                    if (cleanup != null) {
                        if (children.size() == 0) {
                            cleanup.cleanUpAllServices();
                            cleanup.clusterInit();
                        } else if (foundService && foundActiveService) {
                            cleanup.cleanUpService(serviceName);
                        } else if (!foundActiveService) {
                            cleanup.cleanUpAllServices();
                            cleanup.clusterInit();
                            unregisterAll = true;
                        }
                    }
                    if (unregisterAll) {
                        for (String encodedRegisteredServiceName : children) {
                            if (encodedRegisteredServiceName.equals(encodedServiceName)) continue;
                            connection.deleteChild(registrationNodePath, encodedRegisteredServiceName);
                        }
                    }
                    if (!foundService) {
                        connection.createChild(registrationNodePath, encodedServiceName);
                    }
                    myEphemeralNodes.createNode(activePath, initialData);
                    string = serviceName;
                }
                catch (Throwable throwable) {
                    this.leaveServiceRegistryLock(connection);
                    throw throwable;
                }
                this.leaveServiceRegistryLock(connection);
                return string;
            }
            finally {
                pool.release(connection);
            }
        }
        catch (InterruptedException e) {
            throw new ManifoldCFException(e.getMessage(), e, 2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateServiceData(String serviceType, String serviceName, byte[] serviceData) throws ManifoldCFException {
        try {
            ZooKeeperConnection connection = pool.grab();
            try {
                this.enterServiceRegistryWriteLock(connection, serviceType);
                try {
                    String activePath = ZooKeeperLockManager.buildServiceTypeActivePath(serviceType, ZooKeeperConnection.zooKeeperSafeName(serviceName));
                    myEphemeralNodes.setNodeData(activePath, serviceData == null ? new byte[]{} : serviceData);
                }
                finally {
                    this.leaveServiceRegistryLock(connection);
                }
            }
            finally {
                pool.release(connection);
            }
        }
        catch (InterruptedException e) {
            throw new ManifoldCFException(e.getMessage(), e, 2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive exception aggregation
     */
    @Override
    public byte[] retrieveServiceData(String serviceType, String serviceName) throws ManifoldCFException {
        try {
            ZooKeeperConnection connection = pool.grab();
            try {
                byte[] byArray;
                this.enterServiceRegistryReadLock(connection, serviceType);
                try {
                    String activePath = ZooKeeperLockManager.buildServiceTypeActivePath(serviceType, ZooKeeperConnection.zooKeeperSafeName(serviceName));
                    byArray = connection.getNodeData(activePath);
                }
                catch (Throwable throwable) {
                    this.leaveServiceRegistryLock(connection);
                    throw throwable;
                }
                this.leaveServiceRegistryLock(connection);
                return byArray;
            }
            finally {
                pool.release(connection);
            }
        }
        catch (InterruptedException e) {
            throw new ManifoldCFException(e.getMessage(), e, 2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void scanServiceData(String serviceType, IServiceDataAcceptor dataAcceptor) throws ManifoldCFException {
        try {
            ZooKeeperConnection connection = pool.grab();
            try {
                this.enterServiceRegistryReadLock(connection, serviceType);
                try {
                    String registrationNodePath = ZooKeeperLockManager.buildServiceTypeRegistrationPath(serviceType);
                    List<String> children = connection.getChildren(registrationNodePath);
                    for (String encodedRegisteredServiceName : children) {
                        String activeNodePath = ZooKeeperLockManager.buildServiceTypeActivePath(serviceType, encodedRegisteredServiceName);
                        if (!connection.checkNodeExists(activeNodePath)) continue;
                        byte[] serviceData = connection.getNodeData(activeNodePath);
                        if (!dataAcceptor.acceptServiceData(ZooKeeperConnection.zooKeeperDecodeSafeName(encodedRegisteredServiceName), serviceData)) continue;
                        break;
                    }
                }
                finally {
                    this.leaveServiceRegistryLock(connection);
                }
            }
            finally {
                pool.release(connection);
            }
        }
        catch (InterruptedException e) {
            throw new ManifoldCFException(e.getMessage(), e, 2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive exception aggregation
     */
    @Override
    public int countActiveServices(String serviceType) throws ManifoldCFException {
        try {
            ZooKeeperConnection connection = pool.grab();
            try {
                int n;
                this.enterServiceRegistryReadLock(connection, serviceType);
                try {
                    String registrationNodePath = ZooKeeperLockManager.buildServiceTypeRegistrationPath(serviceType);
                    List<String> children = connection.getChildren(registrationNodePath);
                    int activeServiceCount = 0;
                    for (String encodedRegisteredServiceName : children) {
                        if (!connection.checkNodeExists(ZooKeeperLockManager.buildServiceTypeActivePath(serviceType, encodedRegisteredServiceName))) continue;
                        ++activeServiceCount;
                    }
                    n = activeServiceCount;
                }
                catch (Throwable throwable) {
                    this.leaveServiceRegistryLock(connection);
                    throw throwable;
                }
                this.leaveServiceRegistryLock(connection);
                return n;
            }
            finally {
                pool.release(connection);
            }
        }
        catch (InterruptedException e) {
            throw new ManifoldCFException(e.getMessage(), e, 2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean cleanupInactiveService(String serviceType, IServiceCleanup cleanup) throws ManifoldCFException {
        try {
            ZooKeeperConnection connection = pool.grab();
            try {
                String encodedServiceName;
                String registrationNodePath;
                block11: {
                    boolean bl;
                    this.enterServiceRegistryWriteLock(connection, serviceType);
                    try {
                        registrationNodePath = ZooKeeperLockManager.buildServiceTypeRegistrationPath(serviceType);
                        List<String> children = connection.getChildren(registrationNodePath);
                        encodedServiceName = null;
                        for (String encodedRegisteredServiceName : children) {
                            if (connection.checkNodeExists(ZooKeeperLockManager.buildServiceTypeActivePath(serviceType, encodedRegisteredServiceName))) continue;
                            encodedServiceName = encodedRegisteredServiceName;
                            break;
                        }
                        if (encodedServiceName != null) break block11;
                        bl = true;
                    }
                    catch (Throwable throwable) {
                        this.leaveServiceRegistryLock(connection);
                        throw throwable;
                    }
                    this.leaveServiceRegistryLock(connection);
                    return bl;
                }
                cleanup.cleanUpService(ZooKeeperConnection.zooKeeperDecodeSafeName(encodedServiceName));
                connection.deleteChild(registrationNodePath, encodedServiceName);
                boolean bl = false;
                this.leaveServiceRegistryLock(connection);
                return bl;
            }
            finally {
                pool.release(connection);
            }
        }
        catch (InterruptedException e) {
            throw new ManifoldCFException(e.getMessage(), e, 2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void endServiceActivity(String serviceType, String serviceName) throws ManifoldCFException {
        try {
            ZooKeeperConnection connection = pool.grab();
            try {
                this.enterServiceRegistryWriteLock(connection, serviceType);
                try {
                    myEphemeralNodes.deleteNode(ZooKeeperLockManager.buildServiceTypeActivePath(serviceType, ZooKeeperConnection.zooKeeperSafeName(serviceName)));
                }
                finally {
                    this.leaveServiceRegistryLock(connection);
                }
            }
            finally {
                pool.release(connection);
            }
        }
        catch (InterruptedException e) {
            throw new ManifoldCFException(e.getMessage(), e, 2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean checkServiceActive(String serviceType, String serviceName) throws ManifoldCFException {
        try {
            ZooKeeperConnection connection = pool.grab();
            try {
                boolean bl;
                this.enterServiceRegistryReadLock(connection, serviceType);
                try {
                    bl = connection.checkNodeExists(ZooKeeperLockManager.buildServiceTypeActivePath(serviceType, ZooKeeperConnection.zooKeeperSafeName(serviceName)));
                }
                catch (Throwable throwable) {
                    this.leaveServiceRegistryLock(connection);
                    throw throwable;
                }
                this.leaveServiceRegistryLock(connection);
                return bl;
            }
            finally {
                pool.release(connection);
            }
        }
        catch (InterruptedException e) {
            throw new ManifoldCFException(e.getMessage(), e, 2);
        }
    }

    protected void enterServiceRegistryReadLock(ZooKeeperConnection connection, String serviceType) throws ManifoldCFException, InterruptedException {
        String serviceTypeLock = ZooKeeperLockManager.buildServiceTypeLockPath(serviceType);
        while (!connection.obtainReadLockNoWait(serviceTypeLock)) {
            ManifoldCF.sleep(100L);
        }
        return;
    }

    protected void enterServiceRegistryWriteLock(ZooKeeperConnection connection, String serviceType) throws ManifoldCFException, InterruptedException {
        String serviceTypeLock = ZooKeeperLockManager.buildServiceTypeLockPath(serviceType);
        while (!connection.obtainWriteLockNoWait(serviceTypeLock)) {
            ManifoldCF.sleep(100L);
        }
        return;
    }

    protected void leaveServiceRegistryLock(ZooKeeperConnection connection) throws ManifoldCFException, InterruptedException {
        connection.releaseLock();
    }

    protected String constructUniqueServiceName(ZooKeeperConnection connection, String serviceType) throws ManifoldCFException, InterruptedException {
        String serviceCounterName = ZooKeeperLockManager.makeServiceCounterName(serviceType);
        int serviceUID = this.readServiceCounter(connection, serviceCounterName);
        this.writeServiceCounter(connection, serviceCounterName, serviceUID + 1);
        return anonymousServiceNamePrefix + serviceUID;
    }

    protected static String makeServiceCounterName(String serviceType) {
        return SERVICETYPE_ANONYMOUS_COUNTER_PREFIX + ZooKeeperConnection.zooKeeperSafeName(serviceType);
    }

    protected int readServiceCounter(ZooKeeperConnection connection, String serviceCounterName) throws ManifoldCFException, InterruptedException {
        byte[] serviceCounterData = connection.readData(serviceCounterName);
        int rval = serviceCounterData == null || serviceCounterData.length != 4 ? 0 : (serviceCounterData[0] & 0xFF) + (serviceCounterData[1] << 8 & 0xFF00) + (serviceCounterData[2] << 16 & 0xFF0000) + (serviceCounterData[3] << 24 & 0xFF000000);
        return rval;
    }

    protected void writeServiceCounter(ZooKeeperConnection connection, String serviceCounterName, int counter) throws ManifoldCFException, InterruptedException {
        byte[] serviceCounterData = new byte[]{(byte)(counter & 0xFF), (byte)(counter >> 8 & 0xFF), (byte)(counter >> 16 & 0xFF), (byte)(counter >> 24 & 0xFF)};
        connection.writeData(serviceCounterName, serviceCounterData);
    }

    protected static String buildServiceTypeLockPath(String serviceType) {
        return SERVICETYPE_LOCK_PATH_PREFIX + ZooKeeperConnection.zooKeeperSafeName(serviceType);
    }

    protected static String buildServiceTypeActivePath(String serviceType, String encodedServiceName) {
        return SERVICETYPE_ACTIVE_PATH_PREFIX + ZooKeeperConnection.zooKeeperSafeName(serviceType) + "-" + encodedServiceName;
    }

    protected static String buildServiceTypeRegistrationPath(String serviceType) {
        return SERVICETYPE_REGISTER_PATH_PREFIX + ZooKeeperConnection.zooKeeperSafeName(serviceType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ManifoldCFConfiguration getSharedConfiguration() throws ManifoldCFException {
        if (this.cachedConfiguration == null) {
            try {
                ZooKeeperConnection connection = pool.grab();
                try {
                    byte[] configurationData = connection.readData(CONFIGURATION_PATH);
                    this.cachedConfiguration = configurationData != null ? new ManifoldCFConfiguration(new ByteArrayInputStream(configurationData)) : new ManifoldCFConfiguration();
                }
                finally {
                    pool.release(connection);
                }
            }
            catch (InterruptedException e) {
                throw new ManifoldCFException(e.getMessage(), e, 2);
            }
        }
        return this.cachedConfiguration;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSharedConfiguration(InputStream configurationInputStream) throws ManifoldCFException {
        try {
            int nRead;
            ByteArrayOutputStream buffer = new ByteArrayOutputStream();
            byte[] data = new byte[65536];
            while ((nRead = configurationInputStream.read(data, 0, data.length)) != -1) {
                buffer.write(data, 0, nRead);
            }
            buffer.flush();
            byte[] toWrite = buffer.toByteArray();
            ZooKeeperConnection connection = pool.grab();
            try {
                connection.writeData(CONFIGURATION_PATH, toWrite);
            }
            finally {
                pool.release(connection);
            }
        }
        catch (InterruptedIOException e) {
            throw new ManifoldCFException(e.getMessage(), e, 2);
        }
        catch (IOException e) {
            throw new ManifoldCFException(e.getMessage(), e);
        }
        catch (InterruptedException e) {
            throw new ManifoldCFException(e.getMessage(), e, 2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setGlobalFlag(String flagName) throws ManifoldCFException {
        try {
            ZooKeeperConnection connection = pool.grab();
            try {
                connection.setGlobalFlag(FLAG_PATH_PREFIX + ZooKeeperConnection.zooKeeperSafeName(flagName));
            }
            finally {
                pool.release(connection);
            }
        }
        catch (InterruptedException e) {
            throw new ManifoldCFException(e.getMessage(), e, 2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clearGlobalFlag(String flagName) throws ManifoldCFException {
        try {
            ZooKeeperConnection connection = pool.grab();
            try {
                connection.clearGlobalFlag(FLAG_PATH_PREFIX + ZooKeeperConnection.zooKeeperSafeName(flagName));
            }
            finally {
                pool.release(connection);
            }
        }
        catch (InterruptedException e) {
            throw new ManifoldCFException(e.getMessage(), e, 2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean checkGlobalFlag(String flagName) throws ManifoldCFException {
        ZooKeeperConnection connection = pool.grab();
        try {
            boolean bl = connection.checkGlobalFlag(FLAG_PATH_PREFIX + ZooKeeperConnection.zooKeeperSafeName(flagName));
            pool.release(connection);
            return bl;
        }
        catch (Throwable throwable) {
            try {
                pool.release(connection);
                throw throwable;
            }
            catch (InterruptedException e) {
                throw new ManifoldCFException(e.getMessage(), e, 2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] readData(String resourceName) throws ManifoldCFException {
        ZooKeeperConnection connection = pool.grab();
        try {
            byte[] byArray = connection.readData(RESOURCE_PATH_PREFIX + ZooKeeperConnection.zooKeeperSafeName(resourceName));
            pool.release(connection);
            return byArray;
        }
        catch (Throwable throwable) {
            try {
                pool.release(connection);
                throw throwable;
            }
            catch (InterruptedException e) {
                throw new ManifoldCFException(e.getMessage(), e, 2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeData(String resourceName, byte[] data) throws ManifoldCFException {
        try {
            ZooKeeperConnection connection = pool.grab();
            try {
                connection.writeData(RESOURCE_PATH_PREFIX + ZooKeeperConnection.zooKeeperSafeName(resourceName), data);
            }
            finally {
                pool.release(connection);
            }
        }
        catch (InterruptedException e) {
            throw new ManifoldCFException(e.getMessage(), e, 2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] argv) {
        if (argv.length != 1) {
            System.err.println("Usage: ZooKeeperLockManager <shared_configuration_file>");
            System.exit(1);
        }
        File file = new File(argv[0]);
        try {
            IThreadContext tc = ThreadContextFactory.make();
            ManifoldCF.initializeEnvironment(tc);
            try (FileInputStream fis = new FileInputStream(file);){
                new ZooKeeperLockManager().setSharedConfiguration(fis);
            }
            finally {
                ManifoldCF.cleanUpEnvironment(tc);
            }
        }
        catch (Throwable e) {
            e.printStackTrace(System.err);
            System.exit(-1);
        }
    }

    @Override
    protected LockPool getGlobalLockPool() {
        return myZooKeeperLocks;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void shutdownPool() throws ManifoldCFException {
        Integer n = ephemeralPoolLocker;
        synchronized (n) {
            if (myEphemeralNodes != null) {
                try {
                    myEphemeralNodes.deleteAll();
                    myEphemeralNodes = null;
                }
                catch (InterruptedException e) {
                    throw new ManifoldCFException(e.getMessage(), e, 2);
                }
            }
        }
        n = connectionPoolLock;
        synchronized (n) {
            if (pool != null) {
                try {
                    pool.closeAll();
                    pool = null;
                }
                catch (InterruptedException e) {
                    throw new ManifoldCFException(e.getMessage(), e, 2);
                }
            }
        }
    }

    protected static class ZooKeeperShutdown
    implements IShutdownHook {
        @Override
        public void doCleanup(IThreadContext threadContext) throws ManifoldCFException {
            ZooKeeperLockManager.shutdownPool();
        }
    }
}

