/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.sql.compile.Visitable;
import org.apache.derby.iapi.sql.compile.Visitor;
import org.apache.derby.impl.sql.compile.ValueNode;

public class HasVariantValueNodeVisitor
implements Visitor {
    private boolean hasVariant;
    private int variantType;
    private boolean ignoreParameters;

    public HasVariantValueNodeVisitor() {
        this.variantType = 0;
        this.ignoreParameters = false;
    }

    public HasVariantValueNodeVisitor(int n, boolean bl) {
        this.variantType = n;
        this.ignoreParameters = bl;
    }

    public Visitable visit(Visitable visitable) throws StandardException {
        if (visitable instanceof ValueNode) {
            if (this.ignoreParameters && ((ValueNode)visitable).requiresTypeFromContext()) {
                return visitable;
            }
            if (((ValueNode)visitable).getOrderableVariantType() <= this.variantType) {
                this.hasVariant = true;
            }
        }
        return visitable;
    }

    public boolean skipChildren(Visitable visitable) {
        return false;
    }

    public boolean visitChildrenFirst(Visitable visitable) {
        return false;
    }

    public boolean stopTraversal() {
        return this.hasVariant;
    }

    public boolean hasVariant() {
        return this.hasVariant;
    }
}

