/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.jdbc;

import java.security.Permission;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.util.Properties;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.jdbc.BrokeredConnection;
import org.apache.derby.iapi.jdbc.BrokeredConnectionControl;
import org.apache.derby.iapi.security.SecurityUtil;
import org.apache.derby.iapi.services.i18n.MessageService;
import org.apache.derby.iapi.services.io.FormatableProperties;
import org.apache.derby.iapi.services.monitor.Monitor;
import org.apache.derby.iapi.sql.ResultSet;
import org.apache.derby.iapi.util.InterruptStatus;
import org.apache.derby.impl.jdbc.EmbedConnection;
import org.apache.derby.impl.jdbc.EmbedResultSet;
import org.apache.derby.impl.jdbc.EmbedResultSet20;
import org.apache.derby.impl.jdbc.EmbedStatement;
import org.apache.derby.impl.jdbc.Util;
import org.apache.derby.jdbc.AutoloadedDriver;
import org.apache.derby.jdbc.InternalDriver;

public abstract class Driver20
extends InternalDriver
implements Driver {
    private static ThreadPoolExecutor _executorPool = new ThreadPoolExecutor(0, Integer.MAX_VALUE, 60L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>());
    private static final String[] BOOLEAN_CHOICES;
    private Class antiGCDriverManager;
    private static final String driver20 = "driver20";

    public void boot(boolean bl, Properties properties) throws StandardException {
        super.boot(bl, properties);
        AutoloadedDriver.registerDriverModule(this);
        this.antiGCDriverManager = DriverManager.class;
    }

    public void stop() {
        super.stop();
        AutoloadedDriver.unregisterDriverModule();
    }

    public EmbedResultSet newEmbedResultSet(EmbedConnection embedConnection, ResultSet resultSet, boolean bl, EmbedStatement embedStatement, boolean bl2) throws SQLException {
        return new EmbedResultSet20(embedConnection, resultSet, bl, embedStatement, bl2);
    }

    public abstract BrokeredConnection newBrokeredConnection(BrokeredConnectionControl var1) throws SQLException;

    public DriverPropertyInfo[] getPropertyInfo(String string, Properties properties) throws SQLException {
        if (properties != null && Boolean.valueOf(properties.getProperty("shutdown")).booleanValue()) {
            return new DriverPropertyInfo[0];
        }
        String string2 = InternalDriver.getDatabaseName(string, properties);
        FormatableProperties formatableProperties = this.getAttributes(string, properties);
        properties = null;
        boolean bl = Boolean.valueOf(formatableProperties.getProperty("dataEncryption"));
        String string3 = formatableProperties.getProperty("bootPassword");
        if (string2.length() == 0 || bl && string3 == null) {
            String[][] stringArrayArray = new String[][]{{"databaseName", "J004"}, {"encryptionProvider", "J016"}, {"encryptionAlgorithm", "J017"}, {"encryptionKeyLength", "J018"}, {"encryptionKey", "J019"}, {"territory", "J021"}, {"collation", "J031"}, {"user", "J022"}, {"logDevice", "J025"}, {"rollForwardRecoveryFrom", "J028"}, {"createFrom", "J029"}, {"restoreFrom", "J030"}};
            String[][] stringArrayArray2 = new String[][]{{"shutdown", "J005"}, {"deregister", "J006"}, {"create", "J007"}, {"dataEncryption", "J010"}, {"upgrade", "J013"}};
            String[][] stringArrayArray3 = new String[][]{{"bootPassword", "J020"}, {"password", "J023"}};
            DriverPropertyInfo[] driverPropertyInfoArray = new DriverPropertyInfo[stringArrayArray.length + stringArrayArray2.length + stringArrayArray3.length];
            int n = 0;
            int n2 = 0;
            while (n2 < stringArrayArray.length) {
                driverPropertyInfoArray[n] = new DriverPropertyInfo(stringArrayArray[n2][0], formatableProperties.getProperty(stringArrayArray[n2][0]));
                driverPropertyInfoArray[n].description = MessageService.getTextMessage(stringArrayArray[n2][1]);
                ++n2;
                ++n;
            }
            driverPropertyInfoArray[0].choices = Monitor.getMonitor().getServiceList("org.apache.derby.database.Database");
            driverPropertyInfoArray[0].value = string2;
            n2 = 0;
            while (n2 < stringArrayArray3.length) {
                driverPropertyInfoArray[n] = new DriverPropertyInfo(stringArrayArray3[n2][0], formatableProperties.getProperty(stringArrayArray3[n2][0]) == null ? "" : "****");
                driverPropertyInfoArray[n].description = MessageService.getTextMessage(stringArrayArray3[n2][1]);
                ++n2;
                ++n;
            }
            n2 = 0;
            while (n2 < stringArrayArray2.length) {
                driverPropertyInfoArray[n] = new DriverPropertyInfo(stringArrayArray2[n2][0], Boolean.valueOf(formatableProperties == null ? "" : formatableProperties.getProperty(stringArrayArray2[n2][0])).toString());
                driverPropertyInfoArray[n].description = MessageService.getTextMessage(stringArrayArray2[n2][1]);
                driverPropertyInfoArray[n].choices = BOOLEAN_CHOICES;
                ++n2;
                ++n;
            }
            return driverPropertyInfoArray;
        }
        return new DriverPropertyInfo[0];
    }

    public void checkSystemPrivileges(String string, Permission permission) throws Exception {
        SecurityUtil.checkUserHasPermission(string, permission);
    }

    public Connection connect(String string, Properties properties) throws SQLException {
        return this.connect(string, properties, DriverManager.getLoginTimeout());
    }

    protected EmbedConnection timeLogin(String string, Properties properties, int n) throws SQLException {
        try {
            LoginCallable loginCallable = new LoginCallable(this, string, properties);
            Future<EmbedConnection> future = _executorPool.submit(loginCallable);
            long l = System.currentTimeMillis();
            long l2 = l + (long)n * 1000L;
            while (l < l2) {
                try {
                    EmbedConnection embedConnection = future.get(l2 - l, TimeUnit.MILLISECONDS);
                    return embedConnection;
                }
                catch (InterruptedException interruptedException) {
                    InterruptStatus.setInterrupted();
                    l = System.currentTimeMillis();
                }
                catch (ExecutionException executionException) {
                    throw this.processException(executionException);
                }
                catch (TimeoutException timeoutException) {
                    throw Util.generateCsSQLException("XBDA0.C.1");
                }
            }
            throw Util.generateCsSQLException("XBDA0.C.1");
        }
        finally {
            InterruptStatus.restoreIntrFlagIfSeen();
        }
    }

    private SQLException processException(Throwable throwable) {
        Throwable throwable2 = throwable.getCause();
        if (!(throwable2 instanceof SQLException)) {
            return Util.javaException(throwable);
        }
        return (SQLException)throwable2;
    }

    static {
        _executorPool.setThreadFactory(new DaemonThreadFactory());
        BOOLEAN_CHOICES = new String[]{"false", "true"};
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class LoginCallable
    implements Callable<EmbedConnection> {
        private Driver20 _driver;
        private String _url;
        private Properties _info;

        public LoginCallable(Driver20 driver20, String string, Properties properties) {
            this._driver = driver20;
            this._url = string;
            this._info = properties;
        }

        @Override
        public EmbedConnection call() throws SQLException {
            String string = this._url;
            Properties properties = this._info;
            Driver20 driver20 = this._driver;
            this._url = null;
            this._info = null;
            this._driver = null;
            return driver20.getNewEmbedConnection(string, properties);
        }
    }

    private static final class DaemonThreadFactory
    implements ThreadFactory {
        private DaemonThreadFactory() {
        }

        public Thread newThread(Runnable runnable) {
            Thread thread = new Thread(runnable);
            thread.setDaemon(true);
            return thread;
        }
    }
}

