/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.mp4parser.boxes.mp4.objectdescriptors;

import com.coremedia.iso.Hex;
import com.coremedia.iso.IsoTypeWriter;
import com.googlecode.mp4parser.boxes.mp4.objectdescriptors.BaseDescriptor;
import com.googlecode.mp4parser.boxes.mp4.objectdescriptors.BitReaderBuffer;
import com.googlecode.mp4parser.boxes.mp4.objectdescriptors.BitWriterBuffer;
import com.googlecode.mp4parser.boxes.mp4.objectdescriptors.Descriptor;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;

@Descriptor(tags={5}, objectTypeIndication=64)
public class AudioSpecificConfig
extends BaseDescriptor {
    byte[] configBytes;
    public static Map<Integer, Integer> samplingFrequencyIndexMap = new HashMap<Integer, Integer>();
    public static Map<Integer, String> audioObjectTypeMap = new HashMap<Integer, String>();
    int audioObjectType;
    int samplingFrequencyIndex;
    int samplingFrequency;
    int channelConfiguration;
    int extensionAudioObjectType;
    int sbrPresentFlag;
    int psPresentFlag;
    int extensionSamplingFrequencyIndex;
    int extensionSamplingFrequency;
    int extensionChannelConfiguration;
    int sacPayloadEmbedding;
    int fillBits;
    int epConfig;
    int directMapping;
    int syncExtensionType;
    int frameLengthFlag;
    int dependsOnCoreCoder;
    int coreCoderDelay;
    int extensionFlag;
    int layerNr;
    int numOfSubFrame;
    int layer_length;
    int aacSectionDataResilienceFlag;
    int aacScalefactorDataResilienceFlag;
    int aacSpectralDataResilienceFlag;
    int extensionFlag3;
    boolean gaSpecificConfig;
    int isBaseLayer;
    int paraMode;
    int paraExtensionFlag;
    int hvxcVarMode;
    int hvxcRateMode;
    int erHvxcExtensionFlag;
    int var_ScalableFlag;
    int hilnQuantMode;
    int hilnMaxNumLine;
    int hilnSampleRateCode;
    int hilnFrameLength;
    int hilnContMode;
    int hilnEnhaLayer;
    int hilnEnhaQuantMode;
    boolean parametricSpecificConfig;

    static {
        samplingFrequencyIndexMap.put(0, 96000);
        samplingFrequencyIndexMap.put(1, 88200);
        samplingFrequencyIndexMap.put(2, 64000);
        samplingFrequencyIndexMap.put(3, 48000);
        samplingFrequencyIndexMap.put(4, 44100);
        samplingFrequencyIndexMap.put(5, 32000);
        samplingFrequencyIndexMap.put(6, 24000);
        samplingFrequencyIndexMap.put(7, 22050);
        samplingFrequencyIndexMap.put(8, 16000);
        samplingFrequencyIndexMap.put(9, 12000);
        samplingFrequencyIndexMap.put(10, 11025);
        samplingFrequencyIndexMap.put(11, 8000);
        audioObjectTypeMap.put(1, "AAC main");
        audioObjectTypeMap.put(2, "AAC LC");
        audioObjectTypeMap.put(3, "AAC SSR");
        audioObjectTypeMap.put(4, "AAC LTP");
        audioObjectTypeMap.put(5, "SBR");
        audioObjectTypeMap.put(6, "AAC Scalable");
        audioObjectTypeMap.put(7, "TwinVQ");
        audioObjectTypeMap.put(8, "CELP");
        audioObjectTypeMap.put(9, "HVXC");
        audioObjectTypeMap.put(10, "(reserved)");
        audioObjectTypeMap.put(11, "(reserved)");
        audioObjectTypeMap.put(12, "TTSI");
        audioObjectTypeMap.put(13, "Main synthetic");
        audioObjectTypeMap.put(14, "Wavetable synthesis");
        audioObjectTypeMap.put(15, "General MIDI");
        audioObjectTypeMap.put(16, "Algorithmic Synthesis and Audio FX");
        audioObjectTypeMap.put(17, "ER AAC LC");
        audioObjectTypeMap.put(18, "(reserved)");
        audioObjectTypeMap.put(19, "ER AAC LTP");
        audioObjectTypeMap.put(20, "ER AAC Scalable");
        audioObjectTypeMap.put(21, "ER TwinVQ");
        audioObjectTypeMap.put(22, "ER BSAC");
        audioObjectTypeMap.put(23, "ER AAC LD");
        audioObjectTypeMap.put(24, "ER CELP");
        audioObjectTypeMap.put(25, "ER HVXC");
        audioObjectTypeMap.put(26, "ER HILN");
        audioObjectTypeMap.put(27, "ER Parametric");
        audioObjectTypeMap.put(28, "SSC");
        audioObjectTypeMap.put(29, "PS");
        audioObjectTypeMap.put(30, "MPEG Surround");
        audioObjectTypeMap.put(31, "(escape)");
        audioObjectTypeMap.put(32, "Layer-1");
        audioObjectTypeMap.put(33, "Layer-2");
        audioObjectTypeMap.put(34, "Layer-3");
        audioObjectTypeMap.put(35, "DST");
        audioObjectTypeMap.put(36, "ALS");
        audioObjectTypeMap.put(37, "SLS");
        audioObjectTypeMap.put(38, "SLS non-core");
        audioObjectTypeMap.put(39, "ER AAC ELD");
        audioObjectTypeMap.put(40, "SMR Simple");
        audioObjectTypeMap.put(41, "SMR Main");
    }

    public void parseDetail(ByteBuffer bb) throws IOException {
        ByteBuffer configBytes = bb.slice();
        configBytes.limit(this.sizeOfInstance);
        bb.position(bb.position() + this.sizeOfInstance);
        this.configBytes = new byte[this.sizeOfInstance];
        configBytes.get(this.configBytes);
        configBytes.rewind();
        BitReaderBuffer bitReaderBuffer = new BitReaderBuffer(configBytes);
        this.audioObjectType = this.getAudioObjectType(bitReaderBuffer);
        this.samplingFrequencyIndex = bitReaderBuffer.readBits(4);
        if (this.samplingFrequencyIndex == 15) {
            this.samplingFrequency = bitReaderBuffer.readBits(24);
        }
        this.channelConfiguration = bitReaderBuffer.readBits(4);
        if (this.audioObjectType == 5 || this.audioObjectType == 29) {
            this.extensionAudioObjectType = 5;
            this.sbrPresentFlag = 1;
            if (this.audioObjectType == 29) {
                this.psPresentFlag = 1;
            }
            this.extensionSamplingFrequencyIndex = bitReaderBuffer.readBits(4);
            if (this.extensionSamplingFrequencyIndex == 15) {
                this.extensionSamplingFrequency = bitReaderBuffer.readBits(24);
            }
            this.audioObjectType = this.getAudioObjectType(bitReaderBuffer);
            if (this.audioObjectType == 22) {
                this.extensionChannelConfiguration = bitReaderBuffer.readBits(4);
            }
        } else {
            this.extensionAudioObjectType = 0;
        }
        switch (this.audioObjectType) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 17: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: {
                this.parseGaSpecificConfig(this.samplingFrequencyIndex, this.channelConfiguration, this.audioObjectType, bitReaderBuffer);
                break;
            }
            case 8: {
                throw new UnsupportedOperationException("can't parse CelpSpecificConfig yet");
            }
            case 9: {
                throw new UnsupportedOperationException("can't parse HvxcSpecificConfig yet");
            }
            case 12: {
                throw new UnsupportedOperationException("can't parse TTSSpecificConfig yet");
            }
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                throw new UnsupportedOperationException("can't parse StructuredAudioSpecificConfig yet");
            }
            case 24: {
                throw new UnsupportedOperationException("can't parse ErrorResilientCelpSpecificConfig yet");
            }
            case 25: {
                throw new UnsupportedOperationException("can't parse ErrorResilientHvxcSpecificConfig yet");
            }
            case 26: 
            case 27: {
                this.parseParametricSpecificConfig(this.samplingFrequencyIndex, this.channelConfiguration, this.audioObjectType, bitReaderBuffer);
                break;
            }
            case 28: {
                throw new UnsupportedOperationException("can't parse SSCSpecificConfig yet");
            }
            case 30: {
                this.sacPayloadEmbedding = bitReaderBuffer.readBits(1);
                throw new UnsupportedOperationException("can't parse SpatialSpecificConfig yet");
            }
            case 32: 
            case 33: 
            case 34: {
                throw new UnsupportedOperationException("can't parse MPEG_1_2_SpecificConfig yet");
            }
            case 35: {
                throw new UnsupportedOperationException("can't parse DSTSpecificConfig yet");
            }
            case 36: {
                this.fillBits = bitReaderBuffer.readBits(5);
                throw new UnsupportedOperationException("can't parse ALSSpecificConfig yet");
            }
            case 37: 
            case 38: {
                throw new UnsupportedOperationException("can't parse SLSSpecificConfig yet");
            }
            case 39: {
                throw new UnsupportedOperationException("can't parse ELDSpecificConfig yet");
            }
            case 40: 
            case 41: {
                throw new UnsupportedOperationException("can't parse SymbolicMusicSpecificConfig yet");
            }
        }
        switch (this.audioObjectType) {
            case 17: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 39: {
                this.epConfig = bitReaderBuffer.readBits(2);
                if (this.epConfig == 2 || this.epConfig == 3) {
                    throw new UnsupportedOperationException("can't parse ErrorProtectionSpecificConfig yet");
                }
                if (this.epConfig != 3) break;
                this.directMapping = bitReaderBuffer.readBits(1);
                if (this.directMapping != 0) break;
                throw new RuntimeException("not implemented");
            }
        }
        if (this.extensionAudioObjectType != 5 && bitReaderBuffer.remainingBits() >= 16) {
            this.syncExtensionType = bitReaderBuffer.readBits(11);
            if (this.syncExtensionType == 695) {
                this.extensionAudioObjectType = this.getAudioObjectType(bitReaderBuffer);
                if (this.extensionAudioObjectType == 5) {
                    this.sbrPresentFlag = bitReaderBuffer.readBits(1);
                    if (this.sbrPresentFlag == 1) {
                        this.extensionSamplingFrequencyIndex = bitReaderBuffer.readBits(4);
                        if (this.extensionSamplingFrequencyIndex == 15) {
                            this.extensionSamplingFrequency = bitReaderBuffer.readBits(24);
                        }
                        if (bitReaderBuffer.remainingBits() >= 12) {
                            this.syncExtensionType = bitReaderBuffer.readBits(11);
                            if (this.syncExtensionType == 1352) {
                                this.psPresentFlag = bitReaderBuffer.readBits(1);
                            }
                        }
                    }
                }
                if (this.extensionAudioObjectType == 22) {
                    this.sbrPresentFlag = bitReaderBuffer.readBits(1);
                    if (this.sbrPresentFlag == 1) {
                        this.extensionSamplingFrequencyIndex = bitReaderBuffer.readBits(4);
                        if (this.extensionSamplingFrequencyIndex == 15) {
                            this.extensionSamplingFrequency = bitReaderBuffer.readBits(24);
                        }
                    }
                    this.extensionChannelConfiguration = bitReaderBuffer.readBits(4);
                }
            }
        }
    }

    private int gaSpecificConfigSize() {
        return 0;
    }

    public int serializedSize() {
        int out = 4;
        if (this.audioObjectType != 2) {
            throw new UnsupportedOperationException("can't serialize that yet");
        }
        return out += this.gaSpecificConfigSize();
    }

    public ByteBuffer serialize() {
        ByteBuffer out = ByteBuffer.allocate(this.serializedSize());
        IsoTypeWriter.writeUInt8(out, 5);
        IsoTypeWriter.writeUInt8(out, this.serializedSize() - 2);
        BitWriterBuffer bwb = new BitWriterBuffer(out);
        bwb.writeBits(this.audioObjectType, 5);
        bwb.writeBits(this.samplingFrequencyIndex, 4);
        if (this.samplingFrequencyIndex == 15) {
            throw new UnsupportedOperationException("can't serialize that yet");
        }
        bwb.writeBits(this.channelConfiguration, 4);
        return out;
    }

    private int getAudioObjectType(BitReaderBuffer in) throws IOException {
        int audioObjectType = in.readBits(5);
        if (audioObjectType == 31) {
            audioObjectType = 32 + in.readBits(6);
        }
        return audioObjectType;
    }

    private void parseGaSpecificConfig(int samplingFrequencyIndex, int channelConfiguration, int audioObjectType, BitReaderBuffer in) throws IOException {
        this.frameLengthFlag = in.readBits(1);
        this.dependsOnCoreCoder = in.readBits(1);
        if (this.dependsOnCoreCoder == 1) {
            this.coreCoderDelay = in.readBits(14);
        }
        this.extensionFlag = in.readBits(1);
        if (channelConfiguration == 0) {
            throw new UnsupportedOperationException("can't parse program_config_element yet");
        }
        if (audioObjectType == 6 || audioObjectType == 20) {
            this.layerNr = in.readBits(3);
        }
        if (this.extensionFlag == 1) {
            if (audioObjectType == 22) {
                this.numOfSubFrame = in.readBits(5);
                this.layer_length = in.readBits(11);
            }
            if (audioObjectType == 17 || audioObjectType == 19 || audioObjectType == 20 || audioObjectType == 23) {
                this.aacSectionDataResilienceFlag = in.readBits(1);
                this.aacScalefactorDataResilienceFlag = in.readBits(1);
                this.aacSpectralDataResilienceFlag = in.readBits(1);
            }
            this.extensionFlag3 = in.readBits(1);
        }
        this.gaSpecificConfig = true;
    }

    private void parseParametricSpecificConfig(int samplingFrequencyIndex, int channelConfiguration, int audioObjectType, BitReaderBuffer in) throws IOException {
        this.isBaseLayer = in.readBits(1);
        if (this.isBaseLayer == 1) {
            this.parseParaConfig(samplingFrequencyIndex, channelConfiguration, audioObjectType, in);
        } else {
            this.parseHilnEnexConfig(samplingFrequencyIndex, channelConfiguration, audioObjectType, in);
        }
    }

    private void parseParaConfig(int samplingFrequencyIndex, int channelConfiguration, int audioObjectType, BitReaderBuffer in) throws IOException {
        this.paraMode = in.readBits(2);
        if (this.paraMode != 1) {
            this.parseErHvxcConfig(samplingFrequencyIndex, channelConfiguration, audioObjectType, in);
        }
        if (this.paraMode != 0) {
            this.parseHilnConfig(samplingFrequencyIndex, channelConfiguration, audioObjectType, in);
        }
        this.paraExtensionFlag = in.readBits(1);
        this.parametricSpecificConfig = true;
    }

    private void parseErHvxcConfig(int samplingFrequencyIndex, int channelConfiguration, int audioObjectType, BitReaderBuffer in) throws IOException {
        this.hvxcVarMode = in.readBits(1);
        this.hvxcRateMode = in.readBits(2);
        this.erHvxcExtensionFlag = in.readBits(1);
        if (this.erHvxcExtensionFlag == 1) {
            this.var_ScalableFlag = in.readBits(1);
        }
    }

    private void parseHilnConfig(int samplingFrequencyIndex, int channelConfiguration, int audioObjectType, BitReaderBuffer in) throws IOException {
        this.hilnQuantMode = in.readBits(1);
        this.hilnMaxNumLine = in.readBits(8);
        this.hilnSampleRateCode = in.readBits(4);
        this.hilnFrameLength = in.readBits(12);
        this.hilnContMode = in.readBits(2);
    }

    private void parseHilnEnexConfig(int samplingFrequencyIndex, int channelConfiguration, int audioObjectType, BitReaderBuffer in) throws IOException {
        this.hilnEnhaLayer = in.readBits(1);
        if (this.hilnEnhaLayer == 1) {
            this.hilnEnhaQuantMode = in.readBits(2);
        }
    }

    public byte[] getConfigBytes() {
        return this.configBytes;
    }

    public int getAudioObjectType() {
        return this.audioObjectType;
    }

    public int getExtensionAudioObjectType() {
        return this.extensionAudioObjectType;
    }

    public int getSbrPresentFlag() {
        return this.sbrPresentFlag;
    }

    public int getPsPresentFlag() {
        return this.psPresentFlag;
    }

    public void setAudioObjectType(int audioObjectType) {
        this.audioObjectType = audioObjectType;
    }

    public void setSamplingFrequencyIndex(int samplingFrequencyIndex) {
        this.samplingFrequencyIndex = samplingFrequencyIndex;
    }

    public void setSamplingFrequency(int samplingFrequency) {
        this.samplingFrequency = samplingFrequency;
    }

    public void setChannelConfiguration(int channelConfiguration) {
        this.channelConfiguration = channelConfiguration;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("AudioSpecificConfig");
        sb.append("{configBytes=").append(Hex.encodeHex(this.configBytes));
        sb.append(", audioObjectType=").append(this.audioObjectType).append(" (").append(audioObjectTypeMap.get(this.audioObjectType)).append(")");
        sb.append(", samplingFrequencyIndex=").append(this.samplingFrequencyIndex).append(" (").append(samplingFrequencyIndexMap.get(this.samplingFrequencyIndex)).append(")");
        sb.append(", samplingFrequency=").append(this.samplingFrequency);
        sb.append(", channelConfiguration=").append(this.channelConfiguration);
        if (this.extensionAudioObjectType > 0) {
            sb.append(", extensionAudioObjectType=").append(this.extensionAudioObjectType).append(" (").append(audioObjectTypeMap.get(this.extensionAudioObjectType)).append(")");
            sb.append(", sbrPresentFlag=").append(this.sbrPresentFlag);
            sb.append(", psPresentFlag=").append(this.psPresentFlag);
            sb.append(", extensionSamplingFrequencyIndex=").append(this.extensionSamplingFrequencyIndex).append(" (").append(samplingFrequencyIndexMap.get(this.extensionSamplingFrequencyIndex)).append(")");
            sb.append(", extensionSamplingFrequency=").append(this.extensionSamplingFrequency);
            sb.append(", extensionChannelConfiguration=").append(this.extensionChannelConfiguration);
        }
        sb.append(", syncExtensionType=").append(this.syncExtensionType);
        if (this.gaSpecificConfig) {
            sb.append(", frameLengthFlag=").append(this.frameLengthFlag);
            sb.append(", dependsOnCoreCoder=").append(this.dependsOnCoreCoder);
            sb.append(", coreCoderDelay=").append(this.coreCoderDelay);
            sb.append(", extensionFlag=").append(this.extensionFlag);
            sb.append(", layerNr=").append(this.layerNr);
            sb.append(", numOfSubFrame=").append(this.numOfSubFrame);
            sb.append(", layer_length=").append(this.layer_length);
            sb.append(", aacSectionDataResilienceFlag=").append(this.aacSectionDataResilienceFlag);
            sb.append(", aacScalefactorDataResilienceFlag=").append(this.aacScalefactorDataResilienceFlag);
            sb.append(", aacSpectralDataResilienceFlag=").append(this.aacSpectralDataResilienceFlag);
            sb.append(", extensionFlag3=").append(this.extensionFlag3);
        }
        if (this.parametricSpecificConfig) {
            sb.append(", isBaseLayer=").append(this.isBaseLayer);
            sb.append(", paraMode=").append(this.paraMode);
            sb.append(", paraExtensionFlag=").append(this.paraExtensionFlag);
            sb.append(", hvxcVarMode=").append(this.hvxcVarMode);
            sb.append(", hvxcRateMode=").append(this.hvxcRateMode);
            sb.append(", erHvxcExtensionFlag=").append(this.erHvxcExtensionFlag);
            sb.append(", var_ScalableFlag=").append(this.var_ScalableFlag);
            sb.append(", hilnQuantMode=").append(this.hilnQuantMode);
            sb.append(", hilnMaxNumLine=").append(this.hilnMaxNumLine);
            sb.append(", hilnSampleRateCode=").append(this.hilnSampleRateCode);
            sb.append(", hilnFrameLength=").append(this.hilnFrameLength);
            sb.append(", hilnContMode=").append(this.hilnContMode);
            sb.append(", hilnEnhaLayer=").append(this.hilnEnhaLayer);
            sb.append(", hilnEnhaQuantMode=").append(this.hilnEnhaQuantMode);
        }
        sb.append('}');
        return sb.toString();
    }

    public int getSamplingFrequency() {
        return this.samplingFrequencyIndex == 15 ? this.samplingFrequency : samplingFrequencyIndexMap.get(this.samplingFrequencyIndex);
    }

    public int getChannelConfiguration() {
        return this.channelConfiguration;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AudioSpecificConfig that = (AudioSpecificConfig)o;
        if (this.aacScalefactorDataResilienceFlag != that.aacScalefactorDataResilienceFlag) {
            return false;
        }
        if (this.aacSectionDataResilienceFlag != that.aacSectionDataResilienceFlag) {
            return false;
        }
        if (this.aacSpectralDataResilienceFlag != that.aacSpectralDataResilienceFlag) {
            return false;
        }
        if (this.audioObjectType != that.audioObjectType) {
            return false;
        }
        if (this.channelConfiguration != that.channelConfiguration) {
            return false;
        }
        if (this.coreCoderDelay != that.coreCoderDelay) {
            return false;
        }
        if (this.dependsOnCoreCoder != that.dependsOnCoreCoder) {
            return false;
        }
        if (this.directMapping != that.directMapping) {
            return false;
        }
        if (this.epConfig != that.epConfig) {
            return false;
        }
        if (this.erHvxcExtensionFlag != that.erHvxcExtensionFlag) {
            return false;
        }
        if (this.extensionAudioObjectType != that.extensionAudioObjectType) {
            return false;
        }
        if (this.extensionChannelConfiguration != that.extensionChannelConfiguration) {
            return false;
        }
        if (this.extensionFlag != that.extensionFlag) {
            return false;
        }
        if (this.extensionFlag3 != that.extensionFlag3) {
            return false;
        }
        if (this.extensionSamplingFrequency != that.extensionSamplingFrequency) {
            return false;
        }
        if (this.extensionSamplingFrequencyIndex != that.extensionSamplingFrequencyIndex) {
            return false;
        }
        if (this.fillBits != that.fillBits) {
            return false;
        }
        if (this.frameLengthFlag != that.frameLengthFlag) {
            return false;
        }
        if (this.gaSpecificConfig != that.gaSpecificConfig) {
            return false;
        }
        if (this.hilnContMode != that.hilnContMode) {
            return false;
        }
        if (this.hilnEnhaLayer != that.hilnEnhaLayer) {
            return false;
        }
        if (this.hilnEnhaQuantMode != that.hilnEnhaQuantMode) {
            return false;
        }
        if (this.hilnFrameLength != that.hilnFrameLength) {
            return false;
        }
        if (this.hilnMaxNumLine != that.hilnMaxNumLine) {
            return false;
        }
        if (this.hilnQuantMode != that.hilnQuantMode) {
            return false;
        }
        if (this.hilnSampleRateCode != that.hilnSampleRateCode) {
            return false;
        }
        if (this.hvxcRateMode != that.hvxcRateMode) {
            return false;
        }
        if (this.hvxcVarMode != that.hvxcVarMode) {
            return false;
        }
        if (this.isBaseLayer != that.isBaseLayer) {
            return false;
        }
        if (this.layerNr != that.layerNr) {
            return false;
        }
        if (this.layer_length != that.layer_length) {
            return false;
        }
        if (this.numOfSubFrame != that.numOfSubFrame) {
            return false;
        }
        if (this.paraExtensionFlag != that.paraExtensionFlag) {
            return false;
        }
        if (this.paraMode != that.paraMode) {
            return false;
        }
        if (this.parametricSpecificConfig != that.parametricSpecificConfig) {
            return false;
        }
        if (this.psPresentFlag != that.psPresentFlag) {
            return false;
        }
        if (this.sacPayloadEmbedding != that.sacPayloadEmbedding) {
            return false;
        }
        if (this.samplingFrequency != that.samplingFrequency) {
            return false;
        }
        if (this.samplingFrequencyIndex != that.samplingFrequencyIndex) {
            return false;
        }
        if (this.sbrPresentFlag != that.sbrPresentFlag) {
            return false;
        }
        if (this.syncExtensionType != that.syncExtensionType) {
            return false;
        }
        if (this.var_ScalableFlag != that.var_ScalableFlag) {
            return false;
        }
        return Arrays.equals(this.configBytes, that.configBytes);
    }

    public int hashCode() {
        int result = this.configBytes != null ? Arrays.hashCode(this.configBytes) : 0;
        result = 31 * result + this.audioObjectType;
        result = 31 * result + this.samplingFrequencyIndex;
        result = 31 * result + this.samplingFrequency;
        result = 31 * result + this.channelConfiguration;
        result = 31 * result + this.extensionAudioObjectType;
        result = 31 * result + this.sbrPresentFlag;
        result = 31 * result + this.psPresentFlag;
        result = 31 * result + this.extensionSamplingFrequencyIndex;
        result = 31 * result + this.extensionSamplingFrequency;
        result = 31 * result + this.extensionChannelConfiguration;
        result = 31 * result + this.sacPayloadEmbedding;
        result = 31 * result + this.fillBits;
        result = 31 * result + this.epConfig;
        result = 31 * result + this.directMapping;
        result = 31 * result + this.syncExtensionType;
        result = 31 * result + this.frameLengthFlag;
        result = 31 * result + this.dependsOnCoreCoder;
        result = 31 * result + this.coreCoderDelay;
        result = 31 * result + this.extensionFlag;
        result = 31 * result + this.layerNr;
        result = 31 * result + this.numOfSubFrame;
        result = 31 * result + this.layer_length;
        result = 31 * result + this.aacSectionDataResilienceFlag;
        result = 31 * result + this.aacScalefactorDataResilienceFlag;
        result = 31 * result + this.aacSpectralDataResilienceFlag;
        result = 31 * result + this.extensionFlag3;
        result = 31 * result + (this.gaSpecificConfig ? 1 : 0);
        result = 31 * result + this.isBaseLayer;
        result = 31 * result + this.paraMode;
        result = 31 * result + this.paraExtensionFlag;
        result = 31 * result + this.hvxcVarMode;
        result = 31 * result + this.hvxcRateMode;
        result = 31 * result + this.erHvxcExtensionFlag;
        result = 31 * result + this.var_ScalableFlag;
        result = 31 * result + this.hilnQuantMode;
        result = 31 * result + this.hilnMaxNumLine;
        result = 31 * result + this.hilnSampleRateCode;
        result = 31 * result + this.hilnFrameLength;
        result = 31 * result + this.hilnContMode;
        result = 31 * result + this.hilnEnhaLayer;
        result = 31 * result + this.hilnEnhaQuantMode;
        result = 31 * result + (this.parametricSpecificConfig ? 1 : 0);
        return result;
    }
}

