/*
 * Decompiled with CFR 0.152.
 */
package org.jcp.xml.dsig.internal;

import java.security.InvalidKeyException;
import java.security.Key;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SignatureException;
import java.util.logging.Level;
import java.util.logging.Logger;

public class HmacSHA1 {
    private static Logger log = Logger.getLogger("org.jcp.xml.dsig.internal");
    private static final int SHA1_BLOCK = 64;
    private byte[] key_opad;
    private MessageDigest digest;
    private int byte_length;

    public void init(Key key, int n) throws InvalidKeyException {
        if (key == null) {
            throw new InvalidKeyException("The key should not be null");
        }
        try {
            this.digest = MessageDigest.getInstance("SHA1");
            this.initialize(key);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new InvalidKeyException("SHA1 not supported");
        }
        this.byte_length = n > 0 ? n / 8 : -1;
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, "byte_length: " + this.byte_length);
        }
    }

    public void update(byte[] byArray) {
        this.digest.update(byArray);
    }

    public void update(byte by) {
        this.digest.update(by);
    }

    public void update(byte[] byArray, int n, int n2) {
        this.digest.update(byArray, n, n2);
    }

    public byte[] sign() throws SignatureException {
        if (this.byte_length == 0) {
            throw new SignatureException("length should be -1 or greater than zero, but is " + this.byte_length);
        }
        byte[] byArray = this.digest.digest();
        this.digest.reset();
        this.digest.update(this.key_opad);
        this.digest.update(byArray);
        byte[] byArray2 = this.digest.digest();
        if (this.byte_length > 0 && byArray2.length > this.byte_length) {
            byte[] byArray3 = new byte[this.byte_length];
            System.arraycopy(byArray2, 0, byArray3, 0, this.byte_length);
            byArray2 = byArray3;
        }
        return byArray2;
    }

    public boolean verify(byte[] byArray) throws SignatureException {
        return MessageDigest.isEqual(byArray, this.sign());
    }

    private void initialize(Key key) {
        byte[] byArray = key.getEncoded();
        byte[] byArray2 = new byte[64];
        if (byArray.length > 64) {
            this.digest.reset();
            byArray = this.digest.digest(byArray);
        }
        System.arraycopy(byArray, 0, byArray2, 0, byArray.length);
        for (int i = byArray.length; i < 64; ++i) {
            byArray2[i] = 0;
        }
        byte[] byArray3 = new byte[64];
        this.key_opad = new byte[64];
        for (int i = 0; i < 64; ++i) {
            byArray3[i] = (byte)(byArray2[i] ^ 0x36);
            this.key_opad[i] = (byte)(byArray2[i] ^ 0x5C);
        }
        this.digest.reset();
        this.digest.update(byArray3);
    }
}

