/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb;

import com.mongodb.Mongo;
import com.mongodb.MongoAuthority;
import com.mongodb.MongoClientOptions;
import com.mongodb.MongoClientURI;
import com.mongodb.MongoCredential;
import com.mongodb.MongoCredentialsStore;
import com.mongodb.MongoOptions;
import com.mongodb.MongoURI;
import com.mongodb.ServerAddress;
import java.net.UnknownHostException;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MongoClient
extends Mongo {
    private final MongoClientOptions options;

    public MongoClient() throws UnknownHostException {
        this(new ServerAddress());
    }

    public MongoClient(String host) throws UnknownHostException {
        this(new ServerAddress(host));
    }

    public MongoClient(String host, MongoClientOptions options) throws UnknownHostException {
        this(new ServerAddress(host), options);
    }

    public MongoClient(String host, int port) throws UnknownHostException {
        this(new ServerAddress(host, port));
    }

    public MongoClient(ServerAddress addr) {
        this(addr, new MongoClientOptions.Builder().build());
    }

    public MongoClient(ServerAddress addr, List<MongoCredential> credentialsList) {
        this(addr, credentialsList, new MongoClientOptions.Builder().build());
    }

    public MongoClient(ServerAddress addr, MongoClientOptions options) {
        this(addr, null, options);
    }

    public MongoClient(ServerAddress addr, List<MongoCredential> credentialsList, MongoClientOptions options) {
        super(MongoAuthority.direct(addr, new MongoCredentialsStore(credentialsList)), new MongoOptions(options));
        this.options = options;
    }

    public MongoClient(List<ServerAddress> seeds) {
        this(seeds, null, new MongoClientOptions.Builder().build());
    }

    public MongoClient(List<ServerAddress> seeds, List<MongoCredential> credentialsList) {
        this(seeds, credentialsList, new MongoClientOptions.Builder().build());
    }

    public MongoClient(List<ServerAddress> seeds, MongoClientOptions options) {
        this(seeds, null, options);
    }

    public MongoClient(List<ServerAddress> seeds, List<MongoCredential> credentialsList, MongoClientOptions options) {
        super(MongoAuthority.dynamicSet(seeds, new MongoCredentialsStore(credentialsList)), new MongoOptions(options));
        this.options = options;
    }

    public MongoClient(MongoClientURI uri) throws UnknownHostException {
        super(new MongoURI(uri));
        this.options = uri.getOptions();
    }

    public List<MongoCredential> getCredentialsList() {
        return this.getAuthority().getCredentialsStore().asList();
    }

    public MongoClientOptions getMongoClientOptions() {
        return this.options;
    }
}

