/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.rtf;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.apache.tika.exception.TikaException;
import org.apache.tika.exception.TikaMemoryLimitException;
import org.apache.tika.extractor.EmbeddedDocumentUtil;
import org.apache.tika.io.TikaInputStream;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.metadata.RTFMetadata;
import org.apache.tika.metadata.TikaCoreProperties;
import org.apache.tika.parser.ParseContext;
import org.apache.tika.parser.rtf.RTFObjDataParser;
import org.apache.tika.parser.rtf.TextExtractor;
import org.apache.tika.sax.EmbeddedContentHandler;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

class RTFEmbObjHandler {
    private static final String EMPTY_STRING = "";
    private final ContentHandler handler;
    private final EmbeddedDocumentUtil embeddedDocumentUtil;
    private final ByteArrayOutputStream os;
    private int hi = -1;
    private int thumbCount = 0;
    private AtomicInteger unknownFilenameCount = new AtomicInteger();
    private boolean inObject = false;
    private String sv = "";
    private String sn = "";
    private StringBuilder sb = new StringBuilder();
    private Metadata metadata;
    private EMB_STATE state = EMB_STATE.NADA;
    private final int memoryLimitInKb;

    protected RTFEmbObjHandler(ContentHandler handler, Metadata metadata, ParseContext context, int memoryLimitInKb) {
        this.handler = handler;
        this.embeddedDocumentUtil = new EmbeddedDocumentUtil(context);
        this.os = new ByteArrayOutputStream();
        this.memoryLimitInKb = memoryLimitInKb;
    }

    protected void startPict() {
        this.state = EMB_STATE.PICT;
        this.metadata = new Metadata();
    }

    protected void startObjData() {
        this.state = EMB_STATE.OBJDATA;
        this.metadata = new Metadata();
    }

    protected void startSN() {
        this.sb.setLength(0);
        this.sb.append("rtf_pict:");
    }

    protected void endSN() {
        this.sn = this.sb.toString();
    }

    protected void startSV() {
        this.sb.setLength(0);
    }

    protected void endSV() {
        this.sv = this.sb.toString();
    }

    protected void endSP() {
        this.metadata.add(this.sn, this.sv);
    }

    protected boolean getInObject() {
        return this.inObject;
    }

    protected void setInObject(boolean v) {
        this.inObject = v;
    }

    protected void writeMetadataChar(char c) {
        this.sb.append(c);
    }

    protected void writeHexChar(int b) throws IOException, TikaException {
        if (TextExtractor.isHexChar(b)) {
            if (this.hi == -1) {
                this.hi = 16 * TextExtractor.hexValue(b);
            } else {
                long sum = this.hi + TextExtractor.hexValue(b);
                if (sum > Integer.MAX_VALUE || sum < 0L) {
                    throw new IOException("hex char to byte overflow");
                }
                this.os.write((int)sum);
                this.hi = -1;
            }
            return;
        }
        if (b == -1) {
            throw new TikaException("hit end of stream before finishing byte pair");
        }
    }

    protected void writeBytes(InputStream is, int len) throws IOException, TikaException {
        if (len < 0) {
            throw new TikaException("Requesting I read < 0 bytes ?!");
        }
        if (len > this.memoryLimitInKb * 1024) {
            throw new TikaMemoryLimitException((long)len, (long)(this.memoryLimitInKb * 1024));
        }
        byte[] bytes = new byte[len];
        IOUtils.readFully((InputStream)is, (byte[])bytes);
        this.os.write(bytes);
    }

    protected void handleCompletedObject() throws IOException, SAXException, TikaException {
        byte[] bytes = this.os.toByteArray();
        if (this.state == EMB_STATE.OBJDATA) {
            RTFObjDataParser objParser = new RTFObjDataParser(this.memoryLimitInKb);
            try {
                byte[] objBytes = objParser.parse(bytes, this.metadata, this.unknownFilenameCount);
                this.extractObj(objBytes, this.handler, this.metadata);
            }
            catch (IOException e) {
                EmbeddedDocumentUtil.recordException((Throwable)e, (Metadata)this.metadata);
            }
        } else if (this.state == EMB_STATE.PICT) {
            String filePath = this.metadata.get("rtf_pict:wzDescription");
            if (filePath != null && filePath.length() > 0) {
                this.metadata.set("embeddedRelationshipId", filePath);
                this.metadata.set("resourceName", FilenameUtils.getName((String)filePath));
                this.metadata.set(TikaCoreProperties.ORIGINAL_RESOURCE_NAME, filePath);
            }
            this.metadata.set(RTFMetadata.THUMBNAIL, Boolean.toString(this.inObject));
            this.extractObj(bytes, this.handler, this.metadata);
        } else if (this.state == EMB_STATE.NADA) {
            // empty if block
        }
        this.reset();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void extractObj(byte[] bytes, ContentHandler handler, Metadata metadata) throws SAXException, IOException, TikaException {
        if (bytes == null) {
            return;
        }
        metadata.set("Content-Length", Integer.toString(bytes.length));
        if (this.embeddedDocumentUtil.shouldParseEmbedded(metadata)) {
            TikaInputStream stream = TikaInputStream.get((byte[])bytes);
            if (metadata.get("resourceName") == null) {
                String extension = this.embeddedDocumentUtil.getExtension(stream, metadata);
                if (this.inObject && this.state == EMB_STATE.PICT) {
                    metadata.set("resourceName", "thumbnail_" + this.thumbCount++ + extension);
                    metadata.set(RTFMetadata.THUMBNAIL, "true");
                } else {
                    metadata.set("resourceName", "file_" + this.unknownFilenameCount.getAndIncrement() + extension);
                }
            }
            try {
                this.embeddedDocumentUtil.parseEmbedded((InputStream)stream, (ContentHandler)new EmbeddedContentHandler(handler), metadata, false);
            }
            catch (IOException e) {
                EmbeddedDocumentUtil.recordEmbeddedStreamException((Throwable)e, (Metadata)metadata);
            }
            finally {
                stream.close();
            }
        }
    }

    protected void reset() {
        this.state = EMB_STATE.NADA;
        this.os.reset();
        this.metadata = new Metadata();
        this.hi = -1;
        this.sv = EMPTY_STRING;
        this.sn = EMPTY_STRING;
        this.sb.setLength(0);
    }

    private static enum EMB_STATE {
        PICT,
        OBJDATA,
        NADA;

    }
}

