/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.jcas.impl;

import java.util.Iterator;
import org.apache.uima.cas.FSIndex;
import org.apache.uima.cas.FSIndexRepository;
import org.apache.uima.cas.FSIterator;
import org.apache.uima.cas.Type;
import org.apache.uima.cas.text.AnnotationIndex;
import org.apache.uima.jcas.JCas;
import org.apache.uima.jcas.JFSIndexRepository;
import org.apache.uima.jcas.cas.TOP;
import org.apache.uima.jcas.tcas.Annotation;

public class JFSIndexRepositoryImpl
implements JFSIndexRepository {
    private final FSIndexRepository fsIndexRepository;
    private final JCas jcas;

    JFSIndexRepositoryImpl(JCas jcas, FSIndexRepository ir) {
        this.fsIndexRepository = ir;
        this.jcas = jcas;
    }

    @Override
    public <T extends TOP> FSIndex<T> getIndex(String label) {
        return this.fsIndexRepository.getIndex(label);
    }

    @Override
    public <T extends TOP> FSIndex<T> getIndex(String label, int type) {
        return this.fsIndexRepository.getIndex(label, this.jcas.getCasType(type));
    }

    @Override
    public AnnotationIndex<Annotation> getAnnotationIndex() {
        return this.jcas.getCas().getAnnotationIndex();
    }

    @Override
    public <T extends Annotation> AnnotationIndex<T> getAnnotationIndex(int type) {
        return this.jcas.getCas().getAnnotationIndex(this.jcas.getCasType(type));
    }

    @Override
    public Iterator<String> getLabels() {
        return this.fsIndexRepository.getLabels();
    }

    @Override
    public Iterator<FSIndex<TOP>> getIndexes() {
        return this.fsIndexRepository.getIndexes();
    }

    @Override
    public FSIndexRepository getFSIndexRepository() {
        return this.fsIndexRepository;
    }

    @Override
    public <T extends TOP> FSIterator<T> getAllIndexedFS(Type aType) {
        return this.fsIndexRepository.getAllIndexedFS(aType);
    }

    @Override
    public <T extends TOP> FSIterator<T> getAllIndexedFS(int aType) {
        return this.fsIndexRepository.getAllIndexedFS(this.jcas.getCasType(aType));
    }
}

