/*
 * Decompiled with CFR 0.152.
 */
package com.uwyn.jhighlight.tools;

import com.uwyn.jhighlight.tools.StringUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.regex.Pattern;

public abstract class FileUtils {
    private FileUtils() {
    }

    public static ArrayList getFileList(File file, Pattern[] included, Pattern[] excluded) {
        return FileUtils.getFileList(file, included, excluded, true);
    }

    private static ArrayList getFileList(File file, Pattern[] included, Pattern[] excluded, boolean root) {
        if (null == file) {
            return new ArrayList();
        }
        ArrayList<String> filelist = new ArrayList<String>();
        if (file.isDirectory()) {
            String[] list = file.list();
            if (null != list) {
                for (int i = 0; i < list.length; ++i) {
                    String list_entry = list[i];
                    File next_file = new File(file.getAbsolutePath() + File.separator + list_entry);
                    ArrayList dir = FileUtils.getFileList(next_file, included, excluded, false);
                    for (String file_name : dir) {
                        if (root) {
                            if (!StringUtils.filter(file_name, included, excluded)) {
                                continue;
                            }
                        } else {
                            file_name = file.getName() + File.separator + file_name;
                        }
                        int filelist_size = filelist.size();
                        for (int j = 0; j < filelist_size; ++j) {
                            if (((String)filelist.get(j)).compareTo(file_name) <= 0) continue;
                            filelist.add(j, file_name);
                            break;
                        }
                        if (filelist.size() != filelist_size) continue;
                        filelist.add(file_name);
                    }
                }
            }
        } else if (file.isFile()) {
            String file_name = file.getName();
            if (root) {
                if (StringUtils.filter(file_name, included, excluded)) {
                    filelist.add(file_name);
                }
            } else {
                filelist.add(file_name);
            }
        }
        return filelist;
    }

    public static String getExtension(String fileName) {
        if (null == fileName) {
            throw new IllegalArgumentException("fileName can't be null.");
        }
        String ext = null;
        int index = fileName.lastIndexOf(46);
        if (index > 0 && index < fileName.length() - 1) {
            ext = fileName.substring(index + 1).toLowerCase();
        }
        return ext;
    }
}

