/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxrs.spring;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.cxf.Bus;
import org.apache.cxf.bus.spring.SpringBus;
import org.apache.cxf.common.util.StringUtils;
import org.apache.cxf.endpoint.Server;
import org.apache.cxf.feature.Feature;
import org.apache.cxf.helpers.CastUtils;
import org.apache.cxf.interceptor.AbstractBasicInterceptorProvider;
import org.apache.cxf.jaxrs.JAXRSServerFactoryBean;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

public abstract class AbstractSpringConfigurationFactory
extends AbstractBasicInterceptorProvider
implements ApplicationContextAware {
    protected ApplicationContext applicationContext;
    @Value(value="${cxf.jaxrs.server.address:}")
    private String jaxrsServerAddress;
    @Value(value="${cxf.jaxrs.extensions:}")
    private String jaxrsExtensions;

    protected Server createJaxRsServer() {
        JAXRSServerFactoryBean factory = new JAXRSServerFactoryBean();
        factory.setAddress(this.getAddress());
        factory.setTransportId(this.getTransportId());
        factory.setBus(this.getBus());
        this.setJaxrsResources(factory);
        factory.setInInterceptors(this.getInInterceptors());
        factory.setOutInterceptors(this.getOutInterceptors());
        factory.setOutFaultInterceptors(this.getOutFaultInterceptors());
        factory.setFeatures(this.getFeatures());
        if (!StringUtils.isEmpty((String)this.jaxrsExtensions)) {
            factory.setExtensionMappings(CastUtils.cast(AbstractSpringConfigurationFactory.parseMapSequence(this.jaxrsExtensions)));
        }
        this.finalizeFactorySetup(factory);
        return factory.create();
    }

    protected Bus getBus() {
        return (Bus)this.applicationContext.getBean(SpringBus.class);
    }

    public void setApplicationContext(ApplicationContext ac) throws BeansException {
        this.applicationContext = ac;
    }

    protected abstract void setJaxrsResources(JAXRSServerFactoryBean var1);

    protected List<Object> getJaxrsProviders() {
        return Collections.emptyList();
    }

    public List<Feature> getFeatures() {
        return Collections.emptyList();
    }

    protected String getAddress() {
        if (!StringUtils.isEmpty((String)this.jaxrsServerAddress)) {
            return this.jaxrsServerAddress;
        }
        return "/";
    }

    protected String getTransportId() {
        return "http://cxf.apache.org/transports/http";
    }

    protected void finalizeFactorySetup(JAXRSServerFactoryBean factory) {
    }

    protected static Map<String, String> parseMapSequence(String sequence) {
        if (sequence != null) {
            String[] pairs;
            sequence = sequence.trim();
            HashMap<String, String> map = new HashMap<String, String>();
            for (String pair : pairs = sequence.split(",")) {
                String thePair = pair.trim();
                if (thePair.length() == 0) continue;
                String[] value = thePair.split("=");
                if (value.length == 2) {
                    map.put(value[0].trim(), value[1].trim());
                    continue;
                }
                map.put(thePair, "");
            }
            return map;
        }
        return Collections.emptyMap();
    }
}

