/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing.cs;

import java.util.Map;
import javax.measure.Unit;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.apache.sis.internal.referencing.AxisDirections;
import org.apache.sis.measure.Units;
import org.apache.sis.referencing.cs.AbstractCS;
import org.apache.sis.referencing.cs.AxesConvention;
import org.opengis.referencing.cs.AxisDirection;
import org.opengis.referencing.cs.CoordinateSystem;
import org.opengis.referencing.cs.CoordinateSystemAxis;
import org.opengis.referencing.cs.LinearCS;

@XmlType(name="LinearCSType")
@XmlRootElement(name="LinearCS")
public class DefaultLinearCS
extends AbstractCS
implements LinearCS {
    private static final long serialVersionUID = -6890723478287625763L;

    private DefaultLinearCS(Map<String, ?> map, CoordinateSystemAxis[] coordinateSystemAxisArray) {
        super(map, coordinateSystemAxisArray);
    }

    public DefaultLinearCS(Map<String, ?> map, CoordinateSystemAxis coordinateSystemAxis) {
        super(map, coordinateSystemAxis);
    }

    protected DefaultLinearCS(LinearCS linearCS) {
        super((CoordinateSystem)linearCS);
    }

    public static DefaultLinearCS castOrCopy(LinearCS linearCS) {
        return linearCS == null || linearCS instanceof DefaultLinearCS ? (DefaultLinearCS)linearCS : new DefaultLinearCS(linearCS);
    }

    @Override
    final int validateAxis(AxisDirection axisDirection, Unit<?> unit) {
        if (!AxisDirections.isSpatialOrUserDefined(axisDirection, false)) {
            return 1;
        }
        if (!Units.isLinear(unit) && !Units.UNITY.equals(unit)) {
            return 2;
        }
        return 0;
    }

    public Class<? extends LinearCS> getInterface() {
        return LinearCS.class;
    }

    @Override
    public DefaultLinearCS forConvention(AxesConvention axesConvention) {
        return (DefaultLinearCS)super.forConvention(axesConvention);
    }

    @Override
    final AbstractCS createForAxes(Map<String, ?> map, CoordinateSystemAxis[] coordinateSystemAxisArray) {
        switch (coordinateSystemAxisArray.length) {
            case 1: {
                return new DefaultLinearCS(map, coordinateSystemAxisArray);
            }
        }
        throw DefaultLinearCS.unexpectedDimension(map, coordinateSystemAxisArray, 1);
    }

    private DefaultLinearCS() {
    }
}

