/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.feature;

import java.util.Collection;
import org.apache.sis.feature.AbstractAssociation;
import org.apache.sis.feature.AbstractFeature;
import org.apache.sis.feature.DefaultAssociationRole;
import org.apache.sis.feature.DefaultFeatureType;
import org.apache.sis.internal.feature.Resources;
import org.apache.sis.internal.util.CheckedArrayList;
import org.apache.sis.util.ArgumentChecks;

final class MultiValuedAssociation
extends AbstractAssociation {
    private static final long serialVersionUID = 5089428248556035466L;
    private CheckedArrayList<AbstractFeature> values;

    public MultiValuedAssociation(DefaultAssociationRole defaultAssociationRole) {
        super(defaultAssociationRole);
        this.values = new CheckedArrayList<AbstractFeature>(AbstractFeature.class);
    }

    MultiValuedAssociation(DefaultAssociationRole defaultAssociationRole, Object object) {
        super(defaultAssociationRole);
        this.values = object == null ? new CheckedArrayList<AbstractFeature>(AbstractFeature.class) : CheckedArrayList.castOrCopy((CheckedArrayList)object, AbstractFeature.class);
    }

    @Override
    public AbstractFeature getValue() {
        switch (this.values.size()) {
            case 0: {
                return null;
            }
            case 1: {
                return (AbstractFeature)this.values.get(0);
            }
        }
        throw new IllegalStateException(Resources.format((short)53, this.getName()));
    }

    @Override
    public Collection<AbstractFeature> getValues() {
        return this.values;
    }

    @Override
    public void setValue(AbstractFeature abstractFeature) {
        this.values.clear();
        if (abstractFeature != null) {
            this.ensureValid(this.role.getValueType(), abstractFeature.getType());
            this.values.add(abstractFeature);
        }
    }

    @Override
    public void setValues(Collection<? extends AbstractFeature> collection) {
        if (collection != this.values) {
            ArgumentChecks.ensureNonNull("values", collection);
            DefaultFeatureType defaultFeatureType = this.role.getValueType();
            this.values.clear();
            for (AbstractFeature abstractFeature : collection) {
                this.ensureValid(defaultFeatureType, abstractFeature.getType());
                this.values.add(abstractFeature);
            }
        }
    }

    @Override
    public MultiValuedAssociation clone() throws CloneNotSupportedException {
        MultiValuedAssociation multiValuedAssociation = (MultiValuedAssociation)super.clone();
        multiValuedAssociation.values = (CheckedArrayList)multiValuedAssociation.values.clone();
        return multiValuedAssociation;
    }

    public int hashCode() {
        return this.role.hashCode() + this.values.hashCode();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof MultiValuedAssociation) {
            MultiValuedAssociation multiValuedAssociation = (MultiValuedAssociation)object;
            return this.role.equals(multiValuedAssociation.role) && this.values.equals(multiValuedAssociation.values);
        }
        return false;
    }
}

