/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.feature;

import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import org.apache.sis.feature.AbstractFeature;
import org.apache.sis.feature.AbstractIdentifiedType;
import org.apache.sis.feature.AbstractOperation;
import org.apache.sis.feature.AssociationView;
import org.apache.sis.feature.AttributeView;
import org.apache.sis.feature.DefaultAssociationRole;
import org.apache.sis.feature.DefaultAttributeType;
import org.apache.sis.feature.FieldType;
import org.apache.sis.feature.Property;
import org.apache.sis.internal.feature.Resources;
import org.apache.sis.util.Classes;
import org.apache.sis.util.collection.CheckedContainer;
import org.apache.sis.util.resources.Errors;
import org.opengis.util.GenericName;

final class PropertyView {
    private PropertyView() {
    }

    static Property create(AbstractFeature abstractFeature, AbstractIdentifiedType abstractIdentifiedType) {
        if (abstractIdentifiedType instanceof DefaultAttributeType) {
            return AttributeView.create(abstractFeature, (DefaultAttributeType)abstractIdentifiedType);
        }
        if (abstractIdentifiedType instanceof DefaultAssociationRole) {
            return AssociationView.create(abstractFeature, (DefaultAssociationRole)abstractIdentifiedType);
        }
        if (abstractIdentifiedType instanceof AbstractOperation) {
            return (Property)((AbstractOperation)abstractIdentifiedType).apply(abstractFeature, null);
        }
        throw new IllegalArgumentException(Errors.format((short)149, Classes.getClass(abstractIdentifiedType)));
    }

    static Object getValue(AbstractFeature abstractFeature, String string) {
        Object object = abstractFeature.getPropertyValue(string);
        if (object instanceof Iterable) {
            Iterator iterator = ((Iterable)object).iterator();
            if (!iterator.hasNext()) {
                return null;
            }
            object = iterator.next();
            if (iterator.hasNext()) {
                throw new IllegalStateException(Resources.format((short)53, string));
            }
        }
        return object;
    }

    static void setValue(AbstractFeature abstractFeature, String string, Object object) {
        abstractFeature.setPropertyValue(string, PropertyView.singletonOrEmpty(object));
    }

    static <V> List<V> singletonOrEmpty(V v) {
        return v != null ? Collections.singletonList(v) : Collections.emptyList();
    }

    static <V> Collection<V> getValues(AbstractFeature abstractFeature, String string, Class<V> clazz) {
        Object object = abstractFeature.getPropertyValue(string);
        if (object instanceof Collection) {
            Class clazz2;
            if (object instanceof CheckedContainer && clazz != (clazz2 = ((CheckedContainer)object).getElementType())) {
                throw new ClassCastException(Errors.format((short)143, string, clazz, clazz2));
            }
            return (Collection)object;
        }
        return PropertyView.singletonOrEmpty(clazz.cast(object));
    }

    static void setValues(AbstractFeature abstractFeature, String string, Collection<?> collection) {
        abstractFeature.setPropertyValue(string, collection);
    }

    static int hashCode(AbstractFeature abstractFeature, String string) {
        return Objects.hashCode(string) ^ System.identityHashCode(abstractFeature);
    }

    static String toString(Class<?> clazz, Class<?> clazz2, GenericName genericName, Collection<?> collection) {
        return FieldType.toString(false, clazz.getSimpleName(), genericName, Classes.getShortName(clazz2), collection.iterator()).toString();
    }
}

