/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.fit.factory;

import org.apache.uima.cas.FeatureStructure;
import org.apache.uima.cas.Type;
import org.apache.uima.cas.text.AnnotationFS;
import org.apache.uima.fit.util.JCasUtil;
import org.apache.uima.jcas.JCas;

public class JCasBuilder {
    private final StringBuilder documentText = new StringBuilder();
    private final JCas jcas;

    public JCasBuilder(JCas aJCas) {
        this.jcas = aJCas;
    }

    public void add(String aText) {
        this.documentText.append(aText);
    }

    public <T> T add(String aText, Class<T> aClass) {
        Type type = JCasUtil.getType(this.jcas, aClass);
        int begin = this.documentText.length();
        this.add(aText);
        int end = this.documentText.length();
        AnnotationFS fs = this.jcas.getCas().createAnnotation(type, begin, end);
        this.jcas.addFsToIndexes((FeatureStructure)fs);
        return (T)fs;
    }

    public <T> T add(int aBegin, Class<T> aClass) {
        Type type = JCasUtil.getType(this.jcas, aClass);
        int end = this.documentText.length();
        AnnotationFS fs = this.jcas.getCas().createAnnotation(type, aBegin, end);
        this.jcas.addFsToIndexes((FeatureStructure)fs);
        return (T)fs;
    }

    public int getPosition() {
        return this.documentText.length();
    }

    public JCas getJCas() {
        return this.jcas;
    }

    public void close() {
        this.jcas.setDocumentText(this.documentText.toString());
    }
}

