/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.storage;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Spliterator;
import java.util.function.Consumer;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.apache.sis.feature.AbstractFeature;
import org.apache.sis.feature.AbstractIdentifiedType;
import org.apache.sis.feature.AbstractOperation;
import org.apache.sis.feature.DefaultAssociationRole;
import org.apache.sis.feature.DefaultFeatureType;
import org.apache.sis.feature.FeatureOperations;
import org.apache.sis.filter.DefaultFilterFactory;
import org.apache.sis.filter.Expression;
import org.apache.sis.filter.Filter;
import org.apache.sis.internal.feature.AttributeConvention;
import org.apache.sis.internal.geoapi.filter.BinaryComparisonOperator;
import org.apache.sis.internal.storage.AggregatedFeatureSet;
import org.apache.sis.storage.DataStoreException;
import org.apache.sis.storage.FeatureQuery;
import org.apache.sis.storage.FeatureSet;
import org.apache.sis.storage.event.StoreListeners;
import org.apache.sis.util.ArraysExt;
import org.apache.sis.util.collection.BackingStoreException;
import org.apache.sis.util.collection.Containers;
import org.opengis.util.GenericName;

public class JoinFeatureSet
extends AggregatedFeatureSet {
    private final DefaultFeatureType type;
    public final FeatureSet left;
    public final FeatureSet right;
    private final String leftName;
    private final String rightName;
    private final boolean swapSides;
    private final boolean isOuterJoin;
    public final BinaryComparisonOperator<? super AbstractFeature> condition;
    private final DefaultFilterFactory<AbstractFeature, ?, ?> factory;

    public JoinFeatureSet(StoreListeners storeListeners, FeatureSet featureSet, String string, FeatureSet featureSet2, String string2, Type type, BinaryComparisonOperator<? super AbstractFeature> binaryComparisonOperator, Map<String, ?> map) throws DataStoreException {
        super(storeListeners);
        DefaultFeatureType defaultFeatureType = featureSet.getType();
        DefaultFeatureType defaultFeatureType2 = featureSet2.getType();
        GenericName genericName = defaultFeatureType.getName();
        GenericName genericName2 = defaultFeatureType2.getName();
        if (string == null) {
            string = genericName.toString();
        }
        if (string2 == null) {
            string2 = genericName2.toString();
        }
        this.left = featureSet;
        this.right = featureSet2;
        this.leftName = string;
        this.rightName = string2;
        this.swapSides = type.swapSides;
        this.isOuterJoin = type.isOuterJoin;
        this.condition = binaryComparisonOperator;
        this.factory = DefaultFilterFactory.forFeatures();
        AbstractIdentifiedType[] abstractIdentifiedTypeArray = new AbstractIdentifiedType[]{new DefaultAssociationRole(JoinFeatureSet.name(string), defaultFeatureType, type.minimumOccurs(false), 1), new DefaultAssociationRole(JoinFeatureSet.name(string2), defaultFeatureType2, type.minimumOccurs(true), 1)};
        String string3 = Containers.property(map, "identifierDelimiter", String.class);
        if (string3 != null && AttributeConvention.hasIdentifier(defaultFeatureType) && AttributeConvention.hasIdentifier(defaultFeatureType2)) {
            AbstractOperation abstractOperation = FeatureOperations.compound(JoinFeatureSet.name(AttributeConvention.IDENTIFIER_PROPERTY), string3, Containers.property(map, "identifierPrefix", String.class), Containers.property(map, "identifierSuffix", String.class), abstractIdentifiedTypeArray);
            abstractIdentifiedTypeArray = ArraysExt.insert(abstractIdentifiedTypeArray, 0, 1);
            abstractIdentifiedTypeArray[0] = abstractOperation;
        }
        if (map == null) {
            map = JoinFeatureSet.name(genericName.tip().toString() + '-' + genericName2.tip());
        }
        this.type = new DefaultFeatureType(map, false, null, abstractIdentifiedTypeArray);
    }

    private static Map<String, ?> name(Object object) {
        return Collections.singletonMap("name", object);
    }

    final List<FeatureSet> dependencies() {
        Object[] objectArray = new FeatureSet[]{this.left, this.right};
        if (this.swapSides) {
            ArraysExt.swap(objectArray, 0, 1);
        }
        return Arrays.asList(objectArray);
    }

    public Type getJoinType() {
        return Type.valueOf(this.isOuterJoin, this.swapSides);
    }

    @Override
    public DefaultFeatureType getType() {
        return this.type;
    }

    @Override
    public Stream<AbstractFeature> features(boolean bl) throws DataStoreException {
        Iterator iterator = new Iterator();
        return (Stream)StreamSupport.stream(iterator, bl).onClose(iterator);
    }

    private AbstractFeature join(AbstractFeature abstractFeature, AbstractFeature abstractFeature2) {
        AbstractFeature abstractFeature3;
        if (this.swapSides) {
            abstractFeature3 = abstractFeature;
            abstractFeature = abstractFeature2;
            abstractFeature2 = abstractFeature3;
        }
        abstractFeature3 = this.type.newInstance();
        abstractFeature3.setPropertyValue(this.leftName, abstractFeature);
        abstractFeature3.setPropertyValue(this.rightName, abstractFeature2);
        return abstractFeature3;
    }

    public static enum Type {
        INNER(false, false),
        LEFT_OUTER(true, false),
        RIGHT_OUTER(true, true);

        final boolean isOuterJoin;
        final boolean swapSides;

        private Type(boolean bl, boolean bl2) {
            this.isOuterJoin = bl;
            this.swapSides = bl2;
        }

        final int minimumOccurs(boolean bl) {
            return !this.isOuterJoin | this.swapSides == bl ? 1 : 0;
        }

        static Type valueOf(boolean bl, boolean bl2) {
            return bl ? (bl2 ? RIGHT_OUTER : LEFT_OUTER) : INNER;
        }
    }

    private final class Iterator
    implements Spliterator<AbstractFeature>,
    Consumer<AbstractFeature>,
    Runnable {
        private Runnable mainCloseHandler;
        private final Spliterator<AbstractFeature> mainIterator;
        private AbstractFeature mainFeature;
        private Stream<AbstractFeature> filteredStream;
        private Spliterator<AbstractFeature> filteredIterator;
        private AbstractFeature filteredFeature;

        Iterator() throws DataStoreException {
            Stream<AbstractFeature> stream = (JoinFeatureSet.this.swapSides ? JoinFeatureSet.this.right : JoinFeatureSet.this.left).features(false);
            this.mainCloseHandler = stream::close;
            this.mainIterator = stream.spliterator();
        }

        private Iterator(Spliterator<AbstractFeature> spliterator) {
            this.mainIterator = spliterator;
        }

        @Override
        public Spliterator<AbstractFeature> trySplit() {
            Spliterator<AbstractFeature> spliterator = this.mainIterator.trySplit();
            if (spliterator == null) {
                return null;
            }
            Iterator iterator = new Iterator(spliterator);
            iterator.mainCloseHandler = this.mainCloseHandler;
            this.mainCloseHandler = iterator;
            return iterator;
        }

        @Override
        public int characteristics() {
            return this.mainIterator.characteristics() & 0x10 | 0x100;
        }

        @Override
        public long estimateSize() {
            return Long.MAX_VALUE;
        }

        @Override
        public void run() {
            this.closeFilteredIterator();
            Runnable runnable = this.mainCloseHandler;
            if (runnable != null) {
                this.mainCloseHandler = null;
                runnable.run();
            }
        }

        private void closeFilteredIterator() {
            Stream<AbstractFeature> stream = this.filteredStream;
            this.filteredStream = null;
            this.filteredIterator = null;
            this.filteredFeature = null;
            this.mainFeature = null;
            if (stream != null) {
                stream.close();
            }
        }

        private void createFilteredIterator() {
            FeatureSet featureSet;
            Expression<? super AbstractFeature, ?> expression;
            Expression<AbstractFeature, ?> expression2;
            if (JoinFeatureSet.this.swapSides) {
                expression2 = JoinFeatureSet.this.condition.getOperand2();
                expression = JoinFeatureSet.this.condition.getOperand1();
                featureSet = JoinFeatureSet.this.left;
            } else {
                expression2 = JoinFeatureSet.this.condition.getOperand1();
                expression = JoinFeatureSet.this.condition.getOperand2();
                featureSet = JoinFeatureSet.this.right;
            }
            Object obj = expression2.apply(this.mainFeature);
            Filter<? super AbstractFeature> filter = obj != null ? JoinFeatureSet.this.factory.equal(expression, JoinFeatureSet.this.factory.literal(obj)) : JoinFeatureSet.this.factory.isNull(expression);
            FeatureQuery featureQuery = new FeatureQuery();
            featureQuery.setSelection(filter);
            try {
                this.filteredStream = featureSet.subset(featureQuery).features(false);
            }
            catch (DataStoreException dataStoreException) {
                throw new BackingStoreException(dataStoreException);
            }
            this.filteredIterator = this.filteredStream.spliterator();
        }

        @Override
        public void forEachRemaining(Consumer<? super AbstractFeature> consumer) {
            Consumer<AbstractFeature> consumer2 = abstractFeature -> {
                if (abstractFeature != null) {
                    this.filteredFeature = abstractFeature;
                    consumer.accept(JoinFeatureSet.this.join(this.mainFeature, this.filteredFeature));
                }
            };
            Consumer<AbstractFeature> consumer3 = abstractFeature -> {
                if (abstractFeature != null) {
                    this.mainFeature = abstractFeature;
                    this.createFilteredIterator();
                    this.filteredIterator.forEachRemaining(consumer2);
                    boolean bl = this.filteredFeature == null;
                    this.closeFilteredIterator();
                    if (bl && JoinFeatureSet.this.isOuterJoin) {
                        consumer.accept(JoinFeatureSet.this.join(abstractFeature, null));
                    }
                }
            };
            consumer3.accept(this.mainFeature);
            this.mainIterator.forEachRemaining(consumer3);
        }

        @Override
        public void accept(AbstractFeature abstractFeature) {
            this.filteredFeature = abstractFeature;
        }

        @Override
        public boolean tryAdvance(Consumer<? super AbstractFeature> consumer) {
            AbstractFeature abstractFeature;
            boolean bl;
            do {
                if (this.mainFeature == null) {
                    do {
                        if (this.mainIterator.tryAdvance(this)) continue;
                        return false;
                    } while (this.filteredFeature == null);
                    this.mainFeature = this.filteredFeature;
                    this.filteredFeature = null;
                }
                if (this.filteredIterator == null) {
                    this.createFilteredIterator();
                }
                boolean bl2 = bl = this.filteredFeature == null;
                while (this.filteredIterator.tryAdvance(this)) {
                    if (this.filteredFeature == null) continue;
                    consumer.accept(JoinFeatureSet.this.join(this.mainFeature, this.filteredFeature));
                    return true;
                }
                abstractFeature = this.mainFeature;
                this.closeFilteredIterator();
            } while (!bl || !JoinFeatureSet.this.isOuterJoin);
            consumer.accept(JoinFeatureSet.this.join(abstractFeature, null));
            return true;
        }
    }
}

