/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.storage.folder;

import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.BasicFileAttributes;
import org.apache.sis.internal.storage.ResourceOnFileSystem;
import org.apache.sis.internal.storage.StoreUtilities;
import org.apache.sis.internal.storage.folder.Store;
import org.apache.sis.setup.OptionKey;
import org.apache.sis.storage.DataStore;
import org.apache.sis.storage.DataStoreException;
import org.apache.sis.storage.DataStoreProvider;
import org.apache.sis.storage.FeatureSet;
import org.apache.sis.storage.ReadOnlyStorageException;
import org.apache.sis.storage.Resource;
import org.apache.sis.storage.StorageConnector;
import org.apache.sis.storage.WritableAggregate;
import org.apache.sis.storage.WritableFeatureSet;
import org.apache.sis.util.ArgumentChecks;
import org.opengis.util.GenericName;

final class WritableStore
extends Store
implements WritableAggregate {
    private boolean isReadOnly;

    WritableStore(DataStoreProvider dataStoreProvider, StorageConnector storageConnector, Path path, DataStoreProvider dataStoreProvider2) throws DataStoreException, IOException {
        super(dataStoreProvider, storageConnector, path, dataStoreProvider2);
    }

    @Override
    public synchronized Resource add(Resource resource) throws DataStoreException {
        Path path;
        ArgumentChecks.ensureNonNull("resource", resource);
        if (!(resource instanceof FeatureSet)) {
            throw new DataStoreException(this.message((short)41, new Object[]{"folder", StoreUtilities.getInterface(resource.getClass())}));
        }
        if (this.isReadOnly) {
            throw new ReadOnlyStorageException(this.messages().getString((short)28));
        }
        GenericName genericName = resource.getIdentifier().orElse(null);
        if (genericName == null) {
            throw new DataStoreException(this.message((short)42, StoreUtilities.getLabel(resource)));
        }
        String string = genericName.toString();
        String[] stringArray = StoreUtilities.getFileSuffixes(this.componentProvider.getClass());
        if (stringArray.length != 0) {
            string = string + '.' + stringArray[0];
        }
        if (!this.children.containsKey(path = this.location.resolve(string))) {
            StorageConnector storageConnector = new StorageConnector(path);
            storageConnector.setOption(OptionKey.LOCALE, this.locale);
            storageConnector.setOption(OptionKey.TIMEZONE, this.timezone);
            storageConnector.setOption(OptionKey.ENCODING, this.encoding);
            storageConnector.setOption(OptionKey.OPEN_OPTIONS, new StandardOpenOption[]{StandardOpenOption.CREATE_NEW, StandardOpenOption.WRITE});
            DataStore dataStore = this.componentProvider.open(storageConnector);
            if (this.children.putIfAbsent(path, dataStore) == null) {
                if (dataStore instanceof WritableFeatureSet) {
                    StoreUtilities.copy((FeatureSet)resource, (WritableFeatureSet)((Object)dataStore));
                    this.components = null;
                    return dataStore;
                }
                this.isReadOnly = true;
                this.children.remove(path, dataStore);
                String string2 = dataStore.getDisplayName();
                dataStore.close();
                throw new DataStoreException(this.message((short)47, string2));
            }
            dataStore.close();
        }
        throw new DataStoreException(this.message((short)48, path));
    }

    @Override
    public synchronized void remove(Resource resource) throws DataStoreException {
        if (resource instanceof DataStore) {
            try {
                if (resource instanceof Store) {
                    Path path = ((Store)resource).location;
                    if (Files.isSameFile(path.getParent(), this.location)) {
                        ((Store)resource).close();
                        WritableStore.deleteRecursively(path, true);
                        this.children.remove(path);
                        return;
                    }
                } else if (resource instanceof ResourceOnFileSystem) {
                    Path[] pathArray;
                    for (Path path : pathArray = (Path[])((ResourceOnFileSystem)resource).getComponentFiles().clone()) {
                        if (!Files.isSameFile(path = path.getParent(), this.location)) continue;
                        for (Path path2 : pathArray) {
                            if (!path2.startsWith(path)) continue;
                            Files.delete(path2);
                        }
                        this.children.values().removeIf(dataStore -> dataStore == resource);
                        this.components = null;
                        return;
                    }
                }
            }
            catch (IOException iOException) {
                throw new DataStoreException(this.messages().getString((short)49, this.getDisplayName(), ((DataStore)resource).getDisplayName()), iOException);
            }
        }
        throw new DataStoreException(this.messages().getString((short)50, this.getDisplayName(), StoreUtilities.getLabel(resource)));
    }

    static void deleteRecursively(Path path, final boolean bl) throws IOException {
        Files.walkFileTree(path, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){
            private int depth;

            @Override
            public FileVisitResult preVisitDirectory(Path path, BasicFileAttributes basicFileAttributes) throws IOException {
                ++this.depth;
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult visitFile(Path path, BasicFileAttributes basicFileAttributes) throws IOException {
                if (this.depth > 0) {
                    Files.delete(path);
                }
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult postVisitDirectory(Path path, IOException iOException) throws IOException {
                if (iOException != null) {
                    throw iOException;
                }
                if (--this.depth > 0 || bl) {
                    Files.delete(path);
                }
                return FileVisitResult.CONTINUE;
            }
        });
    }
}

