/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.inotify;

import java.util.List;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.fs.XAttr;
import org.apache.hadoop.fs.permission.AclEntry;
import org.apache.hadoop.fs.permission.FsPermission;

@InterfaceAudience.Public
@InterfaceStability.Unstable
public abstract class Event {
    private EventType eventType;

    public EventType getEventType() {
        return this.eventType;
    }

    public Event(EventType eventType) {
        this.eventType = eventType;
    }

    public static class UnlinkEvent
    extends Event {
        private String path;
        private long timestamp;

        public UnlinkEvent(String path, long timestamp) {
            super(EventType.UNLINK);
            this.path = path;
            this.timestamp = timestamp;
        }

        public String getPath() {
            return this.path;
        }

        public long getTimestamp() {
            return this.timestamp;
        }
    }

    public static class AppendEvent
    extends Event {
        private String path;

        public AppendEvent(String path) {
            super(EventType.APPEND);
            this.path = path;
        }

        public String getPath() {
            return this.path;
        }
    }

    public static class RenameEvent
    extends Event {
        private String srcPath;
        private String dstPath;
        private long timestamp;

        public RenameEvent(String srcPath, String dstPath, long timestamp) {
            super(EventType.RENAME);
            this.srcPath = srcPath;
            this.dstPath = dstPath;
            this.timestamp = timestamp;
        }

        public String getSrcPath() {
            return this.srcPath;
        }

        public String getDstPath() {
            return this.dstPath;
        }

        public long getTimestamp() {
            return this.timestamp;
        }
    }

    public static class MetadataUpdateEvent
    extends Event {
        private String path;
        private MetadataType metadataType;
        private long mtime;
        private long atime;
        private int replication;
        private String ownerName;
        private String groupName;
        private FsPermission perms;
        private List<AclEntry> acls;
        private List<XAttr> xAttrs;
        private boolean xAttrsRemoved;

        private MetadataUpdateEvent(Builder b) {
            super(EventType.METADATA);
            this.path = b.path;
            this.metadataType = b.metadataType;
            this.mtime = b.mtime;
            this.atime = b.atime;
            this.replication = b.replication;
            this.ownerName = b.ownerName;
            this.groupName = b.groupName;
            this.perms = b.perms;
            this.acls = b.acls;
            this.xAttrs = b.xAttrs;
            this.xAttrsRemoved = b.xAttrsRemoved;
        }

        public String getPath() {
            return this.path;
        }

        public MetadataType getMetadataType() {
            return this.metadataType;
        }

        public long getMtime() {
            return this.mtime;
        }

        public long getAtime() {
            return this.atime;
        }

        public int getReplication() {
            return this.replication;
        }

        public String getOwnerName() {
            return this.ownerName;
        }

        public String getGroupName() {
            return this.groupName;
        }

        public FsPermission getPerms() {
            return this.perms;
        }

        public List<AclEntry> getAcls() {
            return this.acls;
        }

        public List<XAttr> getxAttrs() {
            return this.xAttrs;
        }

        public boolean isxAttrsRemoved() {
            return this.xAttrsRemoved;
        }

        public static class Builder {
            private String path;
            private MetadataType metadataType;
            private long mtime;
            private long atime;
            private int replication;
            private String ownerName;
            private String groupName;
            private FsPermission perms;
            private List<AclEntry> acls;
            private List<XAttr> xAttrs;
            private boolean xAttrsRemoved;

            public Builder path(String path) {
                this.path = path;
                return this;
            }

            public Builder metadataType(MetadataType type) {
                this.metadataType = type;
                return this;
            }

            public Builder mtime(long mtime) {
                this.mtime = mtime;
                return this;
            }

            public Builder atime(long atime) {
                this.atime = atime;
                return this;
            }

            public Builder replication(int replication) {
                this.replication = replication;
                return this;
            }

            public Builder ownerName(String ownerName) {
                this.ownerName = ownerName;
                return this;
            }

            public Builder groupName(String groupName) {
                this.groupName = groupName;
                return this;
            }

            public Builder perms(FsPermission perms) {
                this.perms = perms;
                return this;
            }

            public Builder acls(List<AclEntry> acls) {
                this.acls = acls;
                return this;
            }

            public Builder xAttrs(List<XAttr> xAttrs) {
                this.xAttrs = xAttrs;
                return this;
            }

            public Builder xAttrsRemoved(boolean xAttrsRemoved) {
                this.xAttrsRemoved = xAttrsRemoved;
                return this;
            }

            public MetadataUpdateEvent build() {
                return new MetadataUpdateEvent(this);
            }
        }

        public static enum MetadataType {
            TIMES,
            REPLICATION,
            OWNER,
            PERMS,
            ACLS,
            XATTRS;

        }
    }

    public static class CreateEvent
    extends Event {
        private INodeType iNodeType;
        private String path;
        private long ctime;
        private int replication;
        private String ownerName;
        private String groupName;
        private FsPermission perms;
        private String symlinkTarget;
        private boolean overwrite;

        private CreateEvent(Builder b) {
            super(EventType.CREATE);
            this.iNodeType = b.iNodeType;
            this.path = b.path;
            this.ctime = b.ctime;
            this.replication = b.replication;
            this.ownerName = b.ownerName;
            this.groupName = b.groupName;
            this.perms = b.perms;
            this.symlinkTarget = b.symlinkTarget;
            this.overwrite = b.overwrite;
        }

        public INodeType getiNodeType() {
            return this.iNodeType;
        }

        public String getPath() {
            return this.path;
        }

        public long getCtime() {
            return this.ctime;
        }

        public int getReplication() {
            return this.replication;
        }

        public String getOwnerName() {
            return this.ownerName;
        }

        public String getGroupName() {
            return this.groupName;
        }

        public FsPermission getPerms() {
            return this.perms;
        }

        public String getSymlinkTarget() {
            return this.symlinkTarget;
        }

        public boolean getOverwrite() {
            return this.overwrite;
        }

        public static class Builder {
            private INodeType iNodeType;
            private String path;
            private long ctime;
            private int replication;
            private String ownerName;
            private String groupName;
            private FsPermission perms;
            private String symlinkTarget;
            private boolean overwrite;

            public Builder iNodeType(INodeType type) {
                this.iNodeType = type;
                return this;
            }

            public Builder path(String path) {
                this.path = path;
                return this;
            }

            public Builder ctime(long ctime) {
                this.ctime = ctime;
                return this;
            }

            public Builder replication(int replication) {
                this.replication = replication;
                return this;
            }

            public Builder ownerName(String ownerName) {
                this.ownerName = ownerName;
                return this;
            }

            public Builder groupName(String groupName) {
                this.groupName = groupName;
                return this;
            }

            public Builder perms(FsPermission perms) {
                this.perms = perms;
                return this;
            }

            public Builder symlinkTarget(String symlinkTarget) {
                this.symlinkTarget = symlinkTarget;
                return this;
            }

            public Builder overwrite(boolean overwrite) {
                this.overwrite = overwrite;
                return this;
            }

            public CreateEvent build() {
                return new CreateEvent(this);
            }
        }

        public static enum INodeType {
            FILE,
            DIRECTORY,
            SYMLINK;

        }
    }

    public static class CloseEvent
    extends Event {
        private String path;
        private long fileSize;
        private long timestamp;

        public CloseEvent(String path, long fileSize, long timestamp) {
            super(EventType.CLOSE);
            this.path = path;
            this.fileSize = fileSize;
            this.timestamp = timestamp;
        }

        public String getPath() {
            return this.path;
        }

        public long getFileSize() {
            return this.fileSize;
        }

        public long getTimestamp() {
            return this.timestamp;
        }
    }

    public static enum EventType {
        CREATE,
        CLOSE,
        APPEND,
        RENAME,
        METADATA,
        UNLINK;

    }
}

