/*
 * Decompiled with CFR 0.152.
 */
package com.github.sommeri.less4j.core.compiler.scopes.local;

import com.github.sommeri.less4j.utils.ArraysUtils;
import com.github.sommeri.less4j.utils.PubliclyCloneable;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;

public class KeyValueStorage<M, T>
implements Cloneable {
    private LinkedList<Level<M, T>> levels = new LinkedList();
    private LinkedList<ValuePlaceholder<M, T>> placeholders = new LinkedList();

    public int size() {
        return this.levels.size();
    }

    public void add(M key, T thing) {
        Level<M, T> lastLevel = this.getLastLevel();
        lastLevel.add(key, thing);
    }

    public void add(KeyValueStorage<M, T> otherStorage) {
        this.levels.addAll(otherStorage.levels);
        this.placeholders.addAll(otherStorage.placeholders);
    }

    public boolean contains(M key) {
        for (Level level : this.levels) {
            if (!level.contains(key)) continue;
            return true;
        }
        return false;
    }

    public T getValue(M key) {
        Iterator<Level<M, T>> di = this.levels.descendingIterator();
        while (di.hasNext()) {
            Level<M, T> level = di.next();
            if (!level.contains(key)) continue;
            return level.getValue(key);
        }
        return null;
    }

    public void remove(M key) {
        Iterator<Level<M, T>> di = this.levels.descendingIterator();
        while (di.hasNext()) {
            Level<M, T> level = di.next();
            if (!level.contains(key)) continue;
            level.remove(key);
        }
    }

    public Set<Map.Entry<M, T>> getAllEntries() {
        HashSet<Map.Entry<M, T>> result = new HashSet<Map.Entry<M, T>>();
        Iterator<Level<M, T>> iterator = this.levels.descendingIterator();
        while (iterator.hasNext()) {
            Level<M, T> level = iterator.next();
            result.addAll(level.getAllEntries());
        }
        return result;
    }

    public ValuePlaceholder<M, T> createPlaceholder() {
        Level<M, T> addLevel = this.addLevel();
        ValuePlaceholder<M, T> placeholder = new ValuePlaceholder<M, T>(addLevel);
        this.placeholders.add(placeholder);
        this.addLevel();
        return placeholder;
    }

    public void addDataToFirstPlaceholder(KeyValueStorage<M, T> otherStorage) {
        ValuePlaceholder<M, T> placeholder = this.placeholders.peekFirst();
        this.addDataOnly(placeholder, otherStorage);
    }

    private void addDataOnly(ValuePlaceholder<M, T> placeholder, KeyValueStorage<M, T> otherStorage) {
        for (Level level : otherStorage.levels) {
            ((ValuePlaceholder)placeholder).level.addAll(level);
        }
    }

    public void addToFirstPlaceholder(M key, T value) {
        ValuePlaceholder<M, T> placeholder = this.placeholders.peekFirst();
        ((ValuePlaceholder)placeholder).level.add(key, value);
    }

    public void closeFirstPlaceholder() {
        this.placeholders.pop();
    }

    public void replacePlaceholder(ValuePlaceholder<M, T> placeholder, KeyValueStorage<M, T> otherStorage) {
        ArraysUtils.replace(this.levels, ((ValuePlaceholder)placeholder).level, otherStorage.levels);
        ArraysUtils.replace(this.placeholders, placeholder, otherStorage.placeholders);
    }

    private Level<M, T> getLastLevel() {
        if (this.levels.isEmpty()) {
            this.addLevel();
        }
        Level<M, T> lastLevel = this.levels.peekLast();
        return lastLevel;
    }

    private Level<M, T> addLevel() {
        this.levels.add(new Level());
        return this.levels.peekLast();
    }

    public KeyValueStorage<M, T> clone() {
        try {
            KeyValueStorage clone = (KeyValueStorage)super.clone();
            clone.levels = ArraysUtils.deeplyClonedLinkedList(this.levels);
            clone.placeholders = new LinkedList();
            for (ValuePlaceholder valuePlaceholder : this.placeholders) {
                int index = this.levels.indexOf(valuePlaceholder.level);
                Level<M, T> levelClone = clone.levels.get(index);
                clone.placeholders.add(new ValuePlaceholder<M, T>(levelClone));
            }
            return clone;
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Impossible state.");
        }
    }

    public String toString() {
        return this.levels.toString();
    }

    public static class ValuePlaceholder<M, T> {
        private final Level<M, T> level;

        public ValuePlaceholder(Level<M, T> level) {
            this.level = level;
        }
    }

    private static class Level<M, T>
    implements PubliclyCloneable {
        private Map<M, T> storage = new HashMap<M, T>();

        private Level() {
        }

        public void add(M key, T thing) {
            this.storage.put(key, thing);
        }

        public Collection<Map.Entry<M, T>> getAllEntries() {
            return this.storage.entrySet();
        }

        public T getValue(M key) {
            return this.storage.get(key);
        }

        public void remove(M key) {
            this.storage.remove(key);
        }

        public boolean contains(M key) {
            return this.storage.containsKey(key);
        }

        public void addAll(Level<M, T> otherLevel) {
            for (Map.Entry<M, T> entry : otherLevel.storage.entrySet()) {
                this.add(entry.getKey(), entry.getValue());
            }
        }

        @Override
        public Level<M, T> clone() {
            try {
                Level clone = (Level)super.clone();
                clone.storage = new HashMap<M, T>(this.storage);
                return clone;
            }
            catch (CloneNotSupportedException e) {
                throw new IllegalStateException("Impossible state.");
            }
        }

        public String toString() {
            return "Level: " + this.storage.toString();
        }
    }
}

