/*
 * Decompiled with CFR 0.152.
 */
package com.github.sommeri.less4j.core.compiler.stages;

import com.github.sommeri.less4j.core.ast.ASTCssNode;
import com.github.sommeri.less4j.core.ast.ASTCssNodeType;
import com.github.sommeri.less4j.core.ast.Body;
import com.github.sommeri.less4j.core.ast.BodyOwner;
import com.github.sommeri.less4j.core.ast.RuleSet;
import com.github.sommeri.less4j.core.ast.Selector;
import com.github.sommeri.less4j.core.compiler.stages.ASTManipulator;
import java.util.ArrayList;

public class FinalVisibilitySolver {
    private final ASTManipulator manipulator = new ASTManipulator();

    public void resolveVisibility(ASTCssNode node) {
        if (node.getVisibility() == ASTCssNode.Visibility.DEFAULT) {
            return;
        }
        if (node.getType() == ASTCssNodeType.RULE_SET) {
            this.handleRuleset((RuleSet)node);
        } else if (node instanceof Body) {
            this.handleBodyKids((Body)node);
        } else if (node instanceof BodyOwner) {
            Object body = ((BodyOwner)((Object)node)).getBody();
            this.handleBodyKids((Body)body);
        }
    }

    private void handleRuleset(RuleSet node) {
        ArrayList<Selector> removeSelectors = null;
        for (Selector selector : node.getSelectors()) {
            switch (selector.getVisibility()) {
                case DEFAULT: {
                    if (removeSelectors == null) {
                        removeSelectors = new ArrayList<Selector>();
                    }
                    removeSelectors.add(selector);
                    break;
                }
            }
        }
        if (removeSelectors != null) {
            node.getSelectors().removeAll(removeSelectors);
        }
        this.handleBodyKids(node.getBody());
    }

    private void handleBodyKids(Body body) {
        if (body == null) {
            return;
        }
        ArrayList<ASTCssNode> removeKids = null;
        for (ASTCssNode kid : body.getMembers()) {
            switch (kid.getVisibility()) {
                case DEFAULT: {
                    if (removeKids == null) {
                        removeKids = new ArrayList<ASTCssNode>();
                    }
                    removeKids.add(kid);
                    break;
                }
                case VISIBLE: {
                    this.resolveVisibility(kid);
                }
            }
        }
        if (removeKids != null) {
            this.manipulator.removeFromBody(body, removeKids);
        }
    }
}

