/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.util.iso;

import java.io.Serializable;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import javax.xml.bind.annotation.XmlTransient;
import org.apache.sis.internal.system.DefaultFactories;
import org.apache.sis.util.SimpleInternationalString;
import org.apache.sis.util.iso.DefaultLocalName;
import org.apache.sis.util.iso.DefaultNameSpace;
import org.apache.sis.util.iso.DefaultScopedName;
import org.apache.sis.util.resources.Errors;
import org.opengis.util.GenericName;
import org.opengis.util.InternationalString;
import org.opengis.util.LocalName;
import org.opengis.util.NameFactory;
import org.opengis.util.NameSpace;
import org.opengis.util.ScopedName;

@XmlTransient
public abstract class AbstractName
implements GenericName,
Serializable {
    private static final long serialVersionUID = 667242702456713391L;
    transient GenericName fullyQualified;
    transient CharSequence asString;
    private transient int hash;

    protected AbstractName() {
    }

    public static AbstractName castOrCopy(GenericName genericName) {
        if (genericName instanceof LocalName) {
            return DefaultLocalName.castOrCopy((LocalName)genericName);
        }
        if (genericName == null || genericName instanceof AbstractName) {
            return (AbstractName)genericName;
        }
        List list = genericName.getParsedNames();
        CharSequence[] charSequenceArray = new CharSequence[list.size()];
        int n = 0;
        for (LocalName localName : list) {
            charSequenceArray[n++] = localName.toInternationalString();
        }
        if (n != charSequenceArray.length) {
            throw new ConcurrentModificationException(Errors.format((short)134, "parsedNames"));
        }
        NameFactory nameFactory = DefaultFactories.forBuildin(NameFactory.class);
        return (AbstractName)nameFactory.createGenericName(genericName.scope(), charSequenceArray);
    }

    public abstract NameSpace scope();

    public int depth() {
        return this.getParsedNames().size();
    }

    int arraySize() {
        return this.depth();
    }

    public abstract List<? extends LocalName> getParsedNames();

    public LocalName head() {
        return this.getParsedNames().get(0);
    }

    public LocalName tip() {
        List<? extends LocalName> list = this.getParsedNames();
        return list.get(list.size() - 1);
    }

    public synchronized GenericName toFullyQualifiedName() {
        if (this.fullyQualified == null) {
            NameSpace nameSpace = this.scope();
            if (nameSpace.isGlobal()) {
                this.fullyQualified = this;
            } else {
                GenericName genericName = nameSpace.name();
                assert (genericName.scope().isGlobal()) : genericName;
                this.fullyQualified = new DefaultScopedName(genericName, this);
            }
        }
        return this.fullyQualified;
    }

    public ScopedName push(GenericName genericName) {
        return new DefaultScopedName(genericName, this);
    }

    static String separator(GenericName genericName) {
        NameSpace nameSpace;
        if (genericName != null && (nameSpace = genericName.scope()) instanceof DefaultNameSpace) {
            return ((DefaultNameSpace)nameSpace).headSeparator;
        }
        return ":";
    }

    public synchronized String toString() {
        if (this.asString == null) {
            boolean bl = false;
            StringBuilder stringBuilder = new StringBuilder();
            for (LocalName localName : this.getParsedNames()) {
                if (bl) {
                    stringBuilder.append(AbstractName.separator((GenericName)localName));
                }
                bl = true;
                stringBuilder.append(localName);
            }
            this.asString = stringBuilder.toString();
        }
        return this.asString.toString();
    }

    public synchronized InternationalString toInternationalString() {
        if (!(this.asString instanceof InternationalString)) {
            this.asString = new International(this.toString(), this.getParsedNames());
        }
        return (InternationalString)this.asString;
    }

    public int compareTo(GenericName genericName) {
        Iterator<? extends LocalName> iterator = this.getParsedNames().iterator();
        Iterator iterator2 = genericName.getParsedNames().iterator();
        while (iterator.hasNext()) {
            if (!iterator2.hasNext()) {
                return 1;
            }
            LocalName localName = iterator.next();
            LocalName localName2 = (LocalName)iterator2.next();
            if (localName == this && localName2 == genericName) {
                throw new IllegalStateException(Errors.format((short)18));
            }
            int n = localName.compareTo((Object)localName2);
            if (n == 0) continue;
            return n;
        }
        return iterator2.hasNext() ? -1 : 0;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object != null && object.getClass() == this.getClass()) {
            AbstractName abstractName = (AbstractName)object;
            return Objects.equals(this.scope(), abstractName.scope()) && Objects.equals(this.getParsedNames(), abstractName.getParsedNames());
        }
        return false;
    }

    public int hashCode() {
        if (this.hash == 0) {
            int n = this.computeHashCode();
            if (n == 0) {
                n = -1;
            }
            this.hash = n;
        }
        return this.hash;
    }

    int computeHashCode() {
        return Objects.hash(this.scope(), this.getParsedNames()) ^ 0xE2E770AF;
    }

    private static final class International
    extends SimpleInternationalString {
        private static final long serialVersionUID = -5259001179796274879L;
        private final List<? extends LocalName> parsedNames;

        International(String string, List<? extends LocalName> list) {
            super(string);
            this.parsedNames = list;
        }

        @Override
        public String toString(Locale locale) {
            boolean bl = false;
            StringBuilder stringBuilder = new StringBuilder();
            for (LocalName localName : this.parsedNames) {
                if (bl) {
                    stringBuilder.append(AbstractName.separator((GenericName)localName));
                }
                bl = true;
                stringBuilder.append(localName.toInternationalString().toString(locale));
            }
            return stringBuilder.toString();
        }

        @Override
        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (super.equals(object)) {
                International international = (International)object;
                return Objects.equals(this.parsedNames, international.parsedNames);
            }
            return false;
        }

        @Override
        public int hashCode() {
            return this.parsedNames.hashCode() ^ 0x54E20141;
        }
    }
}

