/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.fit.factory;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import org.apache.commons.logging.LogFactory;
import org.apache.uima.UIMAFramework;
import org.apache.uima.fit.descriptor.FsIndex;
import org.apache.uima.fit.descriptor.FsIndexKey;
import org.apache.uima.fit.internal.MetaDataType;
import org.apache.uima.fit.internal.MetaDataUtil;
import org.apache.uima.fit.internal.ReflectionUtil;
import org.apache.uima.resource.ResourceInitializationException;
import org.apache.uima.resource.metadata.FsIndexCollection;
import org.apache.uima.resource.metadata.FsIndexDescription;
import org.apache.uima.resource.metadata.FsIndexKeyDescription;
import org.apache.uima.resource.metadata.Import;
import org.apache.uima.resource.metadata.impl.FsIndexCollection_impl;
import org.apache.uima.resource.metadata.impl.FsIndexDescription_impl;
import org.apache.uima.resource.metadata.impl.FsIndexKeyDescription_impl;
import org.apache.uima.resource.metadata.impl.Import_impl;
import org.apache.uima.util.InvalidXMLException;
import org.apache.uima.util.XMLInputSource;

public final class FsIndexFactory {
    public static final int STANDARD_COMPARE = 0;
    public static final int REVERSE_STANDARD_COMPARE = 1;
    private static final Object SCAN_LOCK = new Object();
    private static String[] indexDescriptorLocations;

    private FsIndexFactory() {
    }

    public static FsIndexCollection createFsIndexCollection(Class<?> componentClass) {
        FsIndex anFsIndex;
        ArrayList<FsIndex> anFsIndexList = new ArrayList<FsIndex>();
        org.apache.uima.fit.descriptor.FsIndexCollection anIndexCollection = ReflectionUtil.getInheritableAnnotation(org.apache.uima.fit.descriptor.FsIndexCollection.class, componentClass);
        if (anIndexCollection != null) {
            anFsIndexList.addAll(Arrays.asList(anIndexCollection.fsIndexes()));
        }
        if ((anFsIndex = ReflectionUtil.getInheritableAnnotation(FsIndex.class, componentClass)) != null) {
            if (anIndexCollection != null) {
                throw new IllegalStateException("Class [" + componentClass.getName() + "] must not " + "declare " + org.apache.uima.fit.descriptor.FsIndexCollection.class.getSimpleName() + " and " + FsIndex.class.getSimpleName() + " at the same time.");
            }
            anFsIndexList.add(anFsIndex);
        }
        FsIndexCollection_impl fsIndexCollection = new FsIndexCollection_impl();
        for (FsIndex anIdx : anFsIndexList) {
            String typeName;
            ArrayList<FsIndexKeyDescription> keys = new ArrayList<FsIndexKeyDescription>();
            for (FsIndexKey anIndexKey : anIdx.keys()) {
                keys.add(FsIndexFactory.createFsIndexKeyDescription(anIndexKey.featureName(), anIndexKey.comparator()));
            }
            if (!anIdx.typeName().equals("org.apache.uima.fit.descriptor.FsIndex.NO_NAME_TYPE_SET") && anIdx.type() != FsIndex.NoClassSet.class) {
                throw new IllegalStateException("Class [" + componentClass.getName() + "] must not " + "declare an " + FsIndex.class.getSimpleName() + " with type and typeName both set at the same time.");
            }
            if (!anIdx.typeName().equals("org.apache.uima.fit.descriptor.FsIndex.NO_NAME_TYPE_SET")) {
                typeName = anIdx.typeName();
            } else if (anIdx.type() != FsIndex.NoClassSet.class) {
                typeName = anIdx.type().getName();
            } else {
                throw new IllegalStateException("Class [" + componentClass.getName() + "] must not " + "declare an " + FsIndex.class.getSimpleName() + " with neither type nor typeName set.");
            }
            fsIndexCollection.addFsIndex(FsIndexFactory.createFsIndexDescription(anIdx.label(), anIdx.kind(), typeName, anIdx.typePriorities(), keys.toArray(new FsIndexKeyDescription[keys.size()])));
        }
        return fsIndexCollection;
    }

    public static FsIndexDescription createFsIndexDescription(String label, String kind, String typeName, boolean useTypePriorities, FsIndexKeyDescription ... keys) {
        FsIndexDescription_impl fsIndexDescription = new FsIndexDescription_impl();
        fsIndexDescription.setLabel(label);
        fsIndexDescription.setKind(kind);
        fsIndexDescription.setTypeName(typeName);
        fsIndexDescription.setKeys(keys);
        return fsIndexDescription;
    }

    public static FsIndexCollection createFsIndexCollection(FsIndexDescription ... descriptions) {
        FsIndexCollection_impl fsIndexCollection = new FsIndexCollection_impl();
        fsIndexCollection.setFsIndexes(descriptions);
        return fsIndexCollection;
    }

    public static FsIndexKeyDescription createFsIndexKeyDescription(String featureName) {
        return FsIndexFactory.createFsIndexKeyDescription(featureName, 0);
    }

    public static FsIndexKeyDescription createFsIndexKeyDescription(String featureName, int comparator) {
        FsIndexKeyDescription_impl key = new FsIndexKeyDescription_impl();
        key.setFeatureName(featureName);
        key.setComparator(comparator);
        key.setTypePriority(false);
        return key;
    }

    public static FsIndexCollection createFsIndexCollection(String ... descriptorNames) {
        ArrayList<Import_impl> imports = new ArrayList<Import_impl>();
        for (String descriptorName : descriptorNames) {
            Import_impl imp = new Import_impl();
            imp.setName(descriptorName);
            imports.add(imp);
        }
        Import[] importArray = new Import[imports.size()];
        FsIndexCollection_impl fsIndexCollection = new FsIndexCollection_impl();
        fsIndexCollection.setImports(imports.toArray(importArray));
        return fsIndexCollection;
    }

    public static FsIndexCollection createTypeSystemDescriptionFromPath(String ... descriptorURIs) {
        ArrayList<Import_impl> imports = new ArrayList<Import_impl>();
        for (String descriptorURI : descriptorURIs) {
            Import_impl imp = new Import_impl();
            imp.setLocation(descriptorURI);
            imports.add(imp);
        }
        Import[] importArray = new Import[imports.size()];
        FsIndexCollection_impl fsIndexCollection = new FsIndexCollection_impl();
        fsIndexCollection.setImports(imports.toArray(importArray));
        return fsIndexCollection;
    }

    public static FsIndexCollection createFsIndexCollection() throws ResourceInitializationException {
        ArrayList<FsIndexDescription> fsIndexList = new ArrayList<FsIndexDescription>();
        for (String location : FsIndexFactory.scanIndexDescriptors()) {
            try {
                XMLInputSource xmlInput = new XMLInputSource(location);
                FsIndexCollection fsIdxCol = UIMAFramework.getXMLParser().parseFsIndexCollection(xmlInput);
                fsIdxCol.resolveImports();
                fsIndexList.addAll(Arrays.asList(fsIdxCol.getFsIndexes()));
                LogFactory.getLog(FsIndexFactory.class).debug((Object)("Detected index at [" + location + "]"));
            }
            catch (IOException e) {
                throw new ResourceInitializationException((Throwable)e);
            }
            catch (InvalidXMLException e) {
                LogFactory.getLog(FsIndexFactory.class).warn((Object)("[" + location + "] is not a index descriptor file. Ignoring."), (Throwable)e);
            }
        }
        return FsIndexFactory.createFsIndexCollection(fsIndexList.toArray(new FsIndexDescription[fsIndexList.size()]));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String[] scanIndexDescriptors() throws ResourceInitializationException {
        Object object = SCAN_LOCK;
        synchronized (object) {
            if (indexDescriptorLocations == null) {
                indexDescriptorLocations = MetaDataUtil.scanDescriptors(MetaDataType.FS_INDEX);
            }
            return indexDescriptorLocations;
        }
    }

    public static void forceIndexDescriptorsScan() {
        indexDescriptorLocations = null;
    }
}

