/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.render.ps;

import java.awt.Color;
import java.awt.Point;
import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.fop.render.intermediate.BorderPainter;
import org.apache.fop.traits.RuleStyle;
import org.apache.fop.util.ColorUtil;
import org.apache.xmlgraphics.ps.PSGenerator;

public class PSBorderPainter
extends BorderPainter {
    private static Log log = LogFactory.getLog((Class)PSBorderPainter.class);
    private PSGenerator generator;

    public PSBorderPainter(PSGenerator generator) {
        this.generator = generator;
    }

    protected void drawBorderLine(int x1, int y1, int x2, int y2, boolean horz, boolean startOrBefore, int style, Color col) throws IOException {
        PSBorderPainter.drawBorderLine(this.generator, PSBorderPainter.toPoints(x1), PSBorderPainter.toPoints(y1), PSBorderPainter.toPoints(x2), PSBorderPainter.toPoints(y2), horz, startOrBefore, style, col);
    }

    private static void drawLine(PSGenerator gen, float startx, float starty, float endx, float endy) throws IOException {
        gen.writeln(gen.formatDouble((double)startx) + " " + gen.formatDouble((double)starty) + " M " + gen.formatDouble((double)endx) + " " + gen.formatDouble((double)endy) + " lineto stroke newpath");
    }

    public static void drawBorderLine(PSGenerator gen, float x1, float y1, float x2, float y2, boolean horz, boolean startOrBefore, int style, Color col) throws IOException {
        float w = x2 - x1;
        float h = y2 - y1;
        if (w < 0.0f || h < 0.0f) {
            log.error((Object)"Negative extent received. Border won't be painted.");
            return;
        }
        switch (style) {
            case 31: {
                gen.useColor(col);
                if (horz) {
                    float unit = Math.abs(2.0f * h);
                    int rep = (int)(w / unit);
                    if (rep % 2 == 0) {
                        ++rep;
                    }
                    unit = w / (float)rep;
                    gen.useDash("[" + unit + "] 0");
                    gen.useLineCap(0);
                    gen.useLineWidth((double)h);
                    float ym = y1 + h / 2.0f;
                    PSBorderPainter.drawLine(gen, x1, ym, x2, ym);
                    break;
                }
                float unit = Math.abs(2.0f * w);
                int rep = (int)(h / unit);
                if (rep % 2 == 0) {
                    ++rep;
                }
                unit = h / (float)rep;
                gen.useDash("[" + unit + "] 0");
                gen.useLineCap(0);
                gen.useLineWidth((double)w);
                float xm = x1 + w / 2.0f;
                PSBorderPainter.drawLine(gen, xm, y1, xm, y2);
                break;
            }
            case 36: {
                gen.useColor(col);
                gen.useLineCap(1);
                if (horz) {
                    float unit = Math.abs(2.0f * h);
                    int rep = (int)(w / unit);
                    if (rep % 2 == 0) {
                        ++rep;
                    }
                    unit = w / (float)rep;
                    gen.useDash("[0 " + unit + "] 0");
                    gen.useLineWidth((double)h);
                    float ym = y1 + h / 2.0f;
                    PSBorderPainter.drawLine(gen, x1, ym, x2, ym);
                    break;
                }
                float unit = Math.abs(2.0f * w);
                int rep = (int)(h / unit);
                if (rep % 2 == 0) {
                    ++rep;
                }
                unit = h / (float)rep;
                gen.useDash("[0 " + unit + "] 0");
                gen.useLineWidth((double)w);
                float xm = x1 + w / 2.0f;
                PSBorderPainter.drawLine(gen, xm, y1, xm, y2);
                break;
            }
            case 37: {
                gen.useColor(col);
                gen.useDash(null);
                if (horz) {
                    float h3 = h / 3.0f;
                    gen.useLineWidth((double)h3);
                    float ym1 = y1 + h3 / 2.0f;
                    float ym2 = ym1 + h3 + h3;
                    PSBorderPainter.drawLine(gen, x1, ym1, x2, ym1);
                    PSBorderPainter.drawLine(gen, x1, ym2, x2, ym2);
                    break;
                }
                float w3 = w / 3.0f;
                gen.useLineWidth((double)w3);
                float xm1 = x1 + w3 / 2.0f;
                float xm2 = xm1 + w3 + w3;
                PSBorderPainter.drawLine(gen, xm1, y1, xm1, y2);
                PSBorderPainter.drawLine(gen, xm2, y1, xm2, y2);
                break;
            }
            case 55: 
            case 119: {
                float colFactor = style == 55 ? 0.4f : -0.4f;
                gen.useDash(null);
                if (horz) {
                    Color uppercol = ColorUtil.lightenColor(col, -colFactor);
                    Color lowercol = ColorUtil.lightenColor(col, colFactor);
                    float h3 = h / 3.0f;
                    gen.useLineWidth((double)h3);
                    float ym1 = y1 + h3 / 2.0f;
                    gen.useColor(uppercol);
                    PSBorderPainter.drawLine(gen, x1, ym1, x2, ym1);
                    gen.useColor(col);
                    PSBorderPainter.drawLine(gen, x1, ym1 + h3, x2, ym1 + h3);
                    gen.useColor(lowercol);
                    PSBorderPainter.drawLine(gen, x1, ym1 + h3 + h3, x2, ym1 + h3 + h3);
                    break;
                }
                Color leftcol = ColorUtil.lightenColor(col, -colFactor);
                Color rightcol = ColorUtil.lightenColor(col, colFactor);
                float w3 = w / 3.0f;
                gen.useLineWidth((double)w3);
                float xm1 = x1 + w3 / 2.0f;
                gen.useColor(leftcol);
                PSBorderPainter.drawLine(gen, xm1, y1, xm1, y2);
                gen.useColor(col);
                PSBorderPainter.drawLine(gen, xm1 + w3, y1, xm1 + w3, y2);
                gen.useColor(rightcol);
                PSBorderPainter.drawLine(gen, xm1 + w3 + w3, y1, xm1 + w3 + w3, y2);
                break;
            }
            case 67: 
            case 101: {
                float colFactor = style == 101 ? 0.4f : -0.4f;
                gen.useDash(null);
                if (horz) {
                    Color c = ColorUtil.lightenColor(col, (float)(startOrBefore ? 1 : -1) * colFactor);
                    gen.useLineWidth((double)h);
                    float ym1 = y1 + h / 2.0f;
                    gen.useColor(c);
                    PSBorderPainter.drawLine(gen, x1, ym1, x2, ym1);
                    break;
                }
                Color c = ColorUtil.lightenColor(col, (float)(startOrBefore ? 1 : -1) * colFactor);
                gen.useLineWidth((double)w);
                float xm1 = x1 + w / 2.0f;
                gen.useColor(c);
                PSBorderPainter.drawLine(gen, xm1, y1, xm1, y2);
                break;
            }
            case 57: {
                break;
            }
            default: {
                gen.useColor(col);
                gen.useDash(null);
                gen.useLineCap(0);
                if (horz) {
                    gen.useLineWidth((double)h);
                    float ym = y1 + h / 2.0f;
                    PSBorderPainter.drawLine(gen, x1, ym, x2, ym);
                    break;
                }
                gen.useLineWidth((double)w);
                float xm = x1 + w / 2.0f;
                PSBorderPainter.drawLine(gen, xm, y1, xm, y2);
            }
        }
    }

    public void drawLine(Point start, Point end, int width, Color color, RuleStyle style) throws IOException {
        if (start.y != end.y) {
            throw new UnsupportedOperationException("Can only deal with horizontal lines right now");
        }
        this.saveGraphicsState();
        int half = width / 2;
        int starty = start.y - half;
        switch (style.getEnumValue()) {
            case 31: 
            case 37: 
            case 133: {
                this.drawBorderLine(start.x, starty, end.x, starty + width, true, true, style.getEnumValue(), color);
                break;
            }
            case 36: {
                this.clipRect(start.x, starty, end.x - start.x, width);
                this.generator.concatMatrix(1.0, 0.0, 0.0, 1.0, (double)PSBorderPainter.toPoints(half), 0.0);
                this.drawBorderLine(start.x, starty, end.x, starty + width, true, true, style.getEnumValue(), color);
                break;
            }
            case 55: 
            case 119: {
                this.generator.useColor(ColorUtil.lightenColor(color, 0.6f));
                this.moveTo(start.x, starty);
                this.lineTo(end.x, starty);
                this.lineTo(end.x, starty + 2 * half);
                this.lineTo(start.x, starty + 2 * half);
                this.closePath();
                this.generator.writeln(" fill newpath");
                this.generator.useColor(color);
                if (style == RuleStyle.GROOVE) {
                    this.moveTo(start.x, starty);
                    this.lineTo(end.x, starty);
                    this.lineTo(end.x, starty + half);
                    this.lineTo(start.x + half, starty + half);
                    this.lineTo(start.x, starty + 2 * half);
                } else {
                    this.moveTo(end.x, starty);
                    this.lineTo(end.x, starty + 2 * half);
                    this.lineTo(start.x, starty + 2 * half);
                    this.lineTo(start.x, starty + half);
                    this.lineTo(end.x - half, starty + half);
                }
                this.closePath();
                this.generator.writeln(" fill newpath");
                break;
            }
            default: {
                throw new UnsupportedOperationException("rule style not supported");
            }
        }
        this.restoreGraphicsState();
    }

    private static float toPoints(int mpt) {
        return (float)mpt / 1000.0f;
    }

    protected void moveTo(int x, int y) throws IOException {
        this.generator.writeln(this.generator.formatDouble((double)PSBorderPainter.toPoints(x)) + " " + this.generator.formatDouble((double)PSBorderPainter.toPoints(y)) + " M");
    }

    protected void lineTo(int x, int y) throws IOException {
        this.generator.writeln(this.generator.formatDouble((double)PSBorderPainter.toPoints(x)) + " " + this.generator.formatDouble((double)PSBorderPainter.toPoints(y)) + " lineto");
    }

    protected void closePath() throws IOException {
        this.generator.writeln("cp");
    }

    private void clipRect(int x, int y, int width, int height) throws IOException {
        this.generator.defineRect((double)PSBorderPainter.toPoints(x), (double)PSBorderPainter.toPoints(y), (double)PSBorderPainter.toPoints(width), (double)PSBorderPainter.toPoints(height));
        this.clip();
    }

    protected void clip() throws IOException {
        this.generator.writeln("clip newpath");
    }

    protected void saveGraphicsState() throws IOException {
        this.generator.saveGraphicsState();
    }

    protected void restoreGraphicsState() throws IOException {
        this.generator.restoreGraphicsState();
    }
}

