/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.util.collection;

import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.lang.ref.WeakReference;
import java.util.AbstractMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import org.apache.sis.internal.system.DelayedExecutor;
import org.apache.sis.internal.system.DelayedRunnable;
import org.apache.sis.internal.system.ReferenceQueueConsumer;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.Disposable;
import org.apache.sis.util.collection.CacheEntries;
import org.apache.sis.util.collection.Containers;
import org.apache.sis.util.resources.Errors;

public class Cache<K, V>
extends AbstractMap<K, V>
implements ConcurrentMap<K, V> {
    private final ConcurrentMap<K, Object> map;
    private final Map<K, Integer> costs;
    private long totalCost;
    private final long costLimit;
    private final boolean soft;
    private volatile boolean isKeyCollisionAllowed;
    private volatile transient Set<Map.Entry<K, V>> entries;

    public Cache() {
        this(12, 100L, false);
    }

    public Cache(int n, long l, boolean bl) {
        ArgumentChecks.ensureStrictlyPositive("initialCapacity", n);
        ArgumentChecks.ensurePositive("costLimit", l);
        n = Containers.hashMapCapacity(n);
        this.map = new ConcurrentHashMap<K, Object>(n);
        this.costs = new LinkedHashMap<K, Integer>((int)Math.min((long)n, l), 0.75f, true);
        this.costLimit = l;
        this.soft = bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() {
        Map<K, Integer> map = this.costs;
        synchronized (map) {
            this.map.clear();
            this.costs.clear();
            this.totalCost = 0L;
        }
    }

    @Override
    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    @Override
    public int size() {
        return this.map.size();
    }

    @Override
    public V get(Object object) {
        return Cache.valueOf(this.map.get(object));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public V getOrCreate(K k, Callable<? extends V> callable) throws Exception {
        V v = this.peek(k);
        if (v == null) {
            Handler<V> handler = this.lock(k);
            try {
                v = handler.peek();
                if (v == null) {
                    v = callable.call();
                }
            }
            finally {
                handler.putAndUnlock(v);
            }
        }
        return v;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V computeIfAbsent(K k, Function<? super K, ? extends V> function) {
        V v = this.peek(k);
        if (v == null) {
            Handler<V> handler = this.lock(k);
            try {
                v = handler.peek();
                if (v == null) {
                    v = function.apply(k);
                }
            }
            finally {
                handler.putAndUnlock(v);
            }
        }
        return v;
    }

    static boolean isReservedType(Object object) {
        return object instanceof Handler || object instanceof Reference;
    }

    private static void ensureValidType(Object object) throws IllegalArgumentException {
        if (Cache.isReservedType(object)) {
            throw new IllegalArgumentException(Errors.format((short)42, "value", object.getClass()));
        }
    }

    private static <V> V valueOf(Object object) {
        if (object instanceof Reference) {
            return (V)((Reference)object).get();
        }
        if (object instanceof Handler) {
            return (V)((Supplier)object).get();
        }
        return (V)object;
    }

    private static <V> V immediateValueOf(Object object) {
        if (object instanceof Reference) {
            return (V)((Reference)object).get();
        }
        if (object instanceof Handler) {
            return null;
        }
        return (V)object;
    }

    final void notifyChange(K k, V v) {
        DelayedExecutor.schedule(new Strong(k, v));
    }

    @Override
    public V putIfAbsent(K k, V v) {
        if (v == null) {
            return null;
        }
        Cache.ensureValidType(v);
        Object object = this.map.putIfAbsent(k, v);
        if (object == null) {
            this.notifyChange(k, v);
        }
        return Cache.valueOf(object);
    }

    @Override
    public V put(K k, V v) {
        Object v2;
        Cache.ensureValidType(v);
        Object v3 = v2 = v != null ? this.map.put(k, v) : this.map.remove(k);
        if (v2 != v) {
            this.notifyChange(k, v);
        }
        return Cache.immediateValueOf(v2);
    }

    @Override
    public V replace(K k, V v) {
        Object object;
        Cache.ensureValidType(v);
        Object object2 = object = v != null ? this.map.replace(k, v) : this.map.remove(k);
        if (object != null) {
            this.notifyChange(k, v);
        }
        return Cache.immediateValueOf(object);
    }

    @Override
    public boolean replace(K k, V v, V v2) {
        boolean bl;
        Cache.ensureValidType(v2);
        if (v != null) {
            bl = v2 != null ? this.map.replace(k, v, v2) : this.map.remove(k, v);
        } else {
            boolean bl2 = bl = v2 != null && this.map.putIfAbsent(k, v2) == null;
        }
        if (bl) {
            this.notifyChange(k, v2);
        }
        return bl;
    }

    @Override
    public void replaceAll(BiFunction<? super K, ? super V, ? extends V> biFunction) {
        ReplaceAdapter replaceAdapter = new ReplaceAdapter(biFunction);
        this.map.replaceAll(replaceAdapter);
        Deferred.notifyChanges(this, replaceAdapter.changes);
    }

    @Override
    public V computeIfPresent(K k, BiFunction<? super K, ? super V, ? extends V> biFunction) {
        ReplaceAdapter replaceAdapter = new ReplaceAdapter(biFunction);
        Object object = this.map.computeIfPresent(k, replaceAdapter);
        Deferred.notifyChanges(this, replaceAdapter.changes);
        return Cache.valueOf(object);
    }

    @Override
    public V compute(K k, BiFunction<? super K, ? super V, ? extends V> biFunction) {
        ReplaceAdapter replaceAdapter = new ReplaceAdapter(biFunction);
        Object object = this.map.compute(k, replaceAdapter);
        Deferred.notifyChanges(this, replaceAdapter.changes);
        return Cache.valueOf(object);
    }

    @Override
    public V merge(final K k, V v, final BiFunction<? super V, ? super V, ? extends V> biFunction) {
        Cache.ensureValidType(v);
        final class Adapter
        implements BiFunction<Object, Object, Object> {
            Deferred<K, V> changes;

            Adapter() {
            }

            @Override
            public Object apply(Object object, Object object2) {
                Object object3 = Cache.valueOf(object);
                Object r = biFunction.apply(object3, Cache.valueOf(object2));
                Cache.ensureValidType(r);
                if (r != object3) {
                    this.changes = new Deferred(k, r, this.changes);
                }
                return r;
            }
        }
        Adapter adapter = new Adapter();
        Object object = this.map.merge(k, v, adapter);
        Deferred.notifyChanges(this, adapter.changes);
        return Cache.valueOf(object);
    }

    @Override
    public V remove(Object object) {
        Object v = this.map.remove(object);
        if (v != null) {
            this.notifyChange(object, null);
        }
        return Cache.immediateValueOf(v);
    }

    @Override
    public boolean remove(Object object, Object object2) {
        boolean bl = this.map.remove(object, object2);
        if (bl) {
            this.notifyChange(object, null);
        }
        return bl;
    }

    @Override
    public boolean containsKey(Object object) {
        return this.map.containsKey(object);
    }

    public V peek(K k) {
        Object v = this.map.get(k);
        if (v instanceof Handler) {
            return null;
        }
        if (v instanceof Reference) {
            Reference reference = (Reference)v;
            Object t = reference.get();
            if (t != null && this.map.replace(k, reference, t)) {
                reference.clear();
                this.notifyChange(k, t);
            }
            return (V)t;
        }
        Object v2 = v;
        return v2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Handler<V> lock(K k) {
        Object object;
        Object object2;
        Work work = new Work(k);
        boolean bl = true;
        work.lock.lock();
        try {
            while (true) {
                if ((object2 = this.map.putIfAbsent(k, work)) == null) {
                    bl = false;
                    object = work;
                    return object;
                }
                if (!(object2 instanceof Reference)) {
                    break;
                }
                object = (Reference)object2;
                Object t = ((Reference)object).get();
                if (t != null) {
                    if (this.map.replace(k, object, t)) {
                        ((Reference)object).clear();
                        this.notifyChange(k, t);
                    }
                    Simple simple = new Simple(t);
                    return simple;
                }
                if (!this.map.replace(k, object, work)) continue;
                bl = false;
                Work work2 = work;
                return work2;
            }
        }
        finally {
            if (bl) {
                work.lock.unlock();
            }
        }
        if (object2 instanceof Handler) {
            object = (Work)object2;
            if (((Work)object).lock.isHeldByCurrentThread()) {
                if (this.isKeyCollisionAllowed()) {
                    return new Simple<Object>(null);
                }
                throw new IllegalStateException(Errors.format((short)123, k));
            }
            return (Work)object.new Work.Wait();
        }
        assert (!Cache.isReservedType(object2)) : object2;
        object = object2;
        return new Simple<Object>(object);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void adjustReferences(K k, V v) {
        int n = v != null ? this.cost(v) : 0;
        Map<K, Integer> map = this.costs;
        synchronized (map) {
            Integer n2 = this.costs.put(k, n);
            if (n2 != null) {
                n -= n2.intValue();
            }
            if ((this.totalCost += (long)n) > this.costLimit) {
                Iterator<Map.Entry<K, Integer>> iterator = this.costs.entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry<K, Integer> entry = iterator.next();
                    K k2 = entry.getKey();
                    Object v2 = this.map.get(k2);
                    if (v2 != null && !Cache.isReservedType(v2)) {
                        Reference reference;
                        Reference reference2 = reference = this.soft ? new Soft(this.map, k2, v2) : new Weak(this.map, k2, v2);
                        if (!this.map.replace(k2, v2, reference)) {
                            reference.clear();
                        }
                    }
                    iterator.remove();
                    if ((this.totalCost -= (long)entry.getValue().intValue()) > this.costLimit) continue;
                    break;
                }
            }
        }
    }

    @Override
    public Set<K> keySet() {
        return this.map.keySet();
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        Set<Map.Entry<K, V>> set = this.entries;
        return set != null ? set : (this.entries = new CacheEntries(this.map.entrySet()));
    }

    public boolean isKeyCollisionAllowed() {
        return this.isKeyCollisionAllowed;
    }

    public void setKeyCollisionAllowed(boolean bl) {
        this.isKeyCollisionAllowed = bl;
    }

    protected int cost(V v) {
        return 1;
    }

    public static interface Handler<V> {
        public V peek();

        public void putAndUnlock(V var1) throws IllegalStateException;
    }

    private final class Strong
    extends DelayedRunnable.Immediate {
        private final K key;
        private final V value;

        Strong(K k, V v) {
            this.key = k;
            this.value = v;
        }

        @Override
        public void run() {
            Cache.this.adjustReferences(this.key, this.value);
        }
    }

    private final class ReplaceAdapter
    implements BiFunction<K, Object, Object> {
        private Deferred<K, V> changes;
        private final BiFunction<? super K, ? super V, ? extends V> remapping;

        ReplaceAdapter(BiFunction<? super K, ? super V, ? extends V> biFunction) {
            this.remapping = biFunction;
        }

        @Override
        public Object apply(K k, Object object) {
            Object object2 = Cache.valueOf(object);
            Object v = this.remapping.apply(k, object2);
            Cache.ensureValidType(v);
            if (v != object2) {
                this.changes = new Deferred(k, v, this.changes);
            }
            return v;
        }
    }

    private static final class Deferred<K, V> {
        private final K key;
        private final V value;
        private final Deferred<K, V> next;

        Deferred(K k, V v, Deferred<K, V> deferred) {
            this.key = k;
            this.value = v;
            this.next = deferred;
        }

        static <K, V> void notifyChanges(Cache<K, V> cache, Deferred<K, V> deferred) {
            while (deferred != null) {
                cache.notifyChange(deferred.key, deferred.value);
                deferred = deferred.next;
            }
        }
    }

    final class Work
    extends DelayedRunnable.Immediate
    implements Handler<V>,
    Supplier<V> {
        final ReentrantLock lock = new ReentrantLock();
        final K key;
        private V value;

        Work(K k) {
            this.key = k;
        }

        @Override
        public V get() {
            if (this.lock.isHeldByCurrentThread()) {
                return null;
            }
            this.lock.lock();
            Object v = this.value;
            this.lock.unlock();
            return v;
        }

        @Override
        public V peek() {
            return this.value;
        }

        @Override
        public void putAndUnlock(V v) throws IllegalStateException {
            boolean bl;
            try {
                if (Cache.isReservedType(v)) {
                    throw new IllegalArgumentException(Errors.format((short)42, "result", v.getClass()));
                }
                this.value = v;
                bl = v != null ? Cache.this.map.replace(this.key, this, v) : Cache.this.map.remove(this.key, this);
            }
            finally {
                this.lock.unlock();
            }
            if (bl) {
                DelayedExecutor.schedule(this);
            } else if (!Cache.this.isKeyCollisionAllowed()) {
                throw new IllegalStateException(Errors.format((short)75, this.key));
            }
        }

        @Override
        public void run() {
            Object v = this.value;
            if (v != null) {
                Cache.this.adjustReferences(this.key, v);
            }
        }

        final class Wait
        implements Handler<V> {
            Wait() {
            }

            @Override
            public V peek() {
                return Work.this.get();
            }

            @Override
            public void putAndUnlock(V v) throws IllegalStateException {
                if (v != null && !Cache.this.isKeyCollisionAllowed() && v != Work.this.get()) {
                    throw new IllegalStateException(Errors.format((short)75, Work.this.key));
                }
            }
        }
    }

    private final class Simple<V>
    implements Handler<V> {
        private final V value;

        Simple(V v) {
            this.value = v;
        }

        @Override
        public V peek() {
            return this.value;
        }

        @Override
        public void putAndUnlock(V v) throws IllegalStateException {
            if (v != this.value && !Cache.this.isKeyCollisionAllowed()) {
                throw new IllegalStateException(Errors.format((short)75, "<unknown>"));
            }
        }
    }

    private static final class Soft<K, V>
    extends SoftReference<V>
    implements Disposable {
        private final K key;
        private final ConcurrentMap<K, Object> map;

        Soft(ConcurrentMap<K, Object> concurrentMap, K k, V v) {
            super(v, ReferenceQueueConsumer.QUEUE);
            this.map = concurrentMap;
            this.key = k;
        }

        @Override
        public void dispose() {
            this.map.remove(this.key, this);
        }
    }

    private static final class Weak<K, V>
    extends WeakReference<V>
    implements Disposable {
        private final K key;
        private final ConcurrentMap<K, Object> map;

        Weak(ConcurrentMap<K, Object> concurrentMap, K k, V v) {
            super(v, ReferenceQueueConsumer.QUEUE);
            this.map = concurrentMap;
            this.key = k;
        }

        @Override
        public void dispose() {
            this.map.remove(this.key, this);
        }
    }
}

