/*
 * Decompiled with CFR 0.152.
 */
package com.github.sommeri.less4j.core.compiler.expressions;

import com.github.sommeri.less4j.core.ast.ColorExpression;
import com.github.sommeri.less4j.core.ast.Expression;
import com.github.sommeri.less4j.core.ast.NumberExpression;
import com.github.sommeri.less4j.core.compiler.expressions.CatchAllMultiParameterFunction;
import com.github.sommeri.less4j.core.compiler.expressions.HSLAValue;
import com.github.sommeri.less4j.core.compiler.expressions.HSVAValue;
import com.github.sommeri.less4j.core.parser.HiddenTokenAwareTree;

abstract class AbstractColorFunction
extends CatchAllMultiParameterFunction {
    static final int[][] hsvaPerm = new int[][]{{0, 3, 1}, {2, 0, 1}, {1, 0, 3}, {1, 2, 0}, {3, 1, 0}, {0, 1, 2}};

    AbstractColorFunction() {
    }

    static double round8(double value) {
        double rounding = 1.0E8;
        return (double)Math.round(value * rounding) / rounding;
    }

    static double clamp(double val) {
        return Math.min(1.0, Math.max(0.0, val));
    }

    static ColorExpression rgb(double r, double g, double b, HiddenTokenAwareTree token) {
        return new ColorExpression(token, r, g, b);
    }

    static ColorExpression rgba(double r, double g, double b, double a, HiddenTokenAwareTree token) {
        return new ColorExpression.ColorWithAlphaExpression(token, r, g, b, a);
    }

    static ColorExpression hsla(HSLAValue hsla, HiddenTokenAwareTree token) {
        double h = hsla.h % 360.0 / 360.0;
        double s = hsla.s;
        double l = hsla.l;
        double a = hsla.a;
        double m2 = l <= 0.5 ? l * (s + 1.0) : l + s - l * s;
        double m1 = l * 2.0 - m2;
        return AbstractColorFunction.rgba(AbstractColorFunction.hue(h + 0.3333333333333333, m1, m2) * 255.0, AbstractColorFunction.hue(h, m1, m2) * 255.0, AbstractColorFunction.hue(h - 0.3333333333333333, m1, m2) * 255.0, a, token);
    }

    private static double hue(double h, double m1, double m2) {
        double d = h < 0.0 ? h + 1.0 : (h = h > 1.0 ? h - 1.0 : h);
        if (h * 6.0 < 1.0) {
            return m1 + (m2 - m1) * h * 6.0;
        }
        if (h * 2.0 < 1.0) {
            return m2;
        }
        if (h * 3.0 < 2.0) {
            return m1 + (m2 - m1) * (0.6666666666666666 - h) * 6.0;
        }
        return m1;
    }

    static ColorExpression hsva(double h, double s, double v, double a, HiddenTokenAwareTree token) {
        h = h % 360.0 / 360.0 * 360.0;
        int i = (int)Math.floor(h / 60.0 % 6.0);
        double f = h / 60.0 - (double)i;
        double[] vs = new double[]{v, v * (1.0 - s), v * (1.0 - f * s), v * (1.0 - (1.0 - f) * s)};
        return AbstractColorFunction.rgba(vs[hsvaPerm[i][0]] * 255.0, vs[hsvaPerm[i][1]] * 255.0, vs[hsvaPerm[i][2]] * 255.0, a, token);
    }

    protected static Expression mix(ColorExpression color1, ColorExpression color2, NumberExpression weight, HiddenTokenAwareTree token) {
        double a;
        double p = weight.getValueAsDouble() / 100.0;
        double w = p * 2.0 - 1.0;
        double w1 = ((w * (a = color1.getAlpha() - color2.getAlpha()) == -1.0 ? w : (w + a) / (1.0 + w * a)) + 1.0) / 2.0;
        double w2 = 1.0 - w1;
        double red = color1.getRed() * w1 + color2.getRed() * w2;
        double green = color1.getGreen() * w1 + color2.getGreen() * w2;
        double blue = color1.getBlue() * w1 + color2.getBlue() * w2;
        if (color1.hasAlpha() || color2.hasAlpha()) {
            double alpha = color1.getAlpha() * p + color2.getAlpha() * (1.0 - p);
            return AbstractColorFunction.rgba(red, green, blue, alpha, token);
        }
        return AbstractColorFunction.rgb(red, green, blue, token);
    }

    static HSLAValue toHSLA(ColorExpression color) {
        double h;
        double s;
        double r = color.getRed() / 255.0;
        double g = color.getGreen() / 255.0;
        double b = color.getBlue() / 255.0;
        double a = color.getAlpha();
        double max = Math.max(r, Math.max(g, b));
        double min = Math.min(r, Math.min(g, b));
        double l = (max + min) / 2.0;
        double d = max - min;
        if (max == min) {
            s = 0.0;
            h = 0.0;
        } else {
            double d2 = s = l > 0.5 ? d / (2.0 - max - min) : d / (max + min);
            h = max == r ? (g - b) / d + (double)(g < b ? 6 : 0) : (max == g ? (b - r) / d + 2.0 : (r - g) / d + 4.0);
            h /= 6.0;
        }
        return new HSLAValue(h * 360.0, s, l, a);
    }

    static HSVAValue toHSVA(ColorExpression color) {
        double h;
        double r = color.getRed() / 255.0;
        double g = color.getGreen() / 255.0;
        double b = color.getBlue() / 255.0;
        double a = color.getAlpha();
        double max = Math.max(r, Math.max(g, b));
        double min = Math.min(r, Math.min(g, b));
        double v = max;
        double d = max - min;
        double s = max == 0.0 ? 0.0 : d / max;
        if (max == min) {
            h = 0.0;
        } else {
            h = max == r ? (g - b) / d + (double)(g < b ? 6 : 0) : (max == g ? (b - r) / d + 2.0 : (r - g) / d + 4.0);
            h /= 6.0;
        }
        return new HSVAValue(h * 360.0, s, v, a);
    }
}

