/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.filter;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.apache.sis.filter.Expression;
import org.apache.sis.filter.Filter;
import org.apache.sis.filter.Optimization;
import org.apache.sis.internal.filter.Node;
import org.apache.sis.internal.geoapi.filter.ComparisonOperatorName;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.xml.NilReason;

class UnaryFunction<R, V>
extends Node {
    private static final long serialVersionUID = 2020526901451551162L;
    protected final Expression<? super R, ? extends V> expression;

    UnaryFunction(Expression<? super R, ? extends V> expression) {
        ArgumentChecks.ensureNonNull("expression", expression);
        this.expression = expression;
    }

    public final List<Expression<? super R, ?>> getParameters() {
        return this.getExpressions();
    }

    public final List<Expression<? super R, ?>> getExpressions() {
        return Collections.singletonList(this.expression);
    }

    @Override
    protected Collection<?> getChildren() {
        return this.getExpressions();
    }

    static final class IsNil<R>
    extends UnaryFunction<R, Object>
    implements Filter<R>,
    Optimization.OnFilter<R> {
        private static final long serialVersionUID = -7540765433296725888L;
        private final String nilReason;

        IsNil(Expression<? super R, ?> expression, String string) {
            super(expression);
            this.nilReason = string;
        }

        public ComparisonOperatorName getOperatorType() {
            return ComparisonOperatorName.PROPERTY_IS_NIL;
        }

        @Override
        public Filter<R> recreate(Expression<? super R, ?>[] expressionArray) {
            return new IsNil<R>(expressionArray[0], this.nilReason);
        }

        public Optional<String> getNilReason() {
            return Optional.ofNullable(this.nilReason);
        }

        @Override
        public boolean test(R r) {
            NilReason nilReason = NilReason.forObject(this.expression.apply(r));
            if (nilReason == null) {
                return false;
            }
            if (this.nilReason == null) {
                return true;
            }
            String string = NilReason.OTHER.equals(nilReason) ? nilReason.getOtherExplanation() : nilReason.toString();
            return this.nilReason.equalsIgnoreCase(string);
        }
    }

    static final class IsNull<R>
    extends UnaryFunction<R, Object>
    implements Filter<R>,
    Optimization.OnFilter<R> {
        private static final long serialVersionUID = 2960285515924533419L;

        IsNull(Expression<? super R, ?> expression) {
            super(expression);
        }

        public ComparisonOperatorName getOperatorType() {
            return ComparisonOperatorName.PROPERTY_IS_NULL;
        }

        @Override
        public Filter<R> recreate(Expression<? super R, ?>[] expressionArray) {
            return new IsNull<R>(expressionArray[0]);
        }

        @Override
        protected char symbol() {
            return '\u2205';
        }

        @Override
        public boolean test(R r) {
            return this.expression.apply(r) == null;
        }
    }
}

