/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.coverage.j2d;

import java.awt.Color;
import java.util.Collection;
import java.util.Map;
import org.apache.sis.coverage.Category;
import org.apache.sis.measure.NumberRange;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.ArraysExt;
import org.opengis.util.InternationalString;

final class ColorsForRange
implements Comparable<ColorsForRange> {
    private final Category category;
    NumberRange<?> sampleRange;
    private final Color[] colors;

    ColorsForRange(Category category, NumberRange<?> numberRange, Color[] colorArray) {
        ArgumentChecks.ensureNonNull("sampleRange", numberRange);
        this.category = category;
        this.sampleRange = numberRange;
        this.colors = colorArray;
    }

    static ColorsForRange[] list(Collection<Map.Entry<NumberRange<?>, Color[]>> collection) {
        ColorsForRange[] colorsForRangeArray = new ColorsForRange[collection.size()];
        int n = 0;
        for (Map.Entry<NumberRange<?>, Color[]> entry : collection) {
            colorsForRangeArray[n++] = new ColorsForRange(null, entry.getKey(), entry.getValue());
        }
        return ArraysExt.resize(colorsForRangeArray, n);
    }

    final boolean isData() {
        return this.category == null || this.category.isQuantitative();
    }

    final CharSequence name() {
        InternationalString internationalString;
        if (this.category != null && (internationalString = this.category.getName()) != null) {
            return internationalString;
        }
        return this.sampleRange.toString();
    }

    public String toString() {
        return this.name().toString();
    }

    @Override
    public int compareTo(ColorsForRange colorsForRange) {
        return this.getAlpha() - colorsForRange.getAlpha();
    }

    private int getAlpha() {
        int n = 0;
        if (this.colors != null) {
            for (int i = 0; i < this.colors.length; ++i) {
                int n2 = this.colors[i].getAlpha();
                if (n2 <= n) continue;
                if (n2 >= 255) {
                    return 255;
                }
                n = n2;
            }
        }
        return n;
    }

    final int[] toARGB() {
        if (this.colors != null) {
            int n = 0;
            int[] nArray = new int[this.colors.length];
            for (int i = 0; i < nArray.length; ++i) {
                Color color = this.colors[i];
                if (color == null) continue;
                int n2 = color.getRGB();
                n |= n2;
                nArray[i] = n2;
            }
            if ((n & 0xFF000000) != 0) {
                return nArray;
            }
        }
        return ArraysExt.EMPTY_INT;
    }
}

