/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.metadata.iso.quality;

import java.util.Collection;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.apache.sis.internal.jaxb.FilterByVersion;
import org.apache.sis.metadata.iso.ISOMetadata;
import org.apache.sis.metadata.iso.maintenance.DefaultScope;
import org.opengis.metadata.lineage.Lineage;
import org.opengis.metadata.maintenance.ScopeCode;
import org.opengis.metadata.quality.DataQuality;
import org.opengis.metadata.quality.Element;
import org.opengis.metadata.quality.Scope;

@XmlType(name="DQ_DataQuality_Type", propOrder={"scope", "reports", "lineage"})
@XmlRootElement(name="DQ_DataQuality")
public class DefaultDataQuality
extends ISOMetadata
implements DataQuality {
    private static final long serialVersionUID = 5036527927404894540L;
    private Scope scope;
    private Collection<Element> reports;
    private Lineage lineage;

    public DefaultDataQuality() {
    }

    public DefaultDataQuality(ScopeCode scopeCode) {
        if (scopeCode != null) {
            this.scope = new DefaultScope(scopeCode);
        }
    }

    public DefaultDataQuality(Scope scope) {
        this.scope = scope;
    }

    public DefaultDataQuality(DataQuality dataQuality) {
        super(dataQuality);
        if (dataQuality != null) {
            this.scope = dataQuality.getScope();
            this.reports = this.copyCollection(dataQuality.getReports(), Element.class);
            this.lineage = dataQuality.getLineage();
        }
    }

    public static DefaultDataQuality castOrCopy(DataQuality dataQuality) {
        if (dataQuality == null || dataQuality instanceof DefaultDataQuality) {
            return (DefaultDataQuality)dataQuality;
        }
        return new DefaultDataQuality(dataQuality);
    }

    @XmlElement(name="scope", required=true)
    public Scope getScope() {
        return this.scope;
    }

    public void setScope(Scope scope) {
        this.checkWritePermission(this.scope);
        this.scope = scope;
    }

    @XmlElement(name="report", required=true)
    public Collection<Element> getReports() {
        this.reports = this.nonNullCollection(this.reports, Element.class);
        return this.reports;
    }

    public void setReports(Collection<? extends Element> collection) {
        this.reports = this.writeCollection(collection, this.reports, Element.class);
    }

    @XmlElement(name="lineage", namespace="http://www.isotc211.org/2005/gmd")
    public Lineage getLineage() {
        return FilterByVersion.LEGACY_METADATA.accept() ? this.lineage : null;
    }

    public void setLineage(Lineage lineage) {
        this.checkWritePermission(this.lineage);
        this.lineage = lineage;
    }
}

