/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.jdo.engine;

import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.castor.util.Messages;
import org.exolab.castor.jdo.QueryException;
import org.exolab.castor.jdo.TimeStampable;
import org.exolab.castor.jdo.engine.JDOFieldDescriptor;
import org.exolab.castor.jdo.engine.KeyGeneratorDescriptor;
import org.exolab.castor.mapping.ClassDescriptor;
import org.exolab.castor.mapping.MappingException;
import org.exolab.castor.mapping.loader.ClassDescriptorImpl;
import org.exolab.castor.mapping.xml.CacheTypeMapping;
import org.exolab.castor.mapping.xml.Param;

public class JDOClassDescriptor
extends ClassDescriptorImpl {
    private final String _tableName;
    private final String[] _idnames;
    private final KeyGeneratorDescriptor _keyGenDesc;
    private final Properties _cacheParams = new Properties();
    private Map _namedQueries = new HashMap();

    public JDOClassDescriptor(ClassDescriptor clsDesc, KeyGeneratorDescriptor keyGenDesc) throws MappingException {
        super((ClassDescriptorImpl)clsDesc);
        this._tableName = this.getMapping().getMapTo().getTable();
        if (this._tableName == null) {
            throw new IllegalArgumentException("Argument 'tableName' is null");
        }
        if (this.getIdentity() == null) {
            throw new MappingException("mapping.noIdentity", this.getJavaClass().getName());
        }
        if (!(this.getIdentity() instanceof JDOFieldDescriptor)) {
            throw new IllegalArgumentException("Identity field must be of type JDOFieldDescriptor");
        }
        if (this.getExtends() != null && !(this.getExtends() instanceof JDOClassDescriptor)) {
            throw new IllegalArgumentException("Extended class does not have a JDO descriptor");
        }
        this._idnames = new String[this._identities.length];
        for (int i = 0; i < this._idnames.length; ++i) {
            String[] sqlNames = ((JDOFieldDescriptor)this._identities[i]).getSQLName();
            if (sqlNames == null) {
                throw new MappingException("mapping.noSqlName", this._identities[i].getFieldName(), this.getJavaClass().getName());
            }
            this._idnames[i] = sqlNames[0];
        }
        this._keyGenDesc = keyGenDesc;
        CacheTypeMapping cacheMapping = this.getMapping().getCacheTypeMapping();
        if (cacheMapping != null) {
            String capacity = Integer.toString(cacheMapping.getCapacity());
            this._cacheParams.put("capacity", capacity);
            this._cacheParams.put("ttl", capacity);
            Param[] params = cacheMapping.getParam();
            for (int i = 0; i < params.length; ++i) {
                this._cacheParams.put(params[i].getName(), params[i].getValue());
            }
            String debug = new Boolean(cacheMapping.getDebug()).toString();
            this._cacheParams.put("debug", debug);
            String type = cacheMapping.getType();
            if (TimeStampable.class.isAssignableFrom(this.getJavaClass()) && type != null && type.equalsIgnoreCase("none")) {
                throw new MappingException(Messages.format("persist.wrongCacheTypeSpecified", this.getMapping().getName()));
            }
            this._cacheParams.put("type", type);
        }
        this._cacheParams.put("name", this.getMapping().getName());
    }

    public String getTableName() {
        return this._tableName;
    }

    public Properties getCacheParams() {
        return this._cacheParams;
    }

    public JDOFieldDescriptor getField(String name) {
        int i;
        JDOFieldDescriptor field = null;
        for (i = 0; i < this._fields.length; ++i) {
            if (!(this._fields[i] instanceof JDOFieldDescriptor) || !this._fields[i].getFieldName().equals(name)) continue;
            field = (JDOFieldDescriptor)this._fields[i];
            break;
        }
        if (field == null) {
            for (i = 0; i < this._identities.length; ++i) {
                if (!(this._identities[i] instanceof JDOFieldDescriptor) || !this._identities[i].getFieldName().equals(name)) continue;
                field = (JDOFieldDescriptor)this._identities[i];
            }
        }
        return field;
    }

    public KeyGeneratorDescriptor getKeyGeneratorDescriptor() {
        return this._keyGenDesc;
    }

    public String[] getIdentityColumnNames() {
        return this._idnames;
    }

    public String toString() {
        return super.toString() + " AS " + this._tableName;
    }

    public String getNamedQuery(String name) {
        String namedQuery = (String)this._namedQueries.get(name);
        return namedQuery;
    }

    public void addNamedQuery(String name, String namedQuery) throws QueryException {
        if (this._namedQueries.containsKey(name)) {
            throw new QueryException("Duplicate entry for named query " + name);
        }
        this._namedQueries.put(name, namedQuery);
    }
}

