/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.sis.internal.referencing.DeprecatedCode;
import org.apache.sis.internal.referencing.DeprecatedName;
import org.apache.sis.internal.system.DefaultFactories;
import org.apache.sis.metadata.iso.citation.Citations;
import org.apache.sis.referencing.IdentifiedObjects;
import org.apache.sis.referencing.ImmutableIdentifier;
import org.apache.sis.referencing.NamedIdentifier;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.Deprecable;
import org.apache.sis.util.iso.Types;
import org.apache.sis.util.resources.Errors;
import org.opengis.metadata.Identifier;
import org.opengis.metadata.citation.Citation;
import org.opengis.referencing.IdentifiedObject;
import org.opengis.referencing.ReferenceIdentifier;
import org.opengis.util.GenericName;
import org.opengis.util.InternationalString;
import org.opengis.util.NameFactory;
import org.opengis.util.NameSpace;

public abstract class Builder<B extends Builder<B>> {
    protected final Map<String, Object> properties;
    private final List<GenericName> aliases;
    private final List<ReferenceIdentifier> identifiers;
    private transient NameSpace namespace;
    private transient NameFactory nameFactory;

    protected Builder() {
        assert (Builder.verifyParameterizedType(this.getClass()));
        this.properties = new HashMap<String, Object>(8);
        this.aliases = new ArrayList<GenericName>();
        this.identifiers = new ArrayList<ReferenceIdentifier>();
    }

    private static boolean verifyParameterizedType(Class<?> clazz) {
        for (Class<?> clazz2 = clazz; clazz2 != null; clazz2 = clazz2.getSuperclass()) {
            ParameterizedType parameterizedType;
            Type type = clazz2.getGenericSuperclass();
            if (!(type instanceof ParameterizedType) || (parameterizedType = (ParameterizedType)type).getRawType() != Builder.class) continue;
            type = parameterizedType.getActualTypeArguments()[0];
            if (type == clazz) {
                return true;
            }
            throw new AssertionError(type);
        }
        return false;
    }

    private B self() {
        return (B)this;
    }

    protected Builder(IdentifiedObject identifiedObject) {
        this();
        if (identifiedObject != null) {
            this.properties.putAll(IdentifiedObjects.getProperties(identifiedObject, new String[0]));
            GenericName[] genericNameArray = (GenericName[])this.properties.remove("alias");
            ReferenceIdentifier[] referenceIdentifierArray = (ReferenceIdentifier[])this.properties.remove("identifiers");
            if (genericNameArray != null) {
                this.aliases.addAll(Arrays.asList(genericNameArray));
            }
            if (referenceIdentifierArray != null) {
                this.identifiers.addAll(Arrays.asList(referenceIdentifierArray));
            }
        }
    }

    private NameFactory factory() {
        if (this.nameFactory == null) {
            this.nameFactory = DefaultFactories.forBuildin(NameFactory.class);
        }
        return this.nameFactory;
    }

    private GenericName createName(CharSequence charSequence) {
        String string;
        NameFactory nameFactory = this.factory();
        if (this.namespace == null && (string = this.getCodeSpace()) != null) {
            this.namespace = nameFactory.createNameSpace((GenericName)nameFactory.createLocalName(null, (CharSequence)string), null);
        }
        return nameFactory.createLocalName(this.namespace, charSequence);
    }

    private GenericName createName(Citation citation, CharSequence charSequence) {
        if (citation == this.getAuthority()) {
            return this.createName(charSequence);
        }
        return new NamedIdentifier(citation, charSequence);
    }

    private ReferenceIdentifier createIdentifier(Citation citation, String string) {
        String string2;
        String string3;
        if (citation == this.getAuthority()) {
            string3 = this.getCodeSpace();
            string2 = this.getVersion();
        } else {
            string3 = Citations.toCodeSpace(citation);
            string2 = null;
        }
        return this.createIdentifier(citation, string3, string, string2);
    }

    private ReferenceIdentifier createIdentifier(Citation citation, String string, String string2, String string3) {
        if (this.isDeprecated()) {
            return new DeprecatedCode(citation, string, string2, string3, null, this.getRemarks());
        }
        return new ImmutableIdentifier(citation, string, string2, string3, this.getDescription());
    }

    private static ReferenceIdentifier toIdentifier(GenericName genericName) {
        return genericName instanceof ReferenceIdentifier ? (ReferenceIdentifier)genericName : new NamedIdentifier(genericName);
    }

    private boolean setProperty(String string, Object object) throws IllegalStateException {
        Object object2 = this.properties.putIfAbsent(string, object);
        if (object2 != null) {
            if (object2.equals(object)) {
                return false;
            }
            if (this.properties.get("name") != null) {
                throw new IllegalStateException(Errors.getResources(this.properties).getString((short)164, string));
            }
            this.properties.put(string, object);
        }
        return true;
    }

    private Citation getAuthority() {
        return (Citation)this.properties.get("authority");
    }

    private String getCodeSpace() {
        return (String)this.properties.get("codespace");
    }

    public B setCodeSpace(Citation citation, String string) {
        if (!this.setProperty("codespace", string)) {
            this.namespace = null;
        }
        this.setProperty("authority", citation);
        return this.self();
    }

    private String getVersion() {
        return (String)this.properties.get("version");
    }

    public B setVersion(String string) {
        this.setProperty("version", string);
        return this.self();
    }

    public B addName(CharSequence charSequence) {
        ArgumentChecks.ensureNonNull("name", charSequence);
        if (this.isDeprecated()) {
            this.aliases.add(new DeprecatedName(this.getAuthority(), this.getCodeSpace(), charSequence, this.getVersion(), this.getRemarks()));
        } else if (this.properties.putIfAbsent("name", charSequence.toString()) != null) {
            this.aliases.add(this.createName(charSequence));
        }
        return this.self();
    }

    public B addName(Citation citation, CharSequence charSequence) {
        ArgumentChecks.ensureNonNull("name", charSequence);
        boolean bl = this.isDeprecated();
        if (!bl && this.properties.get("name") != null) {
            this.aliases.add(this.createName(citation, charSequence));
        } else {
            String string;
            String string2;
            if (citation == this.getAuthority()) {
                string2 = this.getCodeSpace();
                string = this.getVersion();
            } else {
                string2 = Citations.toCodeSpace(citation);
                string = null;
            }
            if (bl) {
                this.aliases.add(new DeprecatedName(citation, string2, charSequence, string, this.getRemarks()));
            } else {
                this.properties.put("name", new NamedIdentifier(citation, string2, charSequence, string, this.getDescription()));
            }
        }
        return this.self();
    }

    public B addName(ReferenceIdentifier referenceIdentifier) {
        ArgumentChecks.ensureNonNull("name", referenceIdentifier);
        if (this.properties.putIfAbsent("name", referenceIdentifier) != null) {
            this.aliases.add((GenericName)(referenceIdentifier instanceof GenericName ? (GenericName)referenceIdentifier : new NamedIdentifier(referenceIdentifier)));
        }
        return this.self();
    }

    public B addName(GenericName genericName) {
        ArgumentChecks.ensureNonNull("name", genericName);
        if (this.properties.get("name") == null) {
            this.properties.put("name", Builder.toIdentifier(genericName));
        } else {
            this.aliases.add(genericName);
        }
        return this.self();
    }

    public B addIdentifier(String string) {
        ArgumentChecks.ensureNonNull("identifier", string);
        this.identifiers.add(this.createIdentifier(this.getAuthority(), this.getCodeSpace(), string, this.getVersion()));
        return this.self();
    }

    public B addIdentifier(Citation citation, String string) {
        ArgumentChecks.ensureNonNull("identifier", string);
        this.identifiers.add(this.createIdentifier(citation, string));
        return this.self();
    }

    public B addIdentifier(ReferenceIdentifier referenceIdentifier) {
        ArgumentChecks.ensureNonNull("identifier", referenceIdentifier);
        this.identifiers.add(referenceIdentifier);
        return this.self();
    }

    private static boolean isValid(Object object) {
        return object != null && (!(object instanceof Deprecable) || !((Deprecable)object).isDeprecated());
    }

    public B addNamesAndIdentifiers(IdentifiedObject identifiedObject) {
        ArgumentChecks.ensureNonNull("object", identifiedObject);
        for (Object object : identifiedObject.getIdentifiers()) {
            if (!Builder.isValid(object)) continue;
            this.addIdentifier((ReferenceIdentifier)object);
        }
        ReferenceIdentifier referenceIdentifier = identifiedObject.getName();
        if (Builder.isValid(referenceIdentifier)) {
            this.addName(referenceIdentifier);
        }
        for (GenericName genericName : identifiedObject.getAlias()) {
            if (!Builder.isValid(genericName)) continue;
            this.addName(genericName);
        }
        return this.self();
    }

    public B addNameAndIdentifier(Citation citation, IdentifiedObject identifiedObject) {
        ArgumentChecks.ensureNonNull("authority", citation);
        ArgumentChecks.ensureNonNull("object", identifiedObject);
        for (Object object : identifiedObject.getIdentifiers()) {
            if (!Builder.isValid(object) || !citation.equals(object.getAuthority())) continue;
            this.addIdentifier((ReferenceIdentifier)object);
        }
        ReferenceIdentifier referenceIdentifier = identifiedObject.getName();
        if (Builder.isValid(referenceIdentifier) && citation.equals(referenceIdentifier.getAuthority())) {
            this.addName(referenceIdentifier);
        }
        for (GenericName genericName : identifiedObject.getAlias()) {
            if (!Builder.isValid(genericName) || !(genericName instanceof Identifier) || !citation.equals(((Identifier)genericName).getAuthority())) continue;
            this.addName(genericName);
        }
        return this.self();
    }

    public B rename(Citation citation, CharSequence ... charSequenceArray) {
        ArgumentChecks.ensureNonNull("authority", citation);
        int n = charSequenceArray != null ? charSequenceArray.length : 0;
        int n2 = 0;
        int n3 = this.aliases.size();
        for (int i = -1; i < this.aliases.size(); ++i) {
            boolean bl;
            Object object;
            Object object2 = object = i < 0 ? this.properties.get("name") : this.aliases.get(i);
            if (object == null || !citation.equals((bl = object instanceof Identifier) ? ((Identifier)object).getAuthority() : this.getAuthority())) continue;
            if (n2 < n) {
                int n4 = n2;
                CharSequence charSequence = charSequenceArray[n2++];
                ArgumentChecks.ensureNonNullElement("replacements", n4, charSequence);
                String string = charSequence.toString();
                if (string.equals(bl ? ((Identifier)object).getCode() : object.toString())) continue;
                if (i < 0) {
                    this.properties.put("name", citation != this.getAuthority() ? new NamedIdentifier(citation, charSequence) : string);
                } else {
                    this.aliases.set(i, this.createName(citation, charSequence));
                }
                n3 = i + 1;
                continue;
            }
            if (i < 0) {
                this.properties.remove("name");
                continue;
            }
            this.aliases.remove(i--);
        }
        while (n2 < n) {
            int n5 = n2;
            CharSequence charSequence = charSequenceArray[n2++];
            ArgumentChecks.ensureNonNullElement("replacements", n5, charSequence);
            this.aliases.add(n3++, this.createName(citation, charSequence));
        }
        if (this.properties.get("name") == null && !this.aliases.isEmpty()) {
            this.properties.put("name", Builder.toIdentifier(this.aliases.remove(0)));
        }
        return this.self();
    }

    public B reidentify(Citation citation, String ... stringArray) {
        ArgumentChecks.ensureNonNull("authority", citation);
        int n = stringArray != null ? stringArray.length : 0;
        int n2 = 0;
        int n3 = this.identifiers.size();
        for (int i = 0; i < this.identifiers.size(); ++i) {
            Identifier identifier = (Identifier)this.identifiers.get(i);
            if (!citation.equals(identifier.getAuthority())) continue;
            if (n2 < n) {
                int n4 = n2;
                String string = stringArray[n2++];
                ArgumentChecks.ensureNonNullElement("replacements", n4, string);
                if (string.equals(identifier.getCode())) continue;
                this.identifiers.set(i, this.createIdentifier(citation, string));
                n3 = i + 1;
                continue;
            }
            this.identifiers.remove(i--);
        }
        while (n2 < n) {
            int n5 = n2;
            String string = stringArray[n2++];
            ArgumentChecks.ensureNonNullElement("replacements", n5, string);
            this.identifiers.add(n3++, this.createIdentifier(citation, string));
        }
        return this.self();
    }

    private InternationalString getDescription() {
        return (InternationalString)this.properties.get("description");
    }

    public B setDescription(CharSequence charSequence) {
        this.properties.put("description", Types.toInternationalString(charSequence));
        return this.self();
    }

    private InternationalString getRemarks() {
        return (InternationalString)this.properties.get("remarks");
    }

    public B setRemarks(CharSequence charSequence) {
        this.properties.put("remarks", Types.toInternationalString(charSequence));
        return this.self();
    }

    private boolean isDeprecated() {
        return Boolean.TRUE.equals(this.properties.get("deprecated"));
    }

    public B setDeprecated(boolean bl) {
        this.properties.put("deprecated", bl);
        return this.self();
    }

    protected void onCreate(boolean bl) {
        Identifier[] identifierArray;
        GenericName[] genericNameArray;
        if (bl) {
            this.properties.put("name", null);
            this.properties.remove("remarks");
            this.properties.remove("description");
            this.properties.remove("deprecated");
            this.aliases.clear();
            this.identifiers.clear();
            genericNameArray = null;
            identifierArray = null;
        } else {
            genericNameArray = this.aliases.toArray(new GenericName[this.aliases.size()]);
            identifierArray = (Identifier[])this.identifiers.toArray(new ReferenceIdentifier[this.identifiers.size()]);
        }
        this.properties.put("alias", genericNameArray);
        this.properties.put("identifiers", identifierArray);
    }
}

