/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.fit.util;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.uima.cas.ArrayFS;
import org.apache.uima.cas.BooleanArrayFS;
import org.apache.uima.cas.ByteArrayFS;
import org.apache.uima.cas.CommonArrayFS;
import org.apache.uima.cas.DoubleArrayFS;
import org.apache.uima.cas.Feature;
import org.apache.uima.cas.FeatureStructure;
import org.apache.uima.cas.FloatArrayFS;
import org.apache.uima.cas.IntArrayFS;
import org.apache.uima.cas.LongArrayFS;
import org.apache.uima.cas.ShortArrayFS;
import org.apache.uima.cas.StringArrayFS;
import org.apache.uima.cas.Type;
import org.apache.uima.cas.TypeSystem;
import org.apache.uima.fit.util.CasUtil;
import org.apache.uima.fit.util.FSCollectionFactory;

public class FSUtil {
    private static Feature getMandatoryFeature(FeatureStructure aFS, String aFeature) {
        Feature feat = aFS.getType().getFeatureByBaseName(aFeature);
        if (feat == null) {
            throw new IllegalArgumentException("Type [" + aFS.getType() + "] has no feature with name [" + aFeature + "]");
        }
        return feat;
    }

    private static void requireSingleValue(Feature aFeature, Object aArray) {
        if (aArray == null) {
            throw new IllegalArgumentException("Cannot set [" + aFeature.getName() + "] to a null value.");
        }
        if (Array.getLength(aArray) != 1) {
            throw new IllegalArgumentException("Feature [" + aFeature.getName() + "] requires a single value but got " + Arrays.asList(aArray));
        }
    }

    private static boolean isListType(TypeSystem aTS, Type aType) {
        return aTS.subsumes(aTS.getType("uima.cas.ListBase"), aType);
    }

    public static boolean hasFeature(FeatureStructure aFS, String aFeature) {
        return aFS.getType().getFeatureByBaseName(aFeature) != null;
    }

    public static boolean isMultiValuedFeature(FeatureStructure aFS, String aFeature) {
        Feature feat = aFS.getType().getFeatureByBaseName(aFeature);
        return FSUtil.isMultiValuedFeature(aFS, feat);
    }

    public static boolean isMultiValuedFeature(FeatureStructure aFS, Feature feat) {
        if (feat == null) {
            return false;
        }
        return feat.getRange().isArray() || FSUtil.isListType(aFS.getCAS().getTypeSystem(), feat.getRange());
    }

    public static void setFeature(FeatureStructure aFS, String aFeature, boolean ... aValue) {
        Feature feat = FSUtil.getMandatoryFeature(aFS, aFeature);
        if (feat.getRange().isPrimitive()) {
            FSUtil.requireSingleValue(feat, aValue);
            aFS.setBooleanValue(feat, aValue[0]);
        } else if (aValue == null) {
            aFS.setFeatureValue(feat, null);
        } else {
            aFS.setFeatureValue(feat, (FeatureStructure)FSCollectionFactory.createBooleanArray(aFS.getCAS(), aValue));
        }
    }

    public static void setFeature(FeatureStructure aFS, String aFeature, byte ... aValue) {
        Feature feat = FSUtil.getMandatoryFeature(aFS, aFeature);
        if (feat.getRange().isPrimitive()) {
            FSUtil.requireSingleValue(feat, aValue);
            aFS.setByteValue(feat, aValue[0]);
        } else if (aValue == null) {
            aFS.setFeatureValue(feat, null);
        } else {
            aFS.setFeatureValue(feat, (FeatureStructure)FSCollectionFactory.createByteArray(aFS.getCAS(), aValue));
        }
    }

    public static void setFeature(FeatureStructure aFS, String aFeature, double ... aValue) {
        Feature feat = FSUtil.getMandatoryFeature(aFS, aFeature);
        if (feat.getRange().isPrimitive()) {
            FSUtil.requireSingleValue(feat, aValue);
            aFS.setDoubleValue(feat, aValue[0]);
        } else if (aValue == null) {
            aFS.setFeatureValue(feat, null);
        } else {
            aFS.setFeatureValue(feat, (FeatureStructure)FSCollectionFactory.createDoubleArray(aFS.getCAS(), aValue));
        }
    }

    public static void setFeature(FeatureStructure aFS, String aFeature, float ... aValue) {
        Feature feat = FSUtil.getMandatoryFeature(aFS, aFeature);
        if (feat.getRange().isPrimitive()) {
            FSUtil.requireSingleValue(feat, aValue);
            aFS.setFloatValue(feat, aValue[0]);
        } else if (aValue == null) {
            aFS.setFeatureValue(feat, null);
        } else if (feat.getRange().isArray()) {
            aFS.setFeatureValue(feat, (FeatureStructure)FSCollectionFactory.createFloatArray(aFS.getCAS(), aValue));
        } else {
            aFS.setFeatureValue(feat, FSCollectionFactory.createFloatList(aFS.getCAS(), aValue));
        }
    }

    public static void setFeature(FeatureStructure aFS, String aFeature, int ... aValue) {
        Feature feat = FSUtil.getMandatoryFeature(aFS, aFeature);
        if (feat.getRange().isPrimitive()) {
            FSUtil.requireSingleValue(feat, aValue);
            aFS.setIntValue(feat, aValue[0]);
        } else if (aValue == null) {
            aFS.setFeatureValue(feat, null);
        } else if (feat.getRange().isArray()) {
            aFS.setFeatureValue(feat, (FeatureStructure)FSCollectionFactory.createIntArray(aFS.getCAS(), aValue));
        } else {
            aFS.setFeatureValue(feat, FSCollectionFactory.createIntegerList(aFS.getCAS(), aValue));
        }
    }

    public static void setFeature(FeatureStructure aFS, String aFeature, long ... aValue) {
        Feature feat = FSUtil.getMandatoryFeature(aFS, aFeature);
        if (feat.getRange().isPrimitive()) {
            FSUtil.requireSingleValue(feat, aValue);
            aFS.setLongValue(feat, aValue[0]);
        } else if (aValue == null) {
            aFS.setFeatureValue(feat, null);
        } else {
            aFS.setFeatureValue(feat, (FeatureStructure)FSCollectionFactory.createLongArray(aFS.getCAS(), aValue));
        }
    }

    public static void setFeature(FeatureStructure aFS, String aFeature, short ... aValue) {
        Feature feat = FSUtil.getMandatoryFeature(aFS, aFeature);
        if (feat.getRange().isPrimitive()) {
            FSUtil.requireSingleValue(feat, aValue);
            aFS.setShortValue(feat, aValue[0]);
        } else if (aValue == null) {
            aFS.setFeatureValue(feat, null);
        } else {
            aFS.setFeatureValue(feat, (FeatureStructure)FSCollectionFactory.createShortArray(aFS.getCAS(), aValue));
        }
    }

    public static void setFeature(FeatureStructure aFS, String aFeature, String ... aValue) {
        Feature feat = FSUtil.getMandatoryFeature(aFS, aFeature);
        if (feat.getRange().isPrimitive()) {
            FSUtil.requireSingleValue(feat, aValue);
            aFS.setStringValue(feat, aValue[0]);
        } else if (aValue == null) {
            aFS.setFeatureValue(feat, null);
        } else if (feat.getRange().isArray()) {
            aFS.setFeatureValue(feat, (FeatureStructure)FSCollectionFactory.createStringArray(aFS.getCAS(), aValue));
        } else {
            aFS.setFeatureValue(feat, FSCollectionFactory.createStringList(aFS.getCAS(), aValue));
        }
    }

    public static void setFeature(FeatureStructure aFS, String aFeature, FeatureStructure ... aValue) {
        Feature feat = FSUtil.getMandatoryFeature(aFS, aFeature);
        if (feat.getRange().isArray()) {
            aFS.setFeatureValue(feat, (FeatureStructure)FSCollectionFactory.createArrayFS(aFS.getCAS(), aValue));
        } else if (aValue == null) {
            aFS.setFeatureValue(feat, null);
        } else if (FSUtil.isListType(aFS.getCAS().getTypeSystem(), feat.getRange())) {
            aFS.setFeatureValue(feat, FSCollectionFactory.createFSList(aFS.getCAS(), aValue));
        } else {
            FSUtil.requireSingleValue(feat, aValue);
            aFS.setFeatureValue(feat, aValue[0]);
        }
    }

    public static void setFeature(FeatureStructure aFS, String aFeature, Collection aValue) {
        Feature feat = FSUtil.getMandatoryFeature(aFS, aFeature);
        if (aValue == null) {
            aFS.setFeatureValue(feat, null);
        } else if (feat.getRange().isArray()) {
            switch (feat.getRange().getName()) {
                case "uima.cas.BooleanArray": {
                    aFS.setFeatureValue(feat, (FeatureStructure)FSCollectionFactory.createBooleanArray(aFS.getCAS(), (Collection<Boolean>)aValue));
                    break;
                }
                case "uima.cas.ByteArray": {
                    aFS.setFeatureValue(feat, (FeatureStructure)FSCollectionFactory.createByteArray(aFS.getCAS(), (Collection<Byte>)aValue));
                    break;
                }
                case "uima.cas.DoubleArray": {
                    aFS.setFeatureValue(feat, (FeatureStructure)FSCollectionFactory.createDoubleArray(aFS.getCAS(), (Collection<Double>)aValue));
                    break;
                }
                case "uima.cas.FloatArray": {
                    aFS.setFeatureValue(feat, (FeatureStructure)FSCollectionFactory.createFloatArray(aFS.getCAS(), (Collection<Float>)aValue));
                    break;
                }
                case "uima.cas.IntegerArray": {
                    aFS.setFeatureValue(feat, (FeatureStructure)FSCollectionFactory.createIntArray(aFS.getCAS(), (Collection<Integer>)aValue));
                    break;
                }
                case "uima.cas.LongArray": {
                    aFS.setFeatureValue(feat, (FeatureStructure)FSCollectionFactory.createLongArray(aFS.getCAS(), (Collection<Long>)aValue));
                    break;
                }
                case "uima.cas.ShortArray": {
                    aFS.setFeatureValue(feat, (FeatureStructure)FSCollectionFactory.createShortArray(aFS.getCAS(), (Collection<Short>)aValue));
                    break;
                }
                case "uima.cas.StringArray": {
                    aFS.setFeatureValue(feat, (FeatureStructure)FSCollectionFactory.createStringArray(aFS.getCAS(), (Collection<String>)aValue));
                    break;
                }
                default: {
                    aFS.setFeatureValue(feat, (FeatureStructure)FSCollectionFactory.createArrayFS(aFS.getCAS(), aValue));
                    break;
                }
            }
        } else {
            switch (feat.getRange().getName()) {
                case "uima.cas.FloatList": {
                    aFS.setFeatureValue(feat, FSCollectionFactory.createFloatList(aFS.getCAS(), (Collection<Float>)aValue));
                    break;
                }
                case "uima.cas.IntegerList": {
                    aFS.setFeatureValue(feat, FSCollectionFactory.createIntegerList(aFS.getCAS(), (Collection<Integer>)aValue));
                    break;
                }
                case "uima.cas.StringList": {
                    aFS.setFeatureValue(feat, FSCollectionFactory.createStringList(aFS.getCAS(), (Collection<String>)aValue));
                    break;
                }
                default: {
                    aFS.setFeatureValue(feat, FSCollectionFactory.createFSList(aFS.getCAS(), aValue));
                }
            }
        }
    }

    public static <T> T getFeature(FeatureStructure aFS, String aFeature, Class<T> aClazz) {
        Feature feat = FSUtil.getMandatoryFeature(aFS, aFeature);
        return FSUtil.getFeature(aFS, feat, aClazz);
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static <T> T getFeature(FeatureStructure aFS, Feature aFeature, Class<T> aClazz) {
        void var5_16;
        Object target;
        int length;
        if (aFeature.getRange().isPrimitive()) {
            switch (aFeature.getRange().getName()) {
                case "uima.cas.Boolean": {
                    return aClazz.cast(aFS.getBooleanValue(aFeature));
                }
                case "uima.cas.Byte": {
                    return aClazz.cast(aFS.getByteValue(aFeature));
                }
                case "uima.cas.Double": {
                    return aClazz.cast(aFS.getDoubleValue(aFeature));
                }
                case "uima.cas.Float": {
                    return aClazz.cast(Float.valueOf(aFS.getFloatValue(aFeature)));
                }
                case "uima.cas.Integer": {
                    return aClazz.cast(aFS.getIntValue(aFeature));
                }
                case "uima.cas.Long": {
                    return aClazz.cast(aFS.getLongValue(aFeature));
                }
                case "uima.cas.Short": {
                    return aClazz.cast(aFS.getShortValue(aFeature));
                }
                case "uima.cas.String": {
                    return aClazz.cast(aFS.getStringValue(aFeature));
                }
            }
            throw new IllegalArgumentException("Unable to coerce value of feature [" + aFeature.getName() + "] with type [" + aFeature.getRange().getName() + "] into [" + aClazz.getName() + "]");
        }
        if (aFS.getFeatureValue(aFeature) == null) {
            return null;
        }
        if (aFeature.getRange().isArray()) {
            CommonArrayFS commonArrayFS = (CommonArrayFS)aFS.getFeatureValue(aFeature);
            length = commonArrayFS.size();
            switch (aFeature.getRange().getComponentType().getName()) {
                case "uima.cas.Boolean": {
                    target = new boolean[length];
                    ((BooleanArrayFS)commonArrayFS).copyToArray(0, (boolean[])target, 0, length);
                    break;
                }
                case "uima.cas.Byte": {
                    target = new byte[length];
                    ((ByteArrayFS)commonArrayFS).copyToArray(0, (byte[])target, 0, length);
                    break;
                }
                case "uima.cas.Double": {
                    target = new double[length];
                    ((DoubleArrayFS)commonArrayFS).copyToArray(0, (double[])target, 0, length);
                    break;
                }
                case "uima.cas.Float": {
                    target = new float[length];
                    ((FloatArrayFS)commonArrayFS).copyToArray(0, (float[])target, 0, length);
                    break;
                }
                case "uima.cas.Integer": {
                    target = new int[length];
                    ((IntArrayFS)commonArrayFS).copyToArray(0, (int[])target, 0, length);
                    break;
                }
                case "uima.cas.Long": {
                    target = new long[length];
                    ((LongArrayFS)commonArrayFS).copyToArray(0, (long[])target, 0, length);
                    break;
                }
                case "uima.cas.Short": {
                    target = new short[length];
                    ((ShortArrayFS)commonArrayFS).copyToArray(0, (short[])target, 0, length);
                    break;
                }
                case "uima.cas.String": {
                    target = new String[length];
                    ((StringArrayFS)commonArrayFS).copyToArray(0, (String[])target, 0, length);
                    break;
                }
                default: {
                    target = aClazz.isArray() ? (Object)Array.newInstance(aClazz.getComponentType(), length) : (Object)new FeatureStructure[length];
                    ((ArrayFS)commonArrayFS).copyToArray(0, (FeatureStructure[])target, 0, length);
                    break;
                }
            }
        } else if (FSUtil.isListType(aFS.getCAS().getTypeSystem(), aFeature.getRange())) {
            void var5_9;
            length = 0;
            FeatureStructure featureStructure = aFS.getFeatureValue(aFeature);
            while (var5_9.getType().getFeatureByBaseName("head") != null) {
                ++length;
                FeatureStructure featureStructure2 = var5_9.getFeatureValue(var5_9.getType().getFeatureByBaseName("tail"));
            }
            switch (aFeature.getRange().getName()) {
                case "uima.cas.FloatList": {
                    float[] floatTarget = new float[length];
                    int i = 0;
                    FeatureStructure cur = aFS.getFeatureValue(aFeature);
                    while (cur.getType().getFeatureByBaseName("head") != null) {
                        floatTarget[i] = cur.getFloatValue(cur.getType().getFeatureByBaseName("head"));
                        cur = cur.getFeatureValue(cur.getType().getFeatureByBaseName("tail"));
                    }
                    target = floatTarget;
                    break;
                }
                case "uima.cas.IntegerList": {
                    int[] intTarget = new int[length];
                    int i = 0;
                    FeatureStructure cur = aFS.getFeatureValue(aFeature);
                    while (cur.getType().getFeatureByBaseName("head") != null) {
                        intTarget[i] = cur.getIntValue(cur.getType().getFeatureByBaseName("head"));
                        cur = cur.getFeatureValue(cur.getType().getFeatureByBaseName("tail"));
                    }
                    target = intTarget;
                    break;
                }
                case "uima.cas.StringList": {
                    String[] stringTarget = new String[length];
                    int i = 0;
                    FeatureStructure cur = aFS.getFeatureValue(aFeature);
                    while (cur.getType().getFeatureByBaseName("head") != null) {
                        stringTarget[i] = cur.getStringValue(cur.getType().getFeatureByBaseName("head"));
                        cur = cur.getFeatureValue(cur.getType().getFeatureByBaseName("tail"));
                    }
                    target = stringTarget;
                    break;
                }
                default: {
                    target = aClazz.isArray() ? (Object)Array.newInstance(aClazz.getComponentType(), length) : (Object)new FeatureStructure[length];
                    int i = 0;
                    FeatureStructure cur = aFS.getFeatureValue(aFeature);
                    while (cur.getType().getFeatureByBaseName("head") != null) {
                        Array.set(target, i, cur.getFeatureValue(cur.getType().getFeatureByBaseName("head")));
                        ++i;
                        cur = cur.getFeatureValue(cur.getType().getFeatureByBaseName("tail"));
                    }
                    break block46;
                }
            }
        } else {
            if (!aFS.getCAS().getTypeSystem().subsumes(CasUtil.getType(aFS.getCAS(), aClazz), aFeature.getRange())) throw new IllegalArgumentException("Unable to coerce value of feature [" + aFeature.getName() + "] with type [" + aFeature.getRange().getName() + "] into [" + aClazz.getName() + "]");
            return (T)aFS.getFeatureValue(aFeature);
        }
        if (aClazz.isArray()) {
            return aClazz.cast(target);
        }
        if (!Collection.class.isAssignableFrom(aClazz)) throw new IllegalArgumentException("Unable to coerce value of feature [" + aFeature.getName() + "] with type [" + aFeature.getRange().getName() + "] into [" + aClazz.getName() + "]");
        if (aClazz.isInterface()) {
            if (List.class.isAssignableFrom(aClazz)) {
                ArrayList arrayList = new ArrayList(length);
            } else {
                if (!Set.class.isAssignableFrom(aClazz)) throw new IllegalArgumentException("Unable to coerce value of feature [" + aFeature.getName() + "] with type [" + aFeature.getRange().getName() + "] into [" + aClazz.getName() + "]");
                HashSet hashSet = new HashSet(length);
            }
        } else {
            try {
                Collection collection = (Collection)aClazz.newInstance();
            }
            catch (IllegalAccessException | InstantiationException e) {
                throw new IllegalArgumentException("Unable to coerce value of feature [" + aFeature.getName() + "] with type [" + aFeature.getRange().getName() + "] into [" + aClazz.getName() + "]", e);
            }
        }
        for (int i = 0; i < length; ++i) {
            var5_16.add(Array.get(target, i));
        }
        return aClazz.cast(var5_16);
    }
}

