/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.client.solrj.io.stream;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.solr.client.solrj.io.Tuple;
import org.apache.solr.client.solrj.io.comp.SingleValueComparator;
import org.apache.solr.client.solrj.io.comp.StreamComparator;
import org.apache.solr.client.solrj.io.eval.StreamEvaluator;
import org.apache.solr.client.solrj.io.stream.StreamContext;
import org.apache.solr.client.solrj.io.stream.TupleStream;
import org.apache.solr.client.solrj.io.stream.expr.Explanation;
import org.apache.solr.client.solrj.io.stream.expr.Expressible;
import org.apache.solr.client.solrj.io.stream.expr.StreamExplanation;
import org.apache.solr.client.solrj.io.stream.expr.StreamExpression;
import org.apache.solr.client.solrj.io.stream.expr.StreamExpressionNamedParameter;
import org.apache.solr.client.solrj.io.stream.expr.StreamExpressionParameter;
import org.apache.solr.client.solrj.io.stream.expr.StreamExpressionValue;
import org.apache.solr.client.solrj.io.stream.expr.StreamFactory;

public class PlotStream
extends TupleStream
implements Expressible {
    private static final long serialVersionUID = 1L;
    private StreamContext streamContext;
    private Map<String, String> stringParams = new HashMap<String, String>();
    private Map<String, StreamEvaluator> evaluatorParams = new HashMap<String, StreamEvaluator>();
    private Map<String, TupleStream> streamParams = new HashMap<String, TupleStream>();
    private List<String> fieldNames = new ArrayList<String>();
    private Map<String, String> fieldLabels = new HashMap<String, String>();
    private boolean finished;

    public PlotStream(StreamExpression expression, StreamFactory factory) throws IOException {
        this.fieldNames.add("plot");
        this.fieldNames.add("data");
        this.fieldLabels.put("plot", "plot");
        this.fieldLabels.put("data", "data");
        List<StreamExpressionNamedParameter> namedParams = factory.getNamedOperands(expression);
        for (StreamExpressionNamedParameter np : namedParams) {
            String name = np.getName();
            StreamExpressionParameter param = np.getParameter();
            if (param instanceof StreamExpressionValue) {
                this.stringParams.put(name, ((StreamExpressionValue)param).getValue());
                continue;
            }
            if (factory.isEvaluator((StreamExpression)param)) {
                StreamEvaluator evaluator = factory.constructEvaluator((StreamExpression)param);
                this.evaluatorParams.put(name, evaluator);
                continue;
            }
            if (factory.isStream((StreamExpression)param)) {
                TupleStream tupleStream = factory.constructStream((StreamExpression)param);
                this.streamParams.put(name, tupleStream);
                continue;
            }
            throw new IOException(String.format(Locale.ROOT, "Invalid expression %s - only string, evaluator, or stream named parameters are supported, but param %s is none of those", expression, name));
        }
    }

    @Override
    public StreamExpression toExpression(StreamFactory factory) throws IOException {
        return this.toExpression(factory, true);
    }

    private StreamExpression toExpression(StreamFactory factory, boolean includeStreams) throws IOException {
        StreamExpression expression = new StreamExpression(factory.getFunctionName(this.getClass()));
        for (Map.Entry<String, String> entry : this.stringParams.entrySet()) {
            expression.addParameter(new StreamExpressionNamedParameter(entry.getKey(), entry.getValue()));
        }
        for (Map.Entry<String, Object> entry : this.evaluatorParams.entrySet()) {
            expression.addParameter(new StreamExpressionNamedParameter(entry.getKey(), ((StreamEvaluator)entry.getValue()).toExpression(factory)));
        }
        for (Map.Entry<String, Object> entry : this.streamParams.entrySet()) {
            if (includeStreams) {
                expression.addParameter(new StreamExpressionNamedParameter(entry.getKey(), ((Expressible)entry.getValue()).toExpression(factory)));
                continue;
            }
            expression.addParameter(new StreamExpressionNamedParameter(entry.getKey(), "<stream>"));
        }
        return expression;
    }

    @Override
    public Explanation toExplanation(StreamFactory factory) throws IOException {
        StreamExplanation explanation = new StreamExplanation(this.getStreamNodeId().toString());
        explanation.setFunctionName(factory.getFunctionName(this.getClass()));
        explanation.setImplementingClass(this.getClass().getName());
        explanation.setExpressionType("stream-decorator");
        explanation.setExpression(this.toExpression(factory, false).toString());
        return explanation;
    }

    @Override
    public void setStreamContext(StreamContext context) {
        this.streamContext = context;
        for (StreamEvaluator evaluator : this.evaluatorParams.values()) {
            evaluator.setStreamContext(context);
        }
        for (TupleStream stream : this.streamParams.values()) {
            stream.setStreamContext(context);
        }
    }

    @Override
    public List<TupleStream> children() {
        ArrayList<TupleStream> l = new ArrayList<TupleStream>();
        return l;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Tuple read() throws IOException {
        void var3_8;
        if (this.finished) {
            return Tuple.EOF();
        }
        this.finished = true;
        HashMap<String, Object> values = new HashMap<String, Object>();
        for (Map.Entry<String, String> entry : this.stringParams.entrySet()) {
            if (this.streamContext.getLets().containsKey(entry.getValue())) {
                values.put(entry.getKey(), this.streamContext.getLets().get(entry.getValue()));
                continue;
            }
            values.put(entry.getKey(), entry.getValue());
        }
        for (Map.Entry<String, Object> entry : this.evaluatorParams.entrySet()) {
            values.put(entry.getKey(), ((StreamEvaluator)entry.getValue()).evaluateOverContext());
        }
        List y = (List)values.get("y");
        List list = (List)values.get("x");
        if (list == null) {
            ArrayList<Integer> arrayList = new ArrayList<Integer>();
            for (int i = 0; i < y.size(); ++i) {
                arrayList.add(i + 1);
            }
        }
        ArrayList xy = new ArrayList();
        for (int i = 0; i < var3_8.size(); ++i) {
            ArrayList<Number> pair = new ArrayList<Number>();
            pair.add((Number)var3_8.get(i));
            pair.add((Number)y.get(i));
            xy.add(pair);
        }
        values.put("plot", values.get("type"));
        values.put("data", xy);
        Tuple tup = new Tuple(values);
        tup.setFieldLabels(this.fieldLabels);
        tup.setFieldNames(this.fieldNames);
        return tup;
    }

    @Override
    public void close() throws IOException {
    }

    @Override
    public void open() throws IOException {
    }

    @Override
    public StreamComparator getStreamSort() {
        return new SingleValueComparator();
    }

    @Override
    public int getCost() {
        return 0;
    }
}

