/*
 * Decompiled with CFR 0.152.
 */
package com.github.maoo.indexer.client;

import com.github.maoo.indexer.client.AlfrescoClient;
import com.github.maoo.indexer.client.AlfrescoDownException;
import com.github.maoo.indexer.client.AlfrescoFilters;
import com.github.maoo.indexer.client.AlfrescoParseException;
import com.github.maoo.indexer.client.AlfrescoResponse;
import com.github.maoo.indexer.client.AlfrescoUser;
import com.google.common.base.Strings;
import com.google.common.io.CharStreams;
import com.google.common.net.MediaType;
import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.codec.binary.Base64;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebScriptsAlfrescoClient
implements AlfrescoClient {
    private static final String FIELD_PROPERTIES = "properties";
    private static final String LAST_TXN_ID = "last_txn_id";
    private static final String DOCS = "docs";
    private static final String LAST_ACL_CS_ID = "last_acl_changeset_id";
    private static final String URL_PARAM_LAST_TXN_ID = "lastTxnId";
    private static final String URL_PARAM_LAST_ACL_CS_ID = "lastAclChangesetId";
    private static final String URL_PARAM_INDEXING_FILTERS = "indexingFilters";
    private static final String STORE_ID = "store_id";
    private static final String STORE_PROTOCOL = "store_protocol";
    private static final String USERNAME = "username";
    private static final String AUTHORITIES = "authorities";
    private final Gson gson = new Gson();
    private final String changesUrl;
    private final String actionsUrl;
    private final String metadataUrl;
    private final String authoritiesUrl;
    private final String username;
    private final String password;
    private final Logger logger = LoggerFactory.getLogger(WebScriptsAlfrescoClient.class);

    public WebScriptsAlfrescoClient(String protocol, String hostname, String endpoint, String storeProtocol, String storeId) {
        this(protocol, hostname, endpoint, storeProtocol, storeId, null, null);
    }

    public WebScriptsAlfrescoClient(String protocol, String hostname, String endpoint, String storeProtocol, String storeId, String username, String password) {
        this.changesUrl = String.format("%s://%s%s/node/changes/%s/%s", protocol, hostname, endpoint, storeProtocol, storeId);
        this.actionsUrl = String.format("%s://%s%s/node/actions/%s/%s", protocol, hostname, endpoint, storeProtocol, storeId);
        this.metadataUrl = String.format("%s://%s%s/node/details/%s/%s", protocol, hostname, endpoint, storeProtocol, storeId);
        this.authoritiesUrl = String.format("%s://%s%s/auth/resolve/", protocol, hostname, endpoint);
        this.username = username;
        this.password = password;
    }

    @Override
    public AlfrescoResponse fetchNodes(long lastTransactionId, long lastAclChangesetId, AlfrescoFilters filters) {
        String urlWithParameter = String.format("%s?%s", this.changesUrl, this.urlParameters(lastTransactionId, lastAclChangesetId, filters));
        return this.getDocumentsActions(urlWithParameter);
    }

    @Override
    public AlfrescoResponse fetchNode(String nodeUuid) throws AlfrescoDownException {
        String urlWithParameter = String.format("%s/%s", this.actionsUrl, nodeUuid);
        return this.getDocumentsActions(urlWithParameter);
    }

    private AlfrescoResponse getDocumentsActions(String url) {
        CloseableHttpClient httpClient = HttpClients.createDefault();
        this.logger.debug("Hitting url: {}", (Object)url);
        try {
            HttpGet httpGet = this.createGetRequest(url);
            CloseableHttpResponse response = httpClient.execute((HttpUriRequest)httpGet);
            HttpEntity entity = response.getEntity();
            AlfrescoResponse afResponse = this.fromHttpEntity(entity);
            EntityUtils.consume((HttpEntity)entity);
            response.close();
            httpClient.close();
            return afResponse;
        }
        catch (IOException e) {
            this.logger.warn("Failed to fetch nodes.", (Throwable)e);
            throw new AlfrescoDownException("Alfresco appears to be down", e);
        }
    }

    private HttpGet createGetRequest(String url) {
        HttpGet httpGet = new HttpGet(url);
        httpGet.addHeader("Accept", "application/json");
        if (this.useBasicAuthentication()) {
            httpGet.addHeader("Authorization", "Basic " + Base64.encodeBase64String((byte[])String.format("%s:%s", this.username, this.password).getBytes(Charset.forName("UTF-8"))));
        }
        return httpGet;
    }

    private boolean useBasicAuthentication() {
        return this.username != null && !"".equals(this.username) && this.password != null;
    }

    private String urlParameters(long lastTransactionId, long lastAclChangesetId, AlfrescoFilters filters) {
        String urlParameters = null;
        if (filters != null && !filters.isEmpty()) {
            String indexingFilters = null;
            try {
                indexingFilters = URLEncoder.encode(filters.toJSONString(), "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                indexingFilters = filters.toJSONString();
            }
            urlParameters = String.format("%s=%d&%s=%d&%s=%s", URL_PARAM_LAST_TXN_ID, lastTransactionId, URL_PARAM_LAST_ACL_CS_ID, lastAclChangesetId, URL_PARAM_INDEXING_FILTERS, indexingFilters);
        } else {
            urlParameters = String.format("%s=%d&%s=%d", URL_PARAM_LAST_TXN_ID, lastTransactionId, URL_PARAM_LAST_ACL_CS_ID, lastAclChangesetId);
        }
        return urlParameters;
    }

    private AlfrescoResponse fromHttpEntity(HttpEntity entity) throws IOException {
        InputStreamReader entityReader = new InputStreamReader(entity.getContent());
        JsonObject responseObject = (JsonObject)this.gson.fromJson((Reader)entityReader, JsonObject.class);
        ArrayList<Map<String, Object>> documents = new ArrayList<Map<String, Object>>();
        long lastTransactionId = this.getStringAsLong(responseObject, LAST_TXN_ID, 0L);
        long lastAclChangesetId = this.getStringAsLong(responseObject, LAST_ACL_CS_ID, 0L);
        String storeId = this.getString(responseObject, STORE_ID);
        String storeProtocol = this.getString(responseObject, STORE_PROTOCOL);
        if (responseObject.has(DOCS) && responseObject.get(DOCS).isJsonArray()) {
            JsonArray docsArray = responseObject.get(DOCS).getAsJsonArray();
            for (JsonElement documentElement : docsArray) {
                Map<String, Object> document = this.createDocument(documentElement);
                document.put(STORE_ID, storeId);
                document.put(STORE_PROTOCOL, storeProtocol);
                documents.add(document);
            }
        } else {
            this.logger.warn("No documents found in response!");
        }
        return new AlfrescoResponse(lastTransactionId, lastAclChangesetId, storeId, storeProtocol, documents);
    }

    private long getStringAsLong(JsonObject responseObject, String key, long defaultValue) {
        String string = this.getString(responseObject, key);
        if (Strings.isNullOrEmpty((String)string)) {
            return defaultValue;
        }
        return Long.parseLong(string);
    }

    private String getString(JsonObject responseObject, String key) {
        if (responseObject.has(key)) {
            JsonElement element = responseObject.get(key);
            if (element.isJsonPrimitive() && element.getAsJsonPrimitive().isString()) {
                return element.getAsString();
            }
            this.logger.warn("The {} property (={}) is not a string in document: {}", new Object[]{key, element, responseObject});
        } else {
            this.logger.warn("The key {} is missing from document: {}", (Object)key, (Object)responseObject);
        }
        return "";
    }

    private Map<String, Object> createDocument(JsonElement documentElement) {
        if (documentElement.isJsonObject()) {
            JsonObject documentObject = documentElement.getAsJsonObject();
            return (Map)this.gson.fromJson((JsonElement)documentObject, Map.class);
        }
        return new HashMap<String, Object>();
    }

    @Override
    public Map<String, Object> fetchMetadata(String nodeUuid) throws AlfrescoDownException {
        String json = this.fetchMetadataJson(nodeUuid);
        Map map = (Map)this.gson.fromJson(json, Map.class);
        List<Map<String, String>> properties = this.extractPropertiesFieldFromMap(nodeUuid, map);
        for (Map<String, String> e : properties) {
            map.put(e.get("name"), e.get("value"));
        }
        return map;
    }

    private String fetchMetadataJson(String nodeUuid) {
        String fullUrl = String.format("%s/%s", this.metadataUrl, nodeUuid);
        this.logger.debug("url: {}", (Object)fullUrl);
        try {
            CloseableHttpClient httpClient = HttpClients.createDefault();
            HttpGet httpGet = this.createGetRequest(fullUrl);
            CloseableHttpResponse response = httpClient.execute((HttpUriRequest)httpGet);
            HttpEntity entity = response.getEntity();
            String result = CharStreams.toString((Readable)new InputStreamReader(entity.getContent(), "UTF-8"));
            response.close();
            httpClient.close();
            return result;
        }
        catch (IOException e) {
            throw new AlfrescoDownException(e);
        }
    }

    private List<Map<String, String>> extractPropertiesFieldFromMap(String nodeUuid, Map<String, Object> map) {
        Object properties = map.remove(FIELD_PROPERTIES);
        if (properties == null) {
            throw new AlfrescoDownException("No Properties Fetched for the Node " + nodeUuid);
        }
        if (!(properties instanceof List)) {
            throw new AlfrescoDownException("properties is not of type List, it is of type " + properties.getClass());
        }
        return (List)properties;
    }

    private AlfrescoUser userFromHttpEntity(HttpEntity entity) throws IOException {
        InputStreamReader entityReader = new InputStreamReader(entity.getContent());
        JsonElement responseObject = (JsonElement)this.gson.fromJson((Reader)entityReader, JsonElement.class);
        if (responseObject instanceof JsonObject) {
            return this.getUser((JsonObject)responseObject);
        }
        if (responseObject instanceof JsonArray) {
            return this.getUser(((JsonArray)responseObject).get(0).getAsJsonObject());
        }
        return this.getUser(responseObject.getAsJsonObject());
    }

    private AlfrescoUser getUser(JsonObject responseObject) {
        String username = this.getUsername(responseObject);
        List<String> authorities = this.getAuthorities(responseObject);
        return new AlfrescoUser(username, authorities);
    }

    private String getUsername(JsonObject userObject) {
        if (!userObject.has(USERNAME)) {
            throw new AlfrescoParseException("Json response is missing username.");
        }
        JsonElement usernameElement = userObject.get(USERNAME);
        if (!usernameElement.isJsonPrimitive() || !usernameElement.getAsJsonPrimitive().isString()) {
            throw new AlfrescoParseException("Username must be a string. It was: " + usernameElement.toString());
        }
        return usernameElement.getAsString();
    }

    private List<String> getAuthorities(JsonObject userObject) {
        ArrayList<String> authorities = new ArrayList<String>();
        if (!userObject.has(AUTHORITIES)) {
            throw new AlfrescoParseException("Json response is authorities.");
        }
        JsonElement authoritiesElement = userObject.get(AUTHORITIES);
        if (!authoritiesElement.isJsonArray()) {
            throw new AlfrescoParseException("Authorities must be a json array. It was: " + authoritiesElement.toString());
        }
        JsonArray authoritiesArray = authoritiesElement.getAsJsonArray();
        for (JsonElement authorityElement : authoritiesArray) {
            if (!authorityElement.isJsonPrimitive()) {
                throw new AlfrescoParseException("Authority entry must be a string. It was: " + authoritiesElement.toString());
            }
            JsonPrimitive authorityPrimitive = authorityElement.getAsJsonPrimitive();
            if (!authorityPrimitive.isString()) {
                throw new AlfrescoParseException("Authority entry must be a string. It was: " + authoritiesElement.toString());
            }
            authorities.add(authorityPrimitive.getAsString());
        }
        return authorities;
    }

    @Override
    public AlfrescoUser fetchUserAuthorities(String username) throws AlfrescoDownException {
        CloseableHttpResponse response = null;
        CloseableHttpClient httpClient = HttpClients.createDefault();
        try {
            String url = String.format("%s%s", this.authoritiesUrl, username);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Hitting url: " + url);
            }
            HttpGet httpGet = this.createGetRequest(url);
            response = httpClient.execute((HttpUriRequest)httpGet);
            HttpEntity entity = response.getEntity();
            AlfrescoUser afResponse = this.userFromHttpEntity(entity);
            EntityUtils.consume((HttpEntity)entity);
            AlfrescoUser alfrescoUser = afResponse;
            return alfrescoUser;
        }
        catch (IOException e) {
            if (this.logger.isDebugEnabled()) {
                this.logger.warn("Failed to fetch nodes.", (Throwable)e);
            }
            throw new AlfrescoDownException("Alfresco appears to be down", e);
        }
        finally {
            try {
                if (response != null) {
                    response.close();
                }
                httpClient.close();
            }
            catch (IOException e) {}
        }
    }

    @Override
    public List<AlfrescoUser> fetchAllUsersAuthorities() throws AlfrescoDownException {
        try {
            CloseableHttpClient httpClient = HttpClients.createDefault();
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Hitting url: " + this.authoritiesUrl);
            }
            HttpGet httpGet = this.createGetRequest(this.authoritiesUrl);
            CloseableHttpResponse response = httpClient.execute((HttpUriRequest)httpGet);
            HttpEntity entity = response.getEntity();
            List<AlfrescoUser> users = this.usersFromHttpEntity(entity);
            EntityUtils.consume((HttpEntity)entity);
            return users;
        }
        catch (IOException e) {
            if (this.logger.isDebugEnabled()) {
                this.logger.warn("Failed to fetch nodes.", (Throwable)e);
            }
            throw new AlfrescoDownException("Alfresco appears to be down", e);
        }
    }

    private List<AlfrescoUser> usersFromHttpEntity(HttpEntity entity) throws IOException {
        InputStreamReader entityReader = new InputStreamReader(entity.getContent());
        JsonElement responseObject = (JsonElement)this.gson.fromJson((Reader)entityReader, JsonElement.class);
        if (!responseObject.isJsonArray()) {
            throw new AlfrescoParseException("Users must be a json array.");
        }
        ArrayList<AlfrescoUser> users = new ArrayList<AlfrescoUser>();
        JsonArray usersArray = responseObject.getAsJsonArray();
        for (JsonElement userElement : usersArray) {
            if (!userElement.isJsonObject()) {
                throw new AlfrescoParseException("User must be a json object.");
            }
            AlfrescoUser user = this.getUser(userElement.getAsJsonObject());
            users.add(user);
        }
        return users;
    }

    @Override
    public InputStream fetchContent(String contentUrlPath) {
        HttpGet httpGet = new HttpGet(contentUrlPath);
        httpGet.addHeader("Accept", MediaType.APPLICATION_BINARY.toString());
        if (this.useBasicAuthentication()) {
            httpGet.addHeader("Authorization", "Basic " + Base64.encodeBase64String((byte[])String.format("%s:%s", this.username, this.password).getBytes(Charset.forName("UTF-8"))));
        }
        CloseableHttpClient httpClient = HttpClients.createDefault();
        try {
            CloseableHttpResponse response = httpClient.execute((HttpUriRequest)httpGet);
            InputStream stream = response.getEntity().getContent();
            return stream;
        }
        catch (Exception e) {
            throw new AlfrescoDownException("Alfresco appears to be down", e);
        }
    }
}

