/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.api;

import java.util.Objects;
import java.util.function.Supplier;
import org.apache.maven.api.annotations.Experimental;
import org.apache.maven.api.annotations.Nonnull;
import org.apache.maven.api.annotations.Nullable;
import org.apache.maven.api.annotations.Provider;
import org.apache.maven.api.annotations.ThreadSafe;

@Experimental
@ThreadSafe
@Provider
public interface SessionData {
    public <T> void set(@Nonnull Key<T> var1, @Nullable T var2);

    public <T> boolean replace(@Nonnull Key<T> var1, @Nullable T var2, @Nullable T var3);

    @Nullable
    public <T> T get(@Nonnull Key<T> var1);

    @Nullable
    public <T> T computeIfAbsent(@Nonnull Key<T> var1, @Nonnull Supplier<T> var2);

    public static <T> Key<T> key(Class<T> clazz) {
        return new Key<T>(clazz, clazz);
    }

    public static <T> Key<T> key(Class<T> clazz, Object id) {
        return new Key<T>(clazz, id);
    }

    public static final class Key<T> {
        private final Class<T> type;
        private final Object id;

        private Key(Class<T> type, Object id) {
            this.type = type;
            this.id = id;
        }

        public Class<T> type() {
            return this.type;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Key key = (Key)o;
            return Objects.equals(this.id, key.id) && Objects.equals(this.type, key.type);
        }

        public int hashCode() {
            return Objects.hash(this.id, this.type);
        }
    }
}

