/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.cli.client.helper;

import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.StreamCorruptedException;
import java.util.Objects;
import org.apache.sshd.common.util.ValidateUtils;

public class SftpFileTransferProgressOutputStream
extends FilterOutputStream {
    public static final char DEFAULT_PROGRESS_CHAR = '#';
    public static final int DEFAULT_MARKS_PER_LINE = 72;
    public static final int DEFAULT_MARKER_SIZE = 8192;
    private final int markerSize;
    private final char markerChar;
    private final int markersPerLine;
    private final Appendable stdout;
    private final byte[] workBuf = new byte[]{0};
    private long byteCount;
    private long lastMarkOffset;
    private int curMarkersInLine;

    public SftpFileTransferProgressOutputStream(OutputStream out, Appendable stdout) {
        this(out, 8192, '#', 72, stdout);
    }

    public SftpFileTransferProgressOutputStream(OutputStream out, int markerSize, char markerChar, int markersPerLine, Appendable stdout) {
        super(Objects.requireNonNull(out, "No target stream"));
        ValidateUtils.checkTrue((markerSize > 0 ? 1 : 0) != 0, (String)"Invalid marker size: %d", (long)markerSize);
        this.markerSize = markerSize;
        if (markerChar <= ' ' || markerChar > '~') {
            throw new IllegalArgumentException("Non-printable marker character: 0x" + Integer.toHexString(markerChar));
        }
        this.markerChar = markerChar;
        ValidateUtils.checkTrue((markersPerLine > 0 ? 1 : 0) != 0, (String)"Invalid markers per line: %d", (long)markersPerLine);
        this.markersPerLine = markersPerLine;
        this.stdout = Objects.requireNonNull(stdout, "No progress report target");
    }

    public int getMarkerSize() {
        return this.markerSize;
    }

    public char getMarkerChar() {
        return this.markerChar;
    }

    public int getMarkersPerLine() {
        return this.markersPerLine;
    }

    public Appendable getStdout() {
        return this.stdout;
    }

    @Override
    public void write(int b) throws IOException {
        this.workBuf[0] = (byte)(b & 0xFF);
        this.write(this.workBuf, 0, 1);
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.write(b, 0, b.length);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        if (len < 0 || off < 0) {
            throw new StreamCorruptedException("Invalid offset (" + off + ")/length(" + len + ")");
        }
        this.out.write(b, off, len);
        this.byteCount += (long)len;
        long reportDiff = this.byteCount - this.lastMarkOffset;
        int reportSize = this.getMarkerSize();
        long markersCount = reportDiff / (long)reportSize;
        this.appendMarkers((int)markersCount);
        this.lastMarkOffset += markersCount * (long)reportSize;
    }

    protected void appendMarkers(int markersCount) throws IOException {
        if (markersCount <= 0) {
            return;
        }
        Appendable target = this.getStdout();
        char marker = this.getMarkerChar();
        int limit = this.getMarkersPerLine();
        for (int index = 1; index <= markersCount; ++index) {
            target.append(marker);
            ++this.curMarkersInLine;
            if (this.curMarkersInLine < limit) continue;
            target.append(System.lineSeparator());
            this.curMarkersInLine = 0;
        }
    }
}

