/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.server.session;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import org.apache.sshd.common.NamedResource;
import org.apache.sshd.common.PropertyResolver;
import org.apache.sshd.common.Service;
import org.apache.sshd.common.SshConstants;
import org.apache.sshd.common.SshException;
import org.apache.sshd.common.config.keys.KeyRandomArt;
import org.apache.sshd.common.io.IoWriteFuture;
import org.apache.sshd.common.keyprovider.KeyIdentityProvider;
import org.apache.sshd.common.session.Session;
import org.apache.sshd.common.session.SessionContext;
import org.apache.sshd.common.session.SessionDisconnectHandler;
import org.apache.sshd.common.util.GenericUtils;
import org.apache.sshd.common.util.NumberUtils;
import org.apache.sshd.common.util.ValidateUtils;
import org.apache.sshd.common.util.buffer.Buffer;
import org.apache.sshd.common.util.closeable.AbstractCloseable;
import org.apache.sshd.common.util.io.IoUtils;
import org.apache.sshd.core.CoreModuleProperties;
import org.apache.sshd.server.ServerFactoryManager;
import org.apache.sshd.server.auth.AsyncAuthException;
import org.apache.sshd.server.auth.UserAuth;
import org.apache.sshd.server.auth.UserAuthFactory;
import org.apache.sshd.server.auth.WelcomeBannerPhase;
import org.apache.sshd.server.session.ServerSession;
import org.apache.sshd.server.session.ServerSessionHolder;

public class ServerUserAuthService
extends AbstractCloseable
implements Service,
ServerSessionHolder {
    private final AtomicBoolean welcomeSent = new AtomicBoolean(false);
    private final Map<String, Object> properties = new ConcurrentHashMap<String, Object>();
    private final ServerSession serverSession;
    private final WelcomeBannerPhase welcomePhase;
    private List<UserAuthFactory> userAuthFactories;
    private List<List<String>> authMethods;
    private String authUserName;
    private String authMethod;
    private String authService;
    private UserAuth currentAuth;
    private int maxAuthRequests;
    private int nbAuthRequests;

    public ServerUserAuthService(Session s) throws IOException {
        boolean debugEnabled = this.log.isDebugEnabled();
        this.serverSession = (ServerSession)ValidateUtils.checkInstanceOf((Object)s, ServerSession.class, (String)"Server side service used on client side: %s", (Object)s);
        if (s.isAuthenticated()) {
            throw new SshException("Session already authenticated");
        }
        this.welcomePhase = (WelcomeBannerPhase)((Object)CoreModuleProperties.WELCOME_BANNER_PHASE.getRequired((PropertyResolver)this));
        this.maxAuthRequests = (Integer)CoreModuleProperties.MAX_AUTH_REQUESTS.getRequired((PropertyResolver)this);
        List factories = (List)ValidateUtils.checkNotNullAndNotEmpty((Collection)this.serverSession.getUserAuthFactories(), (String)"No user auth factories for %s", (Object[])new Object[]{s});
        this.userAuthFactories = new ArrayList<UserAuthFactory>(factories);
        this.authMethods = new ArrayList<List<String>>();
        String mths = (String)CoreModuleProperties.AUTH_METHODS.getOrNull((PropertyResolver)this);
        if (GenericUtils.isEmpty((CharSequence)mths)) {
            for (UserAuthFactory userAuthFactory : factories) {
                this.authMethods.add(new ArrayList<String>(Collections.singletonList(userAuthFactory.getName())));
            }
        } else {
            if (debugEnabled) {
                this.log.debug("ServerUserAuthService({}) using configured methods={}", (Object)s, (Object)mths);
            }
            for (String mthl : mths.split("\\s")) {
                this.authMethods.add(new ArrayList<String>(Arrays.asList(GenericUtils.split((String)mthl, (char)','))));
            }
        }
        for (List list : this.authMethods) {
            for (String m : list) {
                UserAuthFactory factory = (UserAuthFactory)NamedResource.findByName((String)m, (Comparator)String.CASE_INSENSITIVE_ORDER, this.userAuthFactories);
                if (factory != null) continue;
                throw new SshException("Configured method is not supported: " + m);
            }
        }
        if (debugEnabled) {
            this.log.debug("ServerUserAuthService({}) authorized authentication methods: {}", (Object)s, (Object)NamedResource.getNames(this.userAuthFactories));
        }
        s.resetAuthTimeout();
    }

    public WelcomeBannerPhase getWelcomePhase() {
        return this.welcomePhase;
    }

    @Override
    public void start() {
    }

    @Override
    public ServerSession getSession() {
        return this.getServerSession();
    }

    @Override
    public ServerSession getServerSession() {
        return this.serverSession;
    }

    public Map<String, Object> getProperties() {
        return this.properties;
    }

    @Override
    public synchronized void process(int cmd, Buffer buffer) throws Exception {
        Boolean authed = Boolean.FALSE;
        ServerSession session = this.getServerSession();
        boolean debugEnabled = this.log.isDebugEnabled();
        if (cmd == 50) {
            AtomicReference<Boolean> authHolder = new AtomicReference<Boolean>(authed);
            if (!this.handleUserAuthRequestMessage(session, buffer, authHolder)) {
                return;
            }
            authed = authHolder.get();
        } else {
            if (WelcomeBannerPhase.FIRST_AUTHCMD.equals((Object)this.getWelcomePhase())) {
                this.sendWelcomeBanner(session);
            }
            if (this.currentAuth == null) {
                throw new IllegalStateException("No current authentication mechanism for cmd=" + SshConstants.getCommandMessageName((int)cmd));
            }
            if (debugEnabled) {
                this.log.debug("process({}) Received authentication message={} for mechanism={}", new Object[]{session, SshConstants.getCommandMessageName((int)cmd), this.currentAuth.getName()});
            }
            buffer.rpos(buffer.rpos() - 1);
            try {
                authed = this.currentAuth.next(buffer);
            }
            catch (AsyncAuthException async) {
                async.addListener(authenticated -> this.asyncAuth(cmd, buffer, (boolean)authenticated));
                return;
            }
            catch (Exception e) {
                this.warn("process({}) Failed ({}) to authenticate using current method={}: {}", session, e.getClass().getSimpleName(), this.currentAuth.getName(), e.getMessage(), e);
            }
        }
        if (authed == null) {
            this.handleAuthenticationInProgress(cmd, buffer);
        } else if (authed.booleanValue()) {
            this.handleAuthenticationSuccess(cmd, buffer);
        } else {
            this.handleAuthenticationFailure(cmd, buffer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean handleUserAuthRequestMessage(ServerSession session, Buffer buffer, AtomicReference<Boolean> authHolder) throws Exception {
        UserAuthFactory factory;
        boolean debugEnabled = this.log.isDebugEnabled();
        if (session.isAuthenticated()) {
            String username = buffer.getString();
            String service = buffer.getString();
            String method = buffer.getString();
            if (debugEnabled) {
                this.log.debug("handleUserAuthRequestMessage({}) ignore user={}, service={}, method={} auth. request since session already authenticated", new Object[]{session, username, service, method});
            }
            return false;
        }
        if (WelcomeBannerPhase.FIRST_REQUEST.equals((Object)this.getWelcomePhase())) {
            this.sendWelcomeBanner(session);
        }
        if (this.currentAuth != null) {
            try {
                this.currentAuth.destroy();
            }
            finally {
                this.currentAuth = null;
            }
        }
        String username = buffer.getString();
        String service = buffer.getString();
        String method = buffer.getString();
        if (debugEnabled) {
            this.log.debug("handleUserAuthRequestMessage({}) Received SSH_MSG_USERAUTH_REQUEST user={}, service={}, method={}", new Object[]{session, username, service, method});
        }
        if (this.authUserName == null || this.authService == null) {
            this.authUserName = username;
            this.authService = service;
        } else if (this.authUserName.equals(username) && this.authService.equals(service)) {
            ++this.nbAuthRequests;
            if (this.nbAuthRequests > this.maxAuthRequests) {
                boolean disconnectSession = true;
                try {
                    SessionDisconnectHandler handler = session.getSessionDisconnectHandler();
                    disconnectSession = handler == null || !handler.handleAuthCountDisconnectReason(session, this, service, method, username, this.nbAuthRequests, this.maxAuthRequests);
                }
                catch (IOException | RuntimeException e) {
                    this.warn("handleUserAuthRequestMessage({}) failed ({}) to invoke disconnect handler due to user={}/{}, service={}/{} - {}/{} auth requests: {}", session, e.getClass().getSimpleName(), this.authUserName, username, this.authService, service, this.nbAuthRequests, this.maxAuthRequests, e.getMessage(), e);
                }
                if (disconnectSession) {
                    session.disconnect(2, "Too many authentication failures: " + this.nbAuthRequests);
                    return false;
                }
                if (debugEnabled) {
                    this.log.debug("handleUserAuthRequestMessage({}) ignore mismatched authentication counts: user={}/{}, service={}/{}: {}/{}", new Object[]{session, this.authUserName, username, this.authService, service, this.nbAuthRequests, this.maxAuthRequests});
                }
            }
        } else {
            boolean disconnectSession = true;
            try {
                SessionDisconnectHandler handler = session.getSessionDisconnectHandler();
                disconnectSession = handler == null || !handler.handleAuthParamsDisconnectReason(session, this, this.authUserName, username, this.authService, service);
            }
            catch (IOException | RuntimeException e) {
                this.warn("handleUserAuthRequestMessage({}) failed ({}) to invoke disconnect handler due to user={}/{}, service={}/{} mismatched parameters: {}", session, e.getClass().getSimpleName(), this.authUserName, username, this.authService, service, e.getMessage(), e);
            }
            if (disconnectSession) {
                session.disconnect(2, "Change of username or service is not allowed (" + this.authUserName + ", " + this.authService + ") -> (" + username + ", " + service + ")");
            } else if (debugEnabled) {
                this.log.debug("handleUserAuthRequestMessage({}) ignore mismatched authentication parameters: user={}/{}, service={}/{}", new Object[]{session, this.authUserName, username, this.authService, service});
            }
            return false;
        }
        this.authMethod = method;
        if (debugEnabled) {
            this.log.debug("handleUserAuthRequestMessage({}) Authenticating user '{}' with service '{}' and method '{}' (attempt {} / {})", new Object[]{session, username, service, method, this.nbAuthRequests, this.maxAuthRequests});
        }
        if ((factory = (UserAuthFactory)NamedResource.findByName((String)method, (Comparator)String.CASE_INSENSITIVE_ORDER, this.userAuthFactories)) == null) {
            if (debugEnabled) {
                this.log.debug("handleUserAuthRequestMessage({}) no authentication factory for method={}", (Object)session, (Object)method);
            }
            return true;
        }
        this.currentAuth = (UserAuth)ValidateUtils.checkNotNull((Object)factory.createUserAuth(session), (String)"No authenticator created for method=%s", (Object)method);
        try {
            Boolean authed = this.currentAuth.auth(session, username, service, buffer);
            authHolder.set(authed);
        }
        catch (AsyncAuthException async) {
            async.addListener(authenticated -> this.asyncAuth(50, buffer, (boolean)authenticated));
            return false;
        }
        catch (Exception e) {
            this.warn("handleUserAuthRequestMessage({}) Failed ({}) to authenticate using factory method={}: {}", session, e.getClass().getSimpleName(), method, e.getMessage(), e);
        }
        return true;
    }

    protected synchronized void asyncAuth(int cmd, Buffer buffer, boolean authed) {
        try {
            if (authed) {
                this.handleAuthenticationSuccess(cmd, buffer);
            } else {
                this.handleAuthenticationFailure(cmd, buffer);
            }
        }
        catch (Exception e) {
            ServerSession session = this.getServerSession();
            this.warn("asyncAuth({}) Error ({}) performing async authentication via cmd={}: {}", session, e.getClass().getSimpleName(), cmd, e.getMessage(), e);
        }
    }

    protected void handleAuthenticationInProgress(int cmd, Buffer buffer) throws Exception {
        String username;
        String string = username = this.currentAuth == null ? null : this.currentAuth.getUsername();
        if (this.log.isDebugEnabled()) {
            this.log.debug("handleAuthenticationInProgress({}@{}) {}", new Object[]{username, this.getServerSession(), SshConstants.getCommandMessageName((int)cmd)});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleAuthenticationSuccess(int cmd, Buffer buffer) throws Exception {
        String username = Objects.requireNonNull(this.currentAuth, "No current auth").getUsername();
        ServerSession session = this.getServerSession();
        boolean debugEnabled = this.log.isDebugEnabled();
        if (debugEnabled) {
            this.log.debug("handleAuthenticationSuccess({}@{}) {}", new Object[]{username, session, SshConstants.getCommandMessageName((int)cmd)});
        }
        boolean success = false;
        for (List<String> l2 : this.authMethods) {
            if (GenericUtils.size(l2) <= 0 || !l2.get(0).equals(this.authMethod)) continue;
            l2.remove(0);
            success |= l2.isEmpty();
        }
        if (success) {
            int currentSessionCount;
            Integer maxSessionCount = (Integer)CoreModuleProperties.MAX_CONCURRENT_SESSIONS.getOrNull((PropertyResolver)session);
            if (maxSessionCount != null && (currentSessionCount = session.getActiveSessionCountForUser(username)) >= maxSessionCount) {
                boolean disconnectSession = true;
                try {
                    SessionDisconnectHandler handler = session.getSessionDisconnectHandler();
                    disconnectSession = handler == null || !handler.handleSessionsCountDisconnectReason(session, this, username, currentSessionCount, maxSessionCount);
                }
                catch (IOException | RuntimeException e) {
                    this.warn("handleAuthenticationSuccess({}@{}) failed ({}) to invoke disconnect handler due to {}/{} sessions count: {}", username, session, e.getClass().getSimpleName(), currentSessionCount, maxSessionCount, e.getMessage(), e);
                }
                if (disconnectSession) {
                    session.disconnect(12, "Too many concurrent connections (" + currentSessionCount + ") - max. allowed: " + maxSessionCount);
                    return;
                }
                if (debugEnabled) {
                    this.log.debug("handleAuthenticationSuccess({}@{}) ignore {}/{} sessions count due to handler intervention", new Object[]{username, session, currentSessionCount, maxSessionCount});
                }
            }
            if (WelcomeBannerPhase.POST_SUCCESS.equals((Object)this.getWelcomePhase())) {
                this.sendWelcomeBanner(session);
            }
            session.signalAuthenticationSuccess(username, this.authService, buffer);
        } else {
            String remaining = this.authMethods.stream().filter(GenericUtils::isNotEmpty).map(l -> (String)l.get(0)).collect(Collectors.joining(","));
            if (debugEnabled) {
                this.log.debug("handleAuthenticationSuccess({}@{}) remaining methods={}", new Object[]{username, session, remaining});
            }
            Buffer response = session.createBuffer((byte)51, remaining.length() + 8);
            response.putString(remaining);
            response.putBoolean(true);
            session.writePacket(response);
        }
        try {
            this.currentAuth.destroy();
        }
        finally {
            this.currentAuth = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleAuthenticationFailure(int cmd, Buffer buffer) throws Exception {
        String username;
        ServerSession session = this.getServerSession();
        boolean debugEnabled = this.log.isDebugEnabled();
        if (WelcomeBannerPhase.FIRST_FAILURE.equals((Object)this.getWelcomePhase())) {
            this.sendWelcomeBanner(session);
        }
        String string = username = this.currentAuth == null ? null : this.currentAuth.getUsername();
        if (debugEnabled) {
            this.log.debug("handleAuthenticationFailure({}@{}) {}", new Object[]{username, session, SshConstants.getCommandMessageName((int)cmd)});
        }
        StringBuilder sb = new StringBuilder((this.authMethods.size() + 1) * 8);
        for (List<String> l : this.authMethods) {
            String m;
            if (GenericUtils.size(l) <= 0 || "none".equals(m = l.get(0))) continue;
            if (sb.length() > 0) {
                sb.append(',');
            }
            sb.append(m);
        }
        String remaining = sb.toString();
        if (debugEnabled) {
            this.log.debug("handleAuthenticationFailure({}@{}) remaining methods: {}", new Object[]{username, session, remaining});
        }
        buffer = session.createBuffer((byte)51, remaining.length() + 8);
        buffer.putString(remaining);
        buffer.putBoolean(false);
        session.writePacket(buffer);
        if (this.currentAuth != null) {
            try {
                this.currentAuth.destroy();
            }
            finally {
                this.currentAuth = null;
            }
        }
    }

    public IoWriteFuture sendWelcomeBanner(ServerSession session) throws IOException {
        if (this.welcomeSent.getAndSet(true)) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("sendWelcomeBanner({}) already sent", (Object)session);
            }
            return null;
        }
        String welcomeBanner = this.resolveWelcomeBanner(session);
        if (GenericUtils.isEmpty((CharSequence)welcomeBanner)) {
            return null;
        }
        String lang = (String)CoreModuleProperties.WELCOME_BANNER_LANGUAGE.getRequired((PropertyResolver)this);
        Buffer buffer = session.createBuffer((byte)53, welcomeBanner.length() + GenericUtils.length((CharSequence)lang) + 64);
        buffer.putString(welcomeBanner);
        buffer.putString(lang);
        if (this.log.isDebugEnabled()) {
            this.log.debug("sendWelcomeBanner({}) send banner (length={}, lang={})", new Object[]{session, welcomeBanner.length(), lang});
        }
        return session.writePacket(buffer);
    }

    protected String resolveWelcomeBanner(ServerSession session) throws IOException {
        Object bannerValue = CoreModuleProperties.WELCOME_BANNER.getOrNull((PropertyResolver)this);
        if (bannerValue == null) {
            return null;
        }
        if (bannerValue instanceof CharSequence) {
            String message = bannerValue.toString();
            if (GenericUtils.isEmpty((CharSequence)message)) {
                return null;
            }
            if ("#auto-welcome-banner".equalsIgnoreCase(message)) {
                try {
                    return KeyRandomArt.combine((SessionContext)session, (char)' ', (KeyIdentityProvider)session.getKeyPairProvider());
                }
                catch (IOException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw new IOException(e);
                }
            }
            if (!message.contains("://")) {
                return message;
            }
            try {
                bannerValue = new URI(message);
            }
            catch (URISyntaxException e) {
                this.log.error("resolveWelcomeBanner({}) bad path URI {}: {}", new Object[]{session, message, e.getMessage()});
                throw new MalformedURLException(e.getClass().getSimpleName() + " - bad URI (" + message + "): " + e.getMessage());
            }
            if (message.startsWith("file:/")) {
                bannerValue = Paths.get((URI)bannerValue);
            }
        }
        if (bannerValue instanceof File) {
            bannerValue = ((File)bannerValue).toPath();
        }
        if (bannerValue instanceof Path) {
            Path path = (Path)bannerValue;
            if (!Files.exists(path, new LinkOption[0]) || Files.size(path) <= 0L) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug("resolveWelcomeBanner({}) file is empty/does not exist {}", (Object)session, (Object)path);
                }
                return null;
            }
            bannerValue = path.toUri();
        }
        if (bannerValue instanceof URI) {
            bannerValue = ((URI)bannerValue).toURL();
        }
        if (bannerValue instanceof URL) {
            Charset cs = (Charset)CoreModuleProperties.WELCOME_BANNER_CHARSET.getRequired((PropertyResolver)this);
            return this.loadWelcomeBanner(session, (URL)bannerValue, cs);
        }
        return bannerValue.toString();
    }

    protected String loadWelcomeBanner(ServerSession session, URL url, Charset cs) throws IOException {
        try (InputStream stream = url.openStream();){
            byte[] bytes = IoUtils.toByteArray((InputStream)stream);
            String string = NumberUtils.isEmpty((byte[])bytes) ? "" : new String(bytes, cs);
            return string;
        }
    }

    public ServerFactoryManager getFactoryManager() {
        return this.serverSession.getFactoryManager();
    }
}

