/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.commons.validator;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.el.ValueExpression;
import javax.faces.application.FacesMessage;
import javax.faces.component.StateHolder;
import javax.faces.context.FacesContext;
import javax.faces.validator.Validator;
import org.apache.myfaces.commons.util.MessageUtils;
import org.apache.myfaces.commons.validator._AttachedListStateWrapper;
import org.apache.myfaces.commons.validator._AttachedStateWrapper;

public abstract class ValidatorBase
implements StateHolder,
Validator {
    private String _summaryMessage = null;
    private String _detailMessage = null;
    private boolean _transient = false;
    private Map _valueExpressionMap = null;

    public String getSummaryMessage() {
        if (this._summaryMessage != null) {
            return this._summaryMessage;
        }
        ValueExpression expression = this.getValueExpression("summaryMessage");
        return expression != null ? this.getStringValue(this.getFacesContext(), expression) : null;
    }

    public void setSummaryMessage(String message) {
        this._summaryMessage = message;
    }

    public String getMessage() {
        return this.getDetailMessage();
    }

    public void setMessage(String message) {
        this.setDetailMessage(message);
    }

    public String getDetailMessage() {
        if (this._detailMessage != null) {
            return this._detailMessage;
        }
        ValueExpression vb = this.getValueExpression("detailMessage");
        return vb != null ? this.getStringValue(this.getFacesContext(), vb) : null;
    }

    public void setDetailMessage(String message) {
        this._detailMessage = message;
    }

    public Object saveState(FacesContext context) {
        Object[] state = new Object[]{this._summaryMessage, this._detailMessage, this.saveValueExpressionMap(context)};
        return state;
    }

    public void restoreState(FacesContext context, Object state) {
        Object[] values = (Object[])state;
        this._summaryMessage = (String)values[0];
        this._detailMessage = (String)values[1];
        this.restoreValueExpressionMap(context, values[2]);
    }

    public boolean isTransient() {
        return this._transient;
    }

    public void setTransient(boolean newTransientValue) {
        this._transient = newTransientValue;
    }

    protected FacesMessage getFacesMessage(String defaultMessage, Object[] args) {
        FacesMessage msg;
        if (this.getSummaryMessage() == null && this.getDetailMessage() == null) {
            msg = MessageUtils.getMessage((FacesMessage.Severity)FacesMessage.SEVERITY_ERROR, (String)defaultMessage, (Object[])args);
        } else {
            Locale locale = MessageUtils.getCurrentLocale();
            String summaryText = MessageUtils.substituteParams((Locale)locale, (String)this.getSummaryMessage(), (Object[])args);
            String detailText = MessageUtils.substituteParams((Locale)locale, (String)this.getDetailMessage(), (Object[])args);
            msg = new FacesMessage(FacesMessage.SEVERITY_ERROR, summaryText, detailText);
        }
        return msg;
    }

    public ValueExpression getValueExpression(String name) {
        if (name == null) {
            throw new NullPointerException("name");
        }
        if (this._valueExpressionMap == null) {
            return null;
        }
        return (ValueExpression)this._valueExpressionMap.get(name);
    }

    public void setValueExpression(String name, ValueExpression binding) {
        if (name == null) {
            throw new NullPointerException("name");
        }
        if (this._valueExpressionMap == null) {
            this._valueExpressionMap = new HashMap();
        }
        this._valueExpressionMap.put(name, binding);
    }

    private Object saveValueExpressionMap(FacesContext context) {
        if (this._valueExpressionMap != null) {
            int initCapacity = (this._valueExpressionMap.size() * 4 + 3) / 3;
            HashMap stateMap = new HashMap(initCapacity);
            for (Map.Entry entry : this._valueExpressionMap.entrySet()) {
                stateMap.put(entry.getKey(), ValidatorBase.saveAttachedState(context, entry.getValue()));
            }
            return stateMap;
        }
        return null;
    }

    private void restoreValueExpressionMap(FacesContext context, Object stateObj) {
        if (stateObj != null) {
            Map stateMap = (Map)stateObj;
            int initCapacity = (stateMap.size() * 4 + 3) / 3;
            this._valueExpressionMap = new HashMap(initCapacity);
            for (Map.Entry entry : stateMap.entrySet()) {
                this._valueExpressionMap.put(entry.getKey(), ValidatorBase.restoreAttachedState(context, entry.getValue()));
            }
        } else {
            this._valueExpressionMap = null;
        }
    }

    public static Object saveAttachedState(FacesContext context, Object attachedObject) {
        if (attachedObject == null) {
            return null;
        }
        if (attachedObject instanceof List) {
            ArrayList<Object> lst = new ArrayList<Object>(((List)attachedObject).size());
            Iterator it = ((List)attachedObject).iterator();
            while (it.hasNext()) {
                lst.add(ValidatorBase.saveAttachedState(context, it.next()));
            }
            return new _AttachedListStateWrapper(lst);
        }
        if (attachedObject instanceof StateHolder) {
            if (((StateHolder)attachedObject).isTransient()) {
                return null;
            }
            return new _AttachedStateWrapper(attachedObject.getClass(), ((StateHolder)attachedObject).saveState(context));
        }
        if (attachedObject instanceof Serializable) {
            return attachedObject;
        }
        return new _AttachedStateWrapper(attachedObject.getClass(), null);
    }

    public static Object restoreAttachedState(FacesContext context, Object stateObj) throws IllegalStateException {
        if (context == null) {
            throw new NullPointerException("context");
        }
        if (stateObj == null) {
            return null;
        }
        if (stateObj instanceof _AttachedListStateWrapper) {
            List lst = ((_AttachedListStateWrapper)stateObj).getWrappedStateList();
            ArrayList<Object> restoredList = new ArrayList<Object>(lst.size());
            Iterator it = lst.iterator();
            while (it.hasNext()) {
                restoredList.add(ValidatorBase.restoreAttachedState(context, it.next()));
            }
            return restoredList;
        }
        if (stateObj instanceof _AttachedStateWrapper) {
            Object restoredObject;
            Class clazz = ((_AttachedStateWrapper)stateObj).getClazz();
            try {
                restoredObject = clazz.newInstance();
            }
            catch (InstantiationException e) {
                throw new RuntimeException("Could not restore StateHolder of type " + clazz.getName() + " (missing no-args constructor?)", e);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
            if (restoredObject instanceof StateHolder) {
                Object wrappedState = ((_AttachedStateWrapper)stateObj).getWrappedStateObject();
                ((StateHolder)restoredObject).restoreState(context, wrappedState);
            }
            return restoredObject;
        }
        return stateObj;
    }

    protected FacesContext getFacesContext() {
        return FacesContext.getCurrentInstance();
    }

    protected String getStringValue(FacesContext context, ValueExpression vb) {
        Object value = vb.getValue(context.getELContext());
        if (value != null) {
            return value.toString();
        }
        return null;
    }
}

