/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.view.facelets.tag.composite;

import java.beans.BeanDescriptor;
import java.beans.BeanInfo;
import java.beans.PropertyDescriptor;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.el.ELException;
import javax.el.ValueExpression;
import javax.el.VariableMapper;
import javax.faces.FacesException;
import javax.faces.application.ProjectStage;
import javax.faces.application.Resource;
import javax.faces.component.ActionSource;
import javax.faces.component.EditableValueHolder;
import javax.faces.component.UIComponent;
import javax.faces.component.UIPanel;
import javax.faces.component.UniqueIdVendor;
import javax.faces.component.ValueHolder;
import javax.faces.context.FacesContext;
import javax.faces.view.AttachedObjectHandler;
import javax.faces.view.ViewDeclarationLanguage;
import javax.faces.view.facelets.ComponentConfig;
import javax.faces.view.facelets.ComponentHandler;
import javax.faces.view.facelets.CompositeFaceletHandler;
import javax.faces.view.facelets.FaceletContext;
import javax.faces.view.facelets.FaceletException;
import javax.faces.view.facelets.FaceletHandler;
import javax.faces.view.facelets.FacetHandler;
import javax.faces.view.facelets.MetaRuleset;
import javax.faces.view.facelets.Metadata;
import javax.faces.view.facelets.TagAttribute;
import javax.faces.view.facelets.TagException;
import javax.faces.view.facelets.TextHandler;
import org.apache.myfaces.view.facelets.AbstractFaceletContext;
import org.apache.myfaces.view.facelets.FaceletCompositionContext;
import org.apache.myfaces.view.facelets.TemplateClient;
import org.apache.myfaces.view.facelets.TemplateContext;
import org.apache.myfaces.view.facelets.el.VariableMapperWrapper;
import org.apache.myfaces.view.facelets.tag.ComponentContainerHandler;
import org.apache.myfaces.view.facelets.tag.TagHandlerUtils;
import org.apache.myfaces.view.facelets.tag.composite.CompositeComponentBeanInfo;
import org.apache.myfaces.view.facelets.tag.composite.CompositeComponentRule;
import org.apache.myfaces.view.facelets.tag.composite.CompositeMetaRulesetImpl;
import org.apache.myfaces.view.facelets.tag.composite.CompositeResouceWrapper;
import org.apache.myfaces.view.facelets.tag.composite.InsertFacetHandler;
import org.apache.myfaces.view.facelets.tag.composite.RetargetMethodExpressionRule;
import org.apache.myfaces.view.facelets.tag.jsf.ActionSourceRule;
import org.apache.myfaces.view.facelets.tag.jsf.ComponentBuilderHandler;
import org.apache.myfaces.view.facelets.tag.jsf.ComponentSupport;
import org.apache.myfaces.view.facelets.tag.jsf.EditableValueHolderRule;
import org.apache.myfaces.view.facelets.tag.jsf.ValueHolderRule;
import org.apache.myfaces.view.facelets.tag.jsf.core.AjaxHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompositeComponentResourceTagHandler
extends ComponentHandler
implements ComponentBuilderHandler,
TemplateClient {
    private final Resource _resource;
    private Metadata _mapper;
    private Class<?> _lastType = Object.class;
    protected volatile Map<String, FaceletHandler> _facetHandlersMap;
    protected final Collection<FaceletHandler> _componentHandlers;
    protected final Collection<FaceletHandler> _facetHandlers;

    public CompositeComponentResourceTagHandler(ComponentConfig config, Resource resource) {
        super(config);
        this._resource = resource;
        this._facetHandlers = TagHandlerUtils.findNextByType(this.nextHandler, FacetHandler.class, InsertFacetHandler.class);
        this._componentHandlers = TagHandlerUtils.findNextByType(this.nextHandler, ComponentHandler.class, ComponentContainerHandler.class, TextHandler.class);
    }

    @Override
    public UIComponent createComponent(FaceletContext ctx) {
        FacesContext facesContext = ctx.getFacesContext();
        UIComponent component = facesContext.getApplication().createComponent(facesContext, this._resource);
        if (!facesContext.isProjectStage(ProjectStage.Production)) {
            BeanInfo beanInfo = (BeanInfo)component.getAttributes().get("javax.faces.component.BEANINFO_KEY");
            for (PropertyDescriptor propertyDescriptor : beanInfo.getPropertyDescriptors()) {
                TagAttribute attrValue;
                ValueExpression ve = (ValueExpression)propertyDescriptor.getValue("required");
                if (ve == null) continue;
                Object value = ve.getValue(facesContext.getELContext());
                Boolean required = null;
                required = value instanceof Boolean ? (Boolean)value : Boolean.valueOf(value.toString());
                if (required == null || !required.booleanValue() || (attrValue = this.tag.getAttributes().get(propertyDescriptor.getName())) != null) continue;
                throw new TagException(this.tag, "Attribute '" + propertyDescriptor.getName() + "' is required");
            }
        }
        return component;
    }

    @Override
    public void applyNextHandler(FaceletContext ctx, UIComponent c) throws IOException {
        this.applyNextHandlerIfNotApplied(ctx, c);
        this.applyCompositeComponentFacelet(ctx, c);
        if (ComponentHandler.isNew(c)) {
            FacesContext facesContext = ctx.getFacesContext();
            ViewDeclarationLanguage vdl = facesContext.getApplication().getViewHandler().getViewDeclarationLanguage(facesContext, facesContext.getViewRoot().getViewId());
            FaceletCompositionContext mctx = FaceletCompositionContext.getCurrentInstance(ctx);
            List<AttachedObjectHandler> handlers = mctx.getAttachedObjectHandlers(c);
            if (handlers != null) {
                vdl.retargetAttachedObjects(facesContext, c, handlers);
                mctx.removeAttachedObjectHandlers(c);
            }
            vdl.retargetMethodExpressions(facesContext, c);
            if (FaceletCompositionContext.getCurrentInstance(ctx).isMarkInitialState()) {
                c.markInitialState();
                c.getFacet("javax.faces.component.COMPOSITE_FACET_NAME").markInitialState();
            }
        }
    }

    protected void applyNextHandlerIfNotApplied(FaceletContext ctx, UIComponent c) throws IOException {
        Map facetPropertyDescriptorMap;
        CompositeComponentBeanInfo beanInfo = (CompositeComponentBeanInfo)c.getAttributes().get("javax.faces.component.BEANINFO_KEY");
        BeanDescriptor beanDescriptor = beanInfo.getBeanDescriptor();
        boolean insertChildrenUsed = beanDescriptor.getValue("org.apache.myfaces.INSERT_CHILDREN_USED") != null;
        List insertFacetList = (List)beanDescriptor.getValue(InsertFacetHandler.INSERT_FACET_USED);
        if (this.nextHandler instanceof CompositeFaceletHandler) {
            for (FaceletHandler handler : ((CompositeFaceletHandler)this.nextHandler).getHandlers()) {
                if (handler instanceof FacetHandler) {
                    if (insertFacetList != null && insertFacetList.contains(((FacetHandler)((Object)handler)).getFacetName(ctx))) continue;
                    handler.apply(ctx, c);
                    continue;
                }
                if (handler instanceof InsertFacetHandler) {
                    if (insertFacetList != null && insertFacetList.contains(((InsertFacetHandler)handler).getFacetName(ctx))) continue;
                    handler.apply(ctx, c);
                    continue;
                }
                if (insertChildrenUsed) {
                    if (handler instanceof ComponentHandler || handler instanceof ComponentContainerHandler || handler instanceof TextHandler) continue;
                    handler.apply(ctx, c);
                    continue;
                }
                handler.apply(ctx, c);
            }
        } else if (this.nextHandler instanceof FacetHandler) {
            if (insertFacetList == null || !insertFacetList.contains(((FacetHandler)((Object)this.nextHandler)).getFacetName(ctx))) {
                this.nextHandler.apply(ctx, c);
            }
        } else if (this.nextHandler instanceof InsertFacetHandler) {
            if (insertFacetList == null || !insertFacetList.contains(((InsertFacetHandler)this.nextHandler).getFacetName(ctx))) {
                this.nextHandler.apply(ctx, c);
            }
        } else if (insertChildrenUsed) {
            if (!(this.nextHandler instanceof ComponentHandler || this.nextHandler instanceof ComponentContainerHandler || this.nextHandler instanceof TextHandler)) {
                this.nextHandler.apply(ctx, c);
            }
        } else {
            this.nextHandler.apply(ctx, c);
        }
        if ((facetPropertyDescriptorMap = (Map)beanDescriptor.getValue("javax.faces.component.FACETS_KEY")) != null) {
            ArrayList facetsRequiredNotFound = null;
            for (Map.Entry entry : facetPropertyDescriptorMap.entrySet()) {
                Boolean required;
                ValueExpression requiredExpr = (ValueExpression)((PropertyDescriptor)entry.getValue()).getValue("required");
                if (requiredExpr == null || !Boolean.TRUE.equals(required = (Boolean)requiredExpr.getValue(ctx.getFacesContext().getELContext()))) continue;
                this.initFacetHandlersMap(ctx);
                if (this._facetHandlersMap.containsKey(entry.getKey())) continue;
                if (facetsRequiredNotFound == null) {
                    facetsRequiredNotFound = new ArrayList(facetPropertyDescriptorMap.size());
                }
                facetsRequiredNotFound.add(entry.getKey());
            }
            if (facetsRequiredNotFound != null && !facetsRequiredNotFound.isEmpty()) {
                throw new TagException(this.getTag(), "The following facets are required by the component: " + facetsRequiredNotFound);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void applyCompositeComponentFacelet(FaceletContext faceletContext, UIComponent compositeComponentBase) throws IOException {
        Iterator<AjaxHandler> it;
        FaceletCompositionContext mctx = FaceletCompositionContext.getCurrentInstance(faceletContext);
        AbstractFaceletContext actx = (AbstractFaceletContext)faceletContext;
        UIPanel compositeFacetPanel = (UIPanel)compositeComponentBase.getFacets().get("javax.faces.component.COMPOSITE_FACET_NAME");
        if (compositeFacetPanel == null) {
            compositeFacetPanel = (UIPanel)faceletContext.getFacesContext().getApplication().createComponent(faceletContext.getFacesContext(), "javax.faces.Panel", null);
            compositeFacetPanel.getAttributes().put("oam.vf.addedByHandler", Boolean.TRUE);
            compositeComponentBase.getFacets().put("javax.faces.component.COMPOSITE_FACET_NAME", compositeFacetPanel);
            UniqueIdVendor uniqueIdVendor = mctx.getUniqueIdVendorFromStack();
            if (uniqueIdVendor == null) {
                uniqueIdVendor = ComponentSupport.getViewRoot(faceletContext, compositeComponentBase);
            }
            if (uniqueIdVendor != null) {
                String uid = uniqueIdVendor.createUniqueId(faceletContext.getFacesContext(), mctx.getSharedStringBuilder().append(compositeComponentBase.getId()).append("__f_").append("cc_facet").toString());
                compositeFacetPanel.setId(uid);
            }
        }
        if ((it = ((AbstractFaceletContext)faceletContext).getAjaxHandlers()) != null) {
            while (it.hasNext()) {
                mctx.addAttachedObjectHandler(compositeComponentBase, it.next());
            }
        }
        VariableMapper orig = faceletContext.getVariableMapper();
        try {
            faceletContext.setVariableMapper(new VariableMapperWrapper(orig));
            actx.pushCompositeComponentClient(this);
            Resource resourceForCurrentView = faceletContext.getFacesContext().getApplication().getResourceHandler().createResource(this._resource.getResourceName(), this._resource.getLibraryName());
            if (resourceForCurrentView == null) {
                throw new TagException(this.getTag(), "Composite Component " + this.getTag().getQName() + " requires a default instance that can be found by the installed ResourceHandler.");
            }
            resourceForCurrentView = new CompositeResouceWrapper(resourceForCurrentView);
            actx.applyCompositeComponent(compositeFacetPanel, resourceForCurrentView);
        }
        finally {
            actx.popCompositeComponentClient();
            faceletContext.setVariableMapper(orig);
        }
    }

    @Override
    public void setAttributes(FaceletContext ctx, Object instance) {
        if (instance != null) {
            UIComponent component = (UIComponent)instance;
            Class<?> type = instance.getClass();
            if (this._mapper == null || !this._lastType.equals(type)) {
                this._lastType = type;
                BeanInfo beanInfo = (BeanInfo)component.getAttributes().get("javax.faces.component.BEANINFO_KEY");
                this._mapper = this.createMetaRuleset(type, beanInfo).finish();
            }
            this._mapper.applyMetadata(ctx, instance);
        }
    }

    protected MetaRuleset createMetaRuleset(Class<?> type, BeanInfo beanInfo) {
        CompositeMetaRulesetImpl m = new CompositeMetaRulesetImpl(this.getTag(), type, beanInfo);
        ((MetaRuleset)m).ignore("binding").ignore("id");
        ((MetaRuleset)m).addRule(CompositeComponentRule.Instance);
        ((MetaRuleset)m).addRule(RetargetMethodExpressionRule.Instance);
        if (ActionSource.class.isAssignableFrom(type)) {
            ((MetaRuleset)m).addRule(ActionSourceRule.Instance);
        }
        if (ValueHolder.class.isAssignableFrom(type)) {
            ((MetaRuleset)m).addRule(ValueHolderRule.Instance);
            if (EditableValueHolder.class.isAssignableFrom(type)) {
                ((MetaRuleset)m).ignore("submittedValue");
                ((MetaRuleset)m).ignore("valid");
                ((MetaRuleset)m).addRule(EditableValueHolderRule.Instance);
            }
        }
        return m;
    }

    private void initFacetHandlersMap(FaceletContext ctx) {
        if (this._facetHandlersMap == null) {
            HashMap<String, FaceletHandler> map = new HashMap<String, FaceletHandler>();
            for (FaceletHandler handler : this._facetHandlers) {
                if (handler instanceof FacetHandler) {
                    map.put(((FacetHandler)((Object)handler)).getFacetName(ctx), handler);
                    continue;
                }
                if (!(handler instanceof InsertFacetHandler)) continue;
                map.put(((InsertFacetHandler)handler).getFacetName(ctx), handler);
            }
            this._facetHandlersMap = map;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean apply(FaceletContext ctx, UIComponent parent, String name) throws IOException, FacesException, FaceletException, ELException {
        if (name != null) {
            if (this._facetHandlers == null || this._facetHandlers.isEmpty()) {
                this.checkFacetRequired(ctx, parent, name);
                return true;
            }
            this.initFacetHandlersMap(ctx);
            FaceletHandler handler = this._facetHandlersMap.get(name);
            if (handler != null) {
                AbstractFaceletContext actx = (AbstractFaceletContext)ctx;
                FaceletCompositionContext fcc = actx.getFaceletCompositionContext();
                UIComponent innerCompositeComponent = fcc.getCompositeComponentFromStack();
                fcc.popCompositeComponentToStack();
                TemplateContext itc = actx.popTemplateContext();
                try {
                    handler.apply(ctx, parent);
                }
                finally {
                    actx.pushTemplateContext(itc);
                    fcc.pushCompositeComponentToStack(innerCompositeComponent);
                }
                return true;
            }
            this.checkFacetRequired(ctx, parent, name);
            return true;
        }
        AbstractFaceletContext actx = (AbstractFaceletContext)ctx;
        FaceletCompositionContext fcc = actx.getFaceletCompositionContext();
        UIComponent innerCompositeComponent = fcc.getCompositeComponentFromStack();
        fcc.popCompositeComponentToStack();
        TemplateContext itc = actx.popTemplateContext();
        try {
            for (FaceletHandler handler : this._componentHandlers) {
                handler.apply(ctx, parent);
            }
        }
        finally {
            actx.pushTemplateContext(itc);
            fcc.pushCompositeComponentToStack(innerCompositeComponent);
        }
        return true;
    }

    private void checkFacetRequired(FaceletContext ctx, UIComponent parent, String name) {
        ValueExpression requiredExpr;
        AbstractFaceletContext actx = (AbstractFaceletContext)ctx;
        FaceletCompositionContext fcc = actx.getFaceletCompositionContext();
        UIComponent innerCompositeComponent = fcc.getCompositeComponentFromStack();
        CompositeComponentBeanInfo beanInfo = (CompositeComponentBeanInfo)innerCompositeComponent.getAttributes().get("javax.faces.component.BEANINFO_KEY");
        BeanDescriptor beanDescriptor = beanInfo.getBeanDescriptor();
        Map insertFacetPropertyDescriptorMap = (Map)beanDescriptor.getValue(InsertFacetHandler.INSERT_FACET_KEYS);
        if (insertFacetPropertyDescriptorMap != null && insertFacetPropertyDescriptorMap.containsKey(name) && (requiredExpr = (ValueExpression)((PropertyDescriptor)insertFacetPropertyDescriptorMap.get(name)).getValue("required")) != null && Boolean.TRUE.equals(requiredExpr.getValue(ctx.getFacesContext().getELContext()))) {
            throw new TagException(this.tag, "Cannot find facet with name '" + name + "' in composite component");
        }
    }
}

