/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.flow;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.el.MethodExpression;
import javax.el.ValueExpression;
import javax.faces.flow.MethodCallNode;
import javax.faces.flow.Parameter;
import org.apache.myfaces.flow.Freezable;

public class MethodCallNodeImpl
extends MethodCallNode
implements Freezable {
    private String _id;
    private MethodExpression _methodExpression;
    private ValueExpression _outcome;
    private List<Parameter> _parameters;
    private List<Parameter> _unmodifiableParameters;
    private boolean _initialized;

    public MethodCallNodeImpl(String methodCallNodeId) {
        this._id = methodCallNodeId;
        this._parameters = new ArrayList<Parameter>();
        this._unmodifiableParameters = Collections.unmodifiableList(this._parameters);
    }

    public MethodExpression getMethodExpression() {
        return this._methodExpression;
    }

    public ValueExpression getOutcome() {
        return this._outcome;
    }

    public List<Parameter> getParameters() {
        return this._unmodifiableParameters;
    }

    public void addParameter(Parameter parameter) {
        this.checkInitialized();
        this._parameters.add(parameter);
    }

    public String getId() {
        return this._id;
    }

    @Override
    public void freeze() {
        this._initialized = true;
        for (Parameter value : this._parameters) {
            if (!(value instanceof Freezable)) continue;
            ((Freezable)value).freeze();
        }
    }

    private void checkInitialized() throws IllegalStateException {
        if (this._initialized) {
            throw new IllegalStateException("Flow is inmutable once initialized");
        }
    }

    public void setMethodExpression(MethodExpression methodExpression) {
        this.checkInitialized();
        this._methodExpression = methodExpression;
    }

    public void setOutcome(ValueExpression outcome) {
        this.checkInitialized();
        this._outcome = outcome;
    }

    public void setId(String id) {
        this.checkInitialized();
        this._id = id;
    }
}

