/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.view.facelets.tag.jstl.core;

import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.el.ELContext;
import javax.el.ELException;
import javax.el.ValueExpression;
import javax.faces.FacesException;
import javax.faces.component.UIComponent;
import javax.faces.event.PhaseId;
import javax.faces.view.facelets.FaceletContext;
import javax.faces.view.facelets.FaceletException;
import javax.faces.view.facelets.TagAttribute;
import javax.faces.view.facelets.TagAttributeException;
import javax.faces.view.facelets.TagConfig;
import javax.faces.view.facelets.TagHandler;
import org.apache.myfaces.view.facelets.AbstractFaceletContext;
import org.apache.myfaces.view.facelets.FaceletCompositionContext;
import org.apache.myfaces.view.facelets.PageContext;
import org.apache.myfaces.view.facelets.el.FaceletStateValueExpression;
import org.apache.myfaces.view.facelets.tag.ComponentContainerHandler;
import org.apache.myfaces.view.facelets.tag.jsf.ComponentSupport;
import org.apache.myfaces.view.facelets.tag.jsf.FaceletState;
import org.apache.myfaces.view.facelets.tag.jstl.core.IteratedValueExpression;
import org.apache.myfaces.view.facelets.tag.jstl.core.IterationState;
import org.apache.myfaces.view.facelets.tag.jstl.core.IterationStatus;
import org.apache.myfaces.view.facelets.tag.jstl.core.IterationStatusExpression;
import org.apache.myfaces.view.facelets.tag.jstl.core.MappedValueExpression;

public final class ForEachHandler
extends TagHandler
implements ComponentContainerHandler {
    private final TagAttribute begin;
    private final TagAttribute end;
    private final TagAttribute items = this.getAttribute("items");
    private final TagAttribute step;
    private final TagAttribute tranzient;
    private final TagAttribute var = this.getAttribute("var");
    private final TagAttribute varStatus;

    public ForEachHandler(TagConfig config) {
        super(config);
        this.begin = this.getAttribute("begin");
        this.end = this.getAttribute("end");
        this.step = this.getAttribute("step");
        this.varStatus = this.getAttribute("varStatus");
        this.tranzient = this.getAttribute("transient");
        if (this.items == null && this.begin != null && this.end == null) {
            throw new TagAttributeException(this.tag, this.begin, "If the 'items' attribute is not specified, but the 'begin' attribute is, then the 'end' attribute is required");
        }
    }

    public void apply(FaceletContext ctx, UIComponent parent) throws IOException, FacesException, FaceletException, ELException {
        int e = this.getEnd(ctx);
        Object src = null;
        ValueExpression srcVE = null;
        if (this.items != null) {
            srcVE = this.items.getValueExpression(ctx, Object.class);
            src = srcVE.getValue((ELContext)ctx);
        } else {
            byte[] b = new byte[e + 1];
            for (int i = 0; i < b.length; ++i) {
                b[i] = (byte)i;
            }
            src = b;
        }
        FaceletCompositionContext fcc = FaceletCompositionContext.getCurrentInstance(ctx);
        AbstractFaceletContext actx = (AbstractFaceletContext)ctx;
        fcc.incrementUniqueComponentId();
        String uniqueId = actx.generateUniqueFaceletTagId(fcc.generateUniqueId(), this.tagId);
        if (src != null) {
            IterationState restoredSavedOption;
            PageContext pctx = actx.getPageContext();
            FaceletState restoredFaceletState = ComponentSupport.getFaceletState(ctx, parent, false);
            IterationState iterationState = restoredSavedOption = restoredFaceletState == null ? null : (IterationState)restoredFaceletState.getState(uniqueId);
            if (restoredSavedOption != null) {
                if (!PhaseId.RESTORE_VIEW.equals(ctx.getFacesContext().getCurrentPhaseId())) {
                    this.applyOnRefresh(ctx, fcc, pctx, parent, uniqueId, src, srcVE, restoredSavedOption);
                } else {
                    this.applyOnRestore(ctx, fcc, pctx, parent, uniqueId, src, srcVE, restoredSavedOption);
                }
            } else {
                this.applyFirstTime(ctx, fcc, pctx, parent, uniqueId, src, srcVE);
            }
        }
        if (fcc.isUsingPSSOnThisView() && fcc.isRefreshTransientBuildOnPSS() && !fcc.isRefreshingTransientBuild()) {
            ComponentSupport.markComponentToRestoreFully(ctx.getFacesContext(), parent);
        }
        if (fcc.isDynamicComponentSection()) {
            ComponentSupport.markComponentToRefreshDynamically(ctx.getFacesContext(), parent);
        }
    }

    private void setVar(FaceletContext ctx, UIComponent parent, String uniqueId, String base, boolean t, Object src, ValueExpression srcVE, Object value, String v, int i) {
        if (v != null) {
            ValueExpression ve = t || srcVE == null ? (value == null ? null : ctx.getExpressionFactory().createValueExpression(value, Object.class)) : this.getVarExpr(srcVE, src, value, i);
            this.setVar(ctx, parent, uniqueId, base, v, ve, srcVE);
        }
    }

    private void setVar(FaceletContext ctx, UIComponent parent, String uniqueId, String base, String v, ValueExpression ve, ValueExpression srcVE) {
        AbstractFaceletContext actx = (AbstractFaceletContext)ctx;
        PageContext pctx = actx.getPageContext();
        if (srcVE != null) {
            FaceletState faceletState = ComponentSupport.getFaceletState(ctx, parent, true);
            faceletState.putBinding(uniqueId, base, ve);
            FaceletStateValueExpression fve = new FaceletStateValueExpression(uniqueId, base);
            pctx.getAttributes().put(v, fve);
        } else {
            pctx.getAttributes().put(v, ve);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void applyFirstTime(FaceletContext ctx, FaceletCompositionContext fcc, PageContext pctx, UIComponent parent, String uniqueId, Object src, ValueExpression srcVE) throws IOException {
        int s = this.getBegin(ctx);
        int e = this.getEnd(ctx);
        int m = this.getStep(ctx);
        Integer sO = this.begin != null ? Integer.valueOf(s) : null;
        Integer eO = this.end != null ? Integer.valueOf(e) : null;
        Integer mO = this.step != null ? Integer.valueOf(m) : null;
        boolean t = this.getTransient(ctx);
        IterationState iterationState = new IterationState();
        boolean serializableValues = true;
        Iterator<?> itr = this.toIterator(src);
        if (itr != null) {
            int i;
            for (i = 0; i < s && itr.hasNext(); ++i) {
                itr.next();
            }
            String v = this.getVarName(ctx);
            String vs = this.getVarStatusName(ctx);
            ValueExpression vO = this.capture(v, pctx);
            ValueExpression vsO = this.capture(vs, pctx);
            int mi = 0;
            Object value = null;
            try {
                boolean first = true;
                while (i <= e && itr.hasNext()) {
                    value = itr.next();
                    Integer count = iterationState.getCounter();
                    String base = count.toString();
                    iterationState.setCounter(count + 1);
                    if (value instanceof Serializable) {
                        iterationState.getValueList().add(new Object[]{base, value, i});
                    } else {
                        serializableValues = false;
                    }
                    try {
                        boolean last;
                        fcc.startComponentUniqueIdSection(base);
                        this.setVar(ctx, parent, uniqueId, base, t, src, srcVE, value, v, i);
                        boolean bl = last = !itr.hasNext();
                        if (vs != null) {
                            IterationStatus itrS = new IterationStatus(first, last, i, sO, eO, mO, value);
                            IterationStatusExpression ve = t || srcVE == null ? (srcVE == null ? null : ctx.getExpressionFactory().createValueExpression((Object)itrS, Object.class)) : new IterationStatusExpression(itrS);
                            this.setVar(ctx, parent, uniqueId, base + "_vs", vs, ve, srcVE);
                        }
                        this.nextHandler.apply(ctx, parent);
                    }
                    finally {
                        fcc.endComponentUniqueIdSection(base);
                    }
                    mi = 1;
                    while (mi < m && itr.hasNext()) {
                        itr.next();
                        ++mi;
                        ++i;
                    }
                    ++i;
                    first = false;
                }
            }
            finally {
                this.removeVarAndVarStatus(pctx, v, vO, vs, vsO);
            }
        }
        if (serializableValues) {
            FaceletState faceletState = ComponentSupport.getFaceletState(ctx, parent, true);
            faceletState.putState(uniqueId, iterationState);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void applyOnRestore(FaceletContext ctx, FaceletCompositionContext fcc, PageContext pctx, UIComponent parent, String uniqueId, Object src, ValueExpression srcVE, IterationState restoredSavedOption) throws IOException {
        int s = this.getBegin(ctx);
        int e = this.getEnd(ctx);
        int m = this.getStep(ctx);
        Integer sO = this.begin != null ? Integer.valueOf(s) : null;
        Integer eO = this.end != null ? Integer.valueOf(e) : null;
        Integer mO = this.step != null ? Integer.valueOf(m) : null;
        boolean t = this.getTransient(ctx);
        String v = this.getVarName(ctx);
        String vs = this.getVarStatusName(ctx);
        ValueExpression vO = this.capture(v, pctx);
        ValueExpression vsO = this.capture(vs, pctx);
        Object value = null;
        try {
            int size = restoredSavedOption.getValueList().size();
            for (int si = 0; si < size; ++si) {
                Object[] stateValue = restoredSavedOption.getValueList().get(si);
                value = stateValue[1];
                String base = (String)stateValue[0];
                try {
                    fcc.startComponentUniqueIdSection(base);
                    this.setVar(ctx, parent, uniqueId, base, t, src, srcVE, value, v, (Integer)stateValue[2]);
                    boolean first = si == 0;
                    boolean last = si == size - 1;
                    int i = (Integer)stateValue[2];
                    if (vs != null) {
                        IterationStatus itrS = new IterationStatus(first, last, i, sO, eO, mO, value);
                        IterationStatusExpression ve = t || srcVE == null ? (srcVE == null ? null : ctx.getExpressionFactory().createValueExpression((Object)itrS, Object.class)) : new IterationStatusExpression(itrS);
                        this.setVar(ctx, parent, uniqueId, base + "_vs", vs, ve, srcVE);
                    }
                    this.nextHandler.apply(ctx, parent);
                    continue;
                }
                finally {
                    fcc.endComponentUniqueIdSection(base);
                }
            }
        }
        finally {
            this.removeVarAndVarStatus(pctx, v, vO, vs, vsO);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void applyOnRefresh(FaceletContext ctx, FaceletCompositionContext fcc, PageContext pctx, UIComponent parent, String uniqueId, Object src, ValueExpression srcVE, IterationState restoredSavedOption) throws IOException {
        int s = this.getBegin(ctx);
        int e = this.getEnd(ctx);
        int m = this.getStep(ctx);
        Integer sO = this.begin != null ? Integer.valueOf(s) : null;
        Integer eO = this.end != null ? Integer.valueOf(e) : null;
        Integer mO = this.step != null ? Integer.valueOf(m) : null;
        boolean t = this.getTransient(ctx);
        Iterator<?> itr = this.toIterator(src);
        IterationState iterationState = new IterationState();
        iterationState.setCounter(restoredSavedOption.getCounter());
        if (itr != null) {
            int i;
            for (i = 0; i < s && itr.hasNext(); ++i) {
                itr.next();
            }
            String v = this.getVarName(ctx);
            String vs = this.getVarStatusName(ctx);
            ValueExpression vO = this.capture(v, pctx);
            ValueExpression vsO = this.capture(vs, pctx);
            int mi = 0;
            Object value = null;
            int stateIndex = 0;
            try {
                boolean first = true;
                while (i <= e && itr.hasNext()) {
                    int stateIndexCheck;
                    value = itr.next();
                    Object[] stateValue = null;
                    String base = null;
                    boolean found = false;
                    for (stateIndexCheck = stateIndex; stateIndexCheck < restoredSavedOption.getValueList().size(); ++stateIndexCheck) {
                        stateValue = restoredSavedOption.getValueList().get(stateIndexCheck);
                        if (!value.equals(stateValue[1])) continue;
                        found = true;
                        break;
                    }
                    if (found) {
                        stateIndex = stateIndexCheck;
                        base = (String)stateValue[0];
                        ++stateIndex;
                    } else {
                        Integer count = iterationState.getCounter();
                        base = count.toString();
                        iterationState.setCounter(count + 1);
                        stateValue = null;
                    }
                    if (value instanceof Serializable) {
                        iterationState.getValueList().add(new Object[]{base, value, i});
                    }
                    try {
                        boolean last;
                        fcc.startComponentUniqueIdSection(base);
                        this.setVar(ctx, parent, uniqueId, base, t, src, srcVE, value, v, i);
                        boolean bl = last = !itr.hasNext();
                        if (vs != null) {
                            IterationStatus itrS = new IterationStatus(first, last, i, sO, eO, mO, value);
                            IterationStatusExpression ve = t || srcVE == null ? (srcVE == null ? null : ctx.getExpressionFactory().createValueExpression((Object)itrS, Object.class)) : new IterationStatusExpression(itrS);
                            this.setVar(ctx, parent, uniqueId, base + "_vs", vs, ve, srcVE);
                        }
                        boolean markInitialState = stateValue == null;
                        boolean oldMarkInitialState = false;
                        Boolean isBuildingInitialState = null;
                        try {
                            if (markInitialState && fcc.isUsingPSSOnThisView()) {
                                oldMarkInitialState = fcc.isMarkInitialState();
                                fcc.setMarkInitialState(true);
                                isBuildingInitialState = ctx.getFacesContext().getAttributes().put("javax.faces.IS_BUILDING_INITIAL_STATE", Boolean.TRUE);
                            }
                            this.nextHandler.apply(ctx, parent);
                        }
                        finally {
                            if (markInitialState && fcc.isUsingPSSOnThisView()) {
                                if (isBuildingInitialState == null) {
                                    ctx.getFacesContext().getAttributes().remove("javax.faces.IS_BUILDING_INITIAL_STATE");
                                } else {
                                    ctx.getFacesContext().getAttributes().put("javax.faces.IS_BUILDING_INITIAL_STATE", isBuildingInitialState);
                                }
                                fcc.setMarkInitialState(oldMarkInitialState);
                            }
                        }
                    }
                    finally {
                        fcc.endComponentUniqueIdSection(base);
                    }
                    mi = 1;
                    while (mi < m && itr.hasNext()) {
                        itr.next();
                        ++mi;
                        ++i;
                    }
                    ++i;
                    first = false;
                }
            }
            finally {
                this.removeVarAndVarStatus(pctx, v, vO, vs, vsO);
            }
        }
        FaceletState faceletState = ComponentSupport.getFaceletState(ctx, parent, true);
        faceletState.putState(uniqueId, iterationState);
    }

    private void removeVarAndVarStatus(PageContext pctx, String v, ValueExpression vO, String vs, ValueExpression vsO) {
        if (v != null) {
            pctx.getAttributes().put(v, vO);
        } else {
            pctx.getAttributes().remove(v);
        }
        if (vs != null) {
            pctx.getAttributes().put(vs, vsO);
        } else {
            pctx.getAttributes().remove(vs);
        }
    }

    private ValueExpression capture(String name, PageContext pctx) {
        if (name != null) {
            return pctx.getAttributes().put(name, null);
        }
        return null;
    }

    private int getBegin(FaceletContext ctx) {
        if (this.begin != null) {
            return this.begin.getInt(ctx);
        }
        return 0;
    }

    private int getEnd(FaceletContext ctx) {
        if (this.end != null) {
            return this.end.getInt(ctx);
        }
        return 0x7FFFFFFE;
    }

    private int getStep(FaceletContext ctx) {
        if (this.step != null) {
            return this.step.getInt(ctx);
        }
        return 1;
    }

    private boolean getTransient(FaceletContext ctx) {
        if (this.tranzient != null) {
            return this.tranzient.getBoolean(ctx);
        }
        return false;
    }

    private ValueExpression getVarExpr(ValueExpression ve, Object src, Object value, int i) {
        if (src instanceof List || src.getClass().isArray()) {
            return new IteratedValueExpression(ve, value);
        }
        if (src instanceof Map && value instanceof Map.Entry) {
            return new MappedValueExpression(ve, (Map.Entry)value);
        }
        if (src instanceof Collection) {
            return new IteratedValueExpression(ve, value);
        }
        throw new IllegalStateException("Cannot create VE for: " + src);
    }

    private String getVarName(FaceletContext ctx) {
        if (this.var != null) {
            return this.var.getValue(ctx);
        }
        return null;
    }

    private String getVarStatusName(FaceletContext ctx) {
        if (this.varStatus != null) {
            return this.varStatus.getValue(ctx);
        }
        return null;
    }

    private Iterator<?> toIterator(Object src) {
        if (src == null) {
            return null;
        }
        if (src instanceof Collection) {
            return ((Collection)src).iterator();
        }
        if (src instanceof Map) {
            return ((Map)src).entrySet().iterator();
        }
        if (src.getClass().isArray()) {
            return new ArrayIterator(src);
        }
        throw new TagAttributeException(this.tag, this.items, "Must evaluate to a Collection, Map, Array, or null.");
    }

    private static class ArrayIterator
    implements Iterator<Object> {
        protected final Object array;
        protected int i = 0;
        protected final int len;

        public ArrayIterator(Object src) {
            this.array = src;
            this.len = Array.getLength(src);
        }

        @Override
        public boolean hasNext() {
            return this.i < this.len;
        }

        @Override
        public Object next() {
            return Array.get(this.array, this.i++);
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

