/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.el.convert;

import jakarta.el.ELContext;
import jakarta.el.ELException;
import jakarta.el.ELResolver;
import jakarta.el.ExpressionFactory;
import jakarta.el.PropertyNotFoundException;
import jakarta.el.PropertyNotWritableException;
import jakarta.faces.FactoryFinder;
import jakarta.faces.application.ApplicationFactory;
import jakarta.faces.context.FacesContext;
import jakarta.faces.el.EvaluationException;
import jakarta.faces.el.PropertyResolver;
import java.beans.FeatureDescriptor;
import java.util.Iterator;
import java.util.List;
import org.apache.myfaces.el.DefaultPropertyResolver;

public final class PropertyResolverToELResolver
extends ELResolver {
    private PropertyResolver propertyResolver;
    private ExpressionFactory expressionFactory;
    private boolean isDefaultLegacyPropertyResolver;

    public PropertyResolverToELResolver(PropertyResolver propertyResolver) {
        this.propertyResolver = propertyResolver;
        this.isDefaultLegacyPropertyResolver = propertyResolver instanceof DefaultPropertyResolver;
    }

    public void setValue(ELContext context, Object base, Object property, Object value) throws NullPointerException, PropertyNotFoundException, PropertyNotWritableException, ELException {
        if (this.isDefaultLegacyPropertyResolver) {
            return;
        }
        if (base == null || property == null) {
            return;
        }
        try {
            context.setPropertyResolved(true);
            if (PropertyResolverToELResolver.needsCoersion(base)) {
                this.propertyResolver.setValue(base, this.coerceToInt(property), value);
            } else {
                this.propertyResolver.setValue(base, property, value);
            }
            context.setPropertyResolved(FacesContext.getCurrentInstance().getELContext().isPropertyResolved());
        }
        catch (jakarta.faces.el.PropertyNotFoundException e) {
            context.setPropertyResolved(false);
            throw new PropertyNotFoundException(e.getMessage(), (Throwable)e);
        }
        catch (EvaluationException e) {
            context.setPropertyResolved(false);
            throw new ELException(e.getMessage(), (Throwable)e);
        }
        catch (RuntimeException e) {
            context.setPropertyResolved(false);
            throw e;
        }
    }

    public boolean isReadOnly(ELContext context, Object base, Object property) throws NullPointerException, PropertyNotFoundException, ELException {
        if (this.isDefaultLegacyPropertyResolver) {
            return false;
        }
        if (base == null || property == null) {
            return true;
        }
        try {
            context.setPropertyResolved(true);
            boolean result = PropertyResolverToELResolver.needsCoersion(base) ? this.propertyResolver.isReadOnly(base, this.coerceToInt(property)) : this.propertyResolver.isReadOnly(base, property);
            context.setPropertyResolved(FacesContext.getCurrentInstance().getELContext().isPropertyResolved());
            return result;
        }
        catch (jakarta.faces.el.PropertyNotFoundException e) {
            context.setPropertyResolved(false);
            throw new PropertyNotFoundException(e.getMessage(), (Throwable)e);
        }
        catch (EvaluationException e) {
            context.setPropertyResolved(false);
            throw new ELException(e.getMessage(), (Throwable)e);
        }
        catch (RuntimeException e) {
            context.setPropertyResolved(false);
            throw e;
        }
    }

    public Object getValue(ELContext context, Object base, Object property) throws NullPointerException, PropertyNotFoundException, ELException {
        if (this.isDefaultLegacyPropertyResolver) {
            return null;
        }
        if (base == null || property == null) {
            return null;
        }
        try {
            context.setPropertyResolved(true);
            Object value = PropertyResolverToELResolver.needsCoersion(base) ? this.propertyResolver.getValue(base, this.coerceToInt(property)) : this.propertyResolver.getValue(base, property);
            context.setPropertyResolved(FacesContext.getCurrentInstance().getELContext().isPropertyResolved());
            return value;
        }
        catch (jakarta.faces.el.PropertyNotFoundException e) {
            context.setPropertyResolved(false);
            throw new PropertyNotFoundException(e.getMessage(), (Throwable)e);
        }
        catch (EvaluationException e) {
            context.setPropertyResolved(false);
            throw new ELException(e.getMessage(), (Throwable)e);
        }
        catch (RuntimeException e) {
            context.setPropertyResolved(false);
            throw e;
        }
    }

    public Class<?> getType(ELContext context, Object base, Object property) throws NullPointerException, PropertyNotFoundException, ELException {
        if (this.isDefaultLegacyPropertyResolver) {
            return null;
        }
        if (base == null || property == null) {
            return null;
        }
        try {
            context.setPropertyResolved(true);
            Class value = PropertyResolverToELResolver.needsCoersion(base) ? this.propertyResolver.getType(base, this.coerceToInt(property)) : this.propertyResolver.getType(base, property);
            context.setPropertyResolved(FacesContext.getCurrentInstance().getELContext().isPropertyResolved());
            return value;
        }
        catch (jakarta.faces.el.PropertyNotFoundException e) {
            context.setPropertyResolved(false);
            throw new PropertyNotFoundException(e.getMessage(), (Throwable)e);
        }
        catch (EvaluationException e) {
            context.setPropertyResolved(false);
            throw new ELException(e.getMessage(), (Throwable)e);
        }
        catch (RuntimeException e) {
            context.setPropertyResolved(false);
            throw e;
        }
    }

    public Iterator<FeatureDescriptor> getFeatureDescriptors(ELContext context, Object base) {
        return null;
    }

    public Class<?> getCommonPropertyType(ELContext context, Object base) {
        if (this.isDefaultLegacyPropertyResolver) {
            return null;
        }
        if (base == null) {
            return null;
        }
        return Object.class;
    }

    private static boolean needsCoersion(Object base) {
        return base instanceof List || base.getClass().isArray();
    }

    protected ExpressionFactory getExpressionFactory() {
        if (this.expressionFactory == null) {
            ApplicationFactory appFactory = (ApplicationFactory)FactoryFinder.getFactory("jakarta.faces.application.ApplicationFactory");
            this.expressionFactory = appFactory.getApplication().getExpressionFactory();
        }
        return this.expressionFactory;
    }

    public void setExpressionFactory(ExpressionFactory expressionFactory) {
        this.expressionFactory = expressionFactory;
    }

    private int coerceToInt(Object property) {
        return (Integer)this.getExpressionFactory().coerceToType(property, Integer.class);
    }

    public PropertyResolver getPropertyResolver() {
        return this.propertyResolver;
    }
}

