/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.lifecycle;

import jakarta.faces.FacesException;
import jakarta.faces.application.Resource;
import jakarta.faces.context.ExternalContext;
import jakarta.faces.context.FacesContext;
import jakarta.faces.lifecycle.ClientWindow;
import jakarta.servlet.ServletOutputStream;
import jakarta.servlet.http.Cookie;
import jakarta.servlet.http.HttpServletResponse;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.Map;
import org.apache.myfaces.lifecycle.ClientConfig;
import org.apache.myfaces.lifecycle.TokenGenerator;
import org.apache.myfaces.lifecycle.WindowContextConfig;

public class CODIClientSideWindow
extends ClientWindow {
    private static final String AUTOMATED_ENTRY_POINT_PARAMETER_KEY = "automatedEntryPoint";
    private static final long serialVersionUID = 5293942986187078113L;
    private static final String WINDOW_ID_COOKIE_PREFIX = "jfwid-";
    private static final String CODI_REQUEST_TOKEN = "mfRid";
    private static final String UNINITIALIZED_WINDOW_ID_VALUE = "uninitializedWindowId";
    private static final String WINDOW_ID_REPLACE_PATTERN = "$$windowIdValue$$";
    private static final String NOSCRIPT_URL_REPLACE_PATTERN = "$$noscriptUrl$$";
    private static final String NOSCRIPT_PARAMETER = "mfDirect";
    private final ClientConfig clientConfig;
    private final WindowContextConfig windowContextConfig;
    private final TokenGenerator clientWindowTokenGenerator;
    private String windowId;
    private String unparsedWindowHandlerHtml = null;
    private Map<String, String> queryParamsMap;

    protected CODIClientSideWindow(TokenGenerator clientWindowTokenGenerator, WindowContextConfig windowContextConfig, ClientConfig clientConfig) {
        this.windowContextConfig = windowContextConfig;
        this.clientConfig = clientConfig;
        this.clientWindowTokenGenerator = clientWindowTokenGenerator;
    }

    @Override
    public void decode(FacesContext facesContext) {
        if (facesContext.isPostback() && this.getId() == null) {
            this.setId(this.calculateWindowIdFromPost(facesContext));
        }
        if (!this.isClientSideWindowHandlerRequest(facesContext)) {
            return;
        }
        ExternalContext externalContext = facesContext.getExternalContext();
        if (this.isNoscriptRequest(externalContext)) {
            this.clientConfig.setJavaScriptEnabled(false);
            return;
        }
        String windowId = this.getWindowIdFromCookie(externalContext);
        if (windowId == null) {
            this.sendWindowHandlerHtml(facesContext, null);
            facesContext.responseComplete();
        } else if (AUTOMATED_ENTRY_POINT_PARAMETER_KEY.equals(windowId) || !this.windowContextConfig.isUnknownWindowIdsAllowed()) {
            windowId = this.createWindowId(facesContext);
            this.sendWindowHandlerHtml(facesContext, windowId);
            facesContext.responseComplete();
        } else {
            this.setId(windowId);
        }
    }

    public String calculateWindowIdFromPost(FacesContext context) {
        String windowId = context.getExternalContext().getRequestParameterMap().get("jakarta.faces.ClientWindow");
        if (windowId != null) {
            return windowId;
        }
        return null;
    }

    private boolean isClientSideWindowHandlerRequest(FacesContext facesContext) {
        return !facesContext.isPostback() && this.clientConfig.isClientSideWindowHandlerRequest(facesContext);
    }

    private boolean isNoscriptRequest(ExternalContext externalContext) {
        String noscript = externalContext.getRequestParameterMap().get(NOSCRIPT_PARAMETER);
        return noscript != null && "true".equals(noscript);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendWindowHandlerHtml(FacesContext facesContext, String windowId) {
        HttpServletResponse httpResponse = (HttpServletResponse)facesContext.getExternalContext().getResponse();
        try {
            httpResponse.setStatus(200);
            httpResponse.setContentType("text/html");
            if (this.unparsedWindowHandlerHtml == null) {
                Resource resource = facesContext.getApplication().getResourceHandler().createResource("windowhandler.html", "org.apache.myfaces.windowId");
                this.unparsedWindowHandlerHtml = CODIClientSideWindow.convertStreamToString(resource.getInputStream());
            }
            String windowHandlerHtml = this.unparsedWindowHandlerHtml;
            if (windowId == null) {
                windowId = UNINITIALIZED_WINDOW_ID_VALUE;
            }
            windowHandlerHtml = windowHandlerHtml.replace(WINDOW_ID_REPLACE_PATTERN, windowId);
            windowHandlerHtml = windowHandlerHtml.replace(NOSCRIPT_URL_REPLACE_PATTERN, this.getNoscriptUrl(facesContext.getExternalContext()));
            try (ServletOutputStream os = httpResponse.getOutputStream();){
                os.write(windowHandlerHtml.getBytes());
            }
        }
        catch (IOException ioe) {
            throw new FacesException(ioe);
        }
    }

    private static String convertStreamToString(InputStream is) {
        StringBuilder sb = new StringBuilder();
        try {
            BufferedReader reader = new BufferedReader(new InputStreamReader(is));
            String line = null;
            while ((line = reader.readLine()) != null) {
                sb.append(line + "\n");
            }
        }
        catch (IOException e) {
            throw new FacesException(e);
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException iOException) {}
            }
        }
        return sb.toString();
    }

    private String getNoscriptUrl(ExternalContext externalContext) {
        int lastSlash;
        String url = externalContext.getRequestPathInfo();
        if (url == null) {
            url = "";
        }
        if ((lastSlash = url.lastIndexOf(47)) != -1) {
            url = url.substring(lastSlash + 1);
        }
        url = (url = CODIClientSideWindow.addParameters(externalContext, url, true, true, true)).contains("?") ? url + "&" : url + "?";
        url = url + NOSCRIPT_PARAMETER + "=true";
        url = url.replace("\"", "");
        url = url.replace("'", "");
        return url;
    }

    public static String addParameters(ExternalContext externalContext, String url, boolean addRequestParameter, boolean addPageParameter, boolean encodeValues) {
        StringBuilder finalUrl = new StringBuilder(url);
        boolean existingParameters = url.contains("?");
        boolean urlContainsWindowId = url.contains("jfwid=");
        return finalUrl.toString();
    }

    protected String createWindowId(FacesContext context) {
        String windowId = this.clientWindowTokenGenerator._getNextToken();
        this.setId(windowId);
        return windowId;
    }

    private String getWindowIdFromCookie(ExternalContext externalContext) {
        String cookieName = WINDOW_ID_COOKIE_PREFIX + this.getRequestToken(externalContext);
        Cookie cookie = (Cookie)externalContext.getRequestCookieMap().get(cookieName);
        if (cookie != null) {
            cookie.setMaxAge(0);
            return cookie.getValue();
        }
        return null;
    }

    private String getRequestToken(ExternalContext externalContext) {
        String requestToken = externalContext.getRequestParameterMap().get(CODI_REQUEST_TOKEN);
        if (requestToken != null) {
            return requestToken;
        }
        return "";
    }

    @Override
    public String getId() {
        return this.windowId;
    }

    public void setId(String id) {
        this.windowId = id;
        this.queryParamsMap = null;
    }

    @Override
    public Map<String, String> getQueryURLParameters(FacesContext context) {
        String id;
        if (this.queryParamsMap == null && (id = context.getExternalContext().getClientWindow().getId()) != null) {
            this.queryParamsMap = new HashMap<String, String>(2, 1.0f);
            this.queryParamsMap.put("jfwid", id);
        }
        return this.queryParamsMap;
    }
}

