/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.view.facelets.tag.jstl.core;

import jakarta.el.ELContext;
import jakarta.el.ELException;
import jakarta.el.ValueExpression;
import jakarta.faces.FacesException;
import jakarta.faces.component.UIComponent;
import jakarta.faces.view.facelets.FaceletContext;
import jakarta.faces.view.facelets.FaceletException;
import jakarta.faces.view.facelets.TagAttribute;
import jakarta.faces.view.facelets.TagConfig;
import jakarta.faces.view.facelets.TagException;
import jakarta.faces.view.facelets.TagHandler;
import java.io.IOException;
import org.apache.myfaces.view.facelets.AbstractFaceletContext;

public class LegacySetHandler
extends TagHandler {
    private final TagAttribute var;
    private final TagAttribute value = this.getAttribute("value");
    private final TagAttribute scope;
    private final TagAttribute target;
    private final TagAttribute property;

    public LegacySetHandler(TagConfig config) {
        super(config);
        this.var = this.getAttribute("var");
        this.scope = this.getAttribute("scope");
        this.target = this.getAttribute("target");
        this.property = this.getAttribute("property");
    }

    @Override
    public void apply(FaceletContext ctx, UIComponent parent) throws IOException, FacesException, FaceletException, ELException {
        ValueExpression veObj = this.value.getValueExpression(ctx, Object.class);
        if (this.var != null) {
            String varStr = this.var.getValue(ctx);
            if (this.scope != null) {
                String scopeStr = this.scope.getValue(ctx);
                if (scopeStr == null || scopeStr.length() == 0) {
                    throw new TagException(this.tag, "scope must not be empty");
                }
                if ("page".equals(scopeStr)) {
                    throw new TagException(this.tag, "page scope is not allowed");
                }
                StringBuilder expStr = new StringBuilder().append("#{").append(scopeStr);
                if ("request".equals(scopeStr) || "view".equals(scopeStr) || "session".equals(scopeStr) || "application".equals(scopeStr)) {
                    expStr.append("Scope");
                }
                expStr.append(".").append(varStr).append("}");
                ELContext elCtx = ctx.getFacesContext().getELContext();
                ValueExpression expr = ctx.getExpressionFactory().createValueExpression(elCtx, expStr.toString(), Object.class);
                expr.setValue(elCtx, veObj.getValue(elCtx));
            } else {
                ctx.getVariableMapper().setVariable(varStr, veObj);
                AbstractFaceletContext actx = (AbstractFaceletContext)ctx;
                actx.getPageContext().setAllowCacheELExpressions(false);
            }
        } else {
            if (this.target == null || this.property == null || this.value == null) {
                throw new TagException(this.tag, "either attributes var and value or target, property and value must be set");
            }
            if (this.target.isLiteral()) {
                throw new TagException(this.tag, "attribute target must contain a value expression");
            }
            ELContext elCtx = ctx.getFacesContext().getELContext();
            ValueExpression targetExpr = this.target.getValueExpression(ctx, Object.class);
            Object targetObj = targetExpr.getValue(elCtx);
            String propertyName = this.property.getValue(ctx);
            ctx.getELResolver().setValue(elCtx, targetObj, (Object)propertyName, veObj.getValue(elCtx));
        }
    }
}

