/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.view.facelets.el;

import jakarta.el.ELException;
import jakarta.el.ValueExpression;
import jakarta.el.VariableMapper;
import jakarta.faces.FacesWrapper;
import java.util.HashMap;
import java.util.Map;
import org.apache.myfaces.view.facelets.el.VariableMapperBase;

public final class VariableMapperWrapper
extends VariableMapperBase
implements FacesWrapper<VariableMapper> {
    private final VariableMapper _target;
    private final VariableMapperBase _targetBase;
    private Map<String, ValueExpression> _vars;
    public boolean _trackResolveVariables;
    public boolean _variableResolved;

    public VariableMapperWrapper(VariableMapper orig) {
        this._target = orig;
        this._targetBase = orig instanceof VariableMapperBase ? (VariableMapperBase)orig : null;
        this._trackResolveVariables = false;
        this._variableResolved = false;
    }

    public ValueExpression resolveVariable(String variable) {
        ValueExpression ve = null;
        try {
            if (this._vars != null) {
                ve = this._vars.get(variable);
                if (this._trackResolveVariables && ve != null) {
                    this._variableResolved = true;
                }
            }
            if (ve == null) {
                return this._target.resolveVariable(variable);
            }
            return ve;
        }
        catch (StackOverflowError e) {
            throw new ELException("Could not Resolve Variable [Overflow]: " + variable, (Throwable)e);
        }
    }

    public ValueExpression setVariable(String variable, ValueExpression expression) {
        if (this._vars == null) {
            this._vars = new HashMap<String, ValueExpression>();
        }
        return this._vars.put(variable, expression);
    }

    @Override
    public boolean isAnyFaceletsVariableResolved() {
        if (this._trackResolveVariables) {
            if (this._variableResolved) {
                return true;
            }
            if (this._targetBase != null) {
                return this._targetBase.isAnyFaceletsVariableResolved();
            }
            return true;
        }
        return true;
    }

    public VariableMapper getWrapped() {
        return this._target;
    }

    @Override
    public void beforeConstructELExpression() {
        this._trackResolveVariables = true;
        this._variableResolved = false;
        if (this._targetBase != null) {
            this._targetBase.beforeConstructELExpression();
        }
    }

    @Override
    public void afterConstructELExpression() {
        if (this._targetBase != null) {
            this._targetBase.afterConstructELExpression();
        }
        this._trackResolveVariables = false;
        this._variableResolved = false;
    }
}

