/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.config.annotation;

import jakarta.enterprise.event.Observes;
import jakarta.enterprise.inject.spi.AnnotatedType;
import jakarta.enterprise.inject.spi.Extension;
import jakarta.enterprise.inject.spi.ProcessAnnotatedType;
import jakarta.faces.component.FacesComponent;
import jakarta.faces.component.behavior.FacesBehavior;
import jakarta.faces.convert.FacesConverter;
import jakarta.faces.render.FacesBehaviorRenderer;
import jakarta.faces.render.FacesRenderer;
import jakarta.faces.validator.FacesValidator;
import java.lang.annotation.Annotation;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.myfaces.config.element.NamedEvent;

public class CdiAnnotationProviderExtension
implements Extension {
    private Map<Class<? extends Annotation>, Set<Class<?>>> map;
    private Class<? extends Annotation>[] annotationsToScan = new Class[]{FacesComponent.class, FacesBehavior.class, FacesConverter.class, FacesValidator.class, FacesRenderer.class, NamedEvent.class, FacesBehaviorRenderer.class};

    public CdiAnnotationProviderExtension() {
        this.map = new HashMap(this.annotationsToScan.length, 1.0f);
    }

    <T> void processAnnotatedType(@Observes ProcessAnnotatedType<T> pat) {
        AnnotatedType type = pat.getAnnotatedType();
        for (Class<? extends Annotation> annotation : this.annotationsToScan) {
            if (!type.isAnnotationPresent(annotation)) continue;
            Set set = this.map.computeIfAbsent(annotation, k -> new HashSet());
            set.add(type.getJavaClass());
        }
    }

    public Map<Class<? extends Annotation>, Set<Class<?>>> getMap() {
        return this.map;
    }

    public void release() {
        this.map.clear();
        this.map = null;
        this.annotationsToScan = null;
    }
}

