/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.resource;

import jakarta.faces.application.ResourceVisitOption;
import jakarta.faces.context.FacesContext;
import java.util.Deque;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Set;
import org.apache.myfaces.resource.ResourceLoaderUtils;

public class ExternalContextResourceLoaderIterator
implements Iterator<String> {
    private FacesContext facesContext;
    private String basePath;
    private int maxDepth;
    private ResourceVisitOption[] options;
    private Deque<String> stack;

    public ExternalContextResourceLoaderIterator(FacesContext facesContext, String path, int maxDepth, ResourceVisitOption ... options) {
        this.facesContext = facesContext;
        this.basePath = path;
        this.maxDepth = maxDepth;
        this.options = options;
        Set<String> paths = facesContext.getExternalContext().getResourcePaths(this.basePath);
        if (paths != null) {
            for (String p : paths) {
                if (p.startsWith("/WEB-INF") && this.isTopLevelViewsOnly(options) || p.startsWith("/META-INF") && this.isTopLevelViewsOnly(options)) continue;
                if (this.stack == null) {
                    this.stack = new LinkedList<String>();
                }
                this.stack.add(p);
            }
        }
    }

    private boolean isTopLevelViewsOnly(ResourceVisitOption ... options) {
        boolean isTopLevelViewsOnly = false;
        for (ResourceVisitOption option : options) {
            if (option != ResourceVisitOption.TOP_LEVEL_VIEWS_ONLY) continue;
            isTopLevelViewsOnly = true;
            break;
        }
        return isTopLevelViewsOnly;
    }

    @Override
    public boolean hasNext() {
        if (this.stack == null || this.stack.isEmpty()) {
            return false;
        }
        String path = this.stack.peek();
        do {
            Set<String> list;
            if (!ResourceLoaderUtils.isDirectory(path)) continue;
            path = this.stack.pop();
            int depth = ResourceLoaderUtils.getDepth(path);
            if (depth < this.maxDepth && (list = this.facesContext.getExternalContext().getResourcePaths(path)) != null) {
                this.stack.addAll(list);
            }
            path = !this.stack.isEmpty() ? this.stack.peek() : null;
        } while (path != null && ResourceLoaderUtils.isDirectory(path) && !this.stack.isEmpty());
        return !this.stack.isEmpty();
    }

    @Override
    public String next() {
        if (this.stack == null || this.stack.isEmpty()) {
            return null;
        }
        String path = this.stack.pop();
        do {
            Set<String> list;
            if (!ResourceLoaderUtils.isDirectory(path)) continue;
            int depth = ResourceLoaderUtils.getDepth(path);
            if (depth < this.maxDepth && (list = this.facesContext.getExternalContext().getResourcePaths(path)) != null) {
                this.stack.addAll(list);
            }
            path = !this.stack.isEmpty() ? this.stack.pop() : null;
        } while (path != null && ResourceLoaderUtils.isDirectory(path) && !this.stack.isEmpty());
        if (path != null) {
            return path;
        }
        return null;
    }

    @Override
    public void remove() {
    }
}

