/*
 * Decompiled with CFR 0.152.
 */
package jakarta.enterprise.inject.spi;

import jakarta.enterprise.inject.Instance;
import jakarta.enterprise.inject.spi.BeanManager;
import jakarta.enterprise.inject.spi.CDIProvider;
import java.util.ServiceLoader;

public abstract class CDI<T>
implements Instance<T> {
    private static volatile CDIProvider PROVIDER;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public static CDI<Object> current() {
        if (PROVIDER == null) {
            Class<CDI> clazz = CDI.class;
            // MONITORENTER : jakarta.enterprise.inject.spi.CDI.class
            if (PROVIDER == null) {
                CDIProvider highestProvider = null;
                int ordinal = -1;
                ServiceLoader<CDIProvider> cdiProviders = ServiceLoader.load(CDIProvider.class);
                for (CDIProvider cdiProvider : cdiProviders) {
                    if (highestProvider != null && cdiProvider.getPriority() <= ordinal) continue;
                    highestProvider = cdiProvider;
                }
                PROVIDER = highestProvider;
            }
            // MONITOREXIT : clazz
        }
        if (PROVIDER != null) return PROVIDER.getCDI();
        throw new IllegalStateException("Unable to locate a CDIProvider implementation");
    }

    public static void setCDIProvider(CDIProvider provider) {
        if (provider == null) {
            throw new IllegalStateException("CDIProvider must not be null");
        }
        PROVIDER = provider;
    }

    public abstract BeanManager getBeanManager();
}

