/*
 * Decompiled with CFR 0.152.
 */
package jakarta.faces.component;

import jakarta.faces.component.PartialStateHolder;
import jakarta.faces.component.StateHolder;
import jakarta.faces.component.UIComponent;
import jakarta.faces.component.UIComponentBase;
import jakarta.faces.component._AttachedDeltaWrapper;
import jakarta.faces.context.FacesContext;
import jakarta.faces.event.ComponentSystemEvent;
import jakarta.faces.event.ComponentSystemEventListener;
import jakarta.faces.event.SystemEvent;
import jakarta.faces.event.SystemEventListener;
import jakarta.faces.render.Renderer;
import jakarta.faces.render.RendererWrapper;

class _EventListenerWrapper
implements SystemEventListener,
PartialStateHolder {
    static final int LISTENER_SAVE_STATE_HOLDER = 1;
    static final int LISTENER_SAVE_PARTIAL_STATE_HOLDER = 2;
    static final int LISTENER_TYPE_COMPONENT = 4;
    static final int LISTENER_TYPE_RENDERER = 8;
    static final int LISTENER_TYPE_OTHER = 16;
    private Class<?> componentClass;
    private ComponentSystemEventListener listener;
    private boolean _initialStateMarked;
    private int listenerCapability;
    private transient UIComponent _component;

    public _EventListenerWrapper() {
    }

    public _EventListenerWrapper(UIComponent component, ComponentSystemEventListener listener) {
        assert (component != null);
        assert (listener != null);
        this.componentClass = component.getClass();
        this.listener = listener;
        this._component = component;
        this.initListenerCapability();
    }

    private void initListenerCapability() {
        this.listenerCapability = 0;
        this.listenerCapability = this.listener instanceof UIComponent ? 4 : (this.listener instanceof Renderer ? 8 : (this.listener instanceof PartialStateHolder ? 18 : (this.listener instanceof StateHolder ? 17 : 16)));
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof _EventListenerWrapper) {
            _EventListenerWrapper other = (_EventListenerWrapper)o;
            return this.componentClass.equals(other.componentClass) && this.listener.equals(other.listener);
        }
        return false;
    }

    public int hashCode() {
        return this.componentClass.hashCode() + this.listener.hashCode();
    }

    @Override
    public boolean isListenerForSource(Object source) {
        return source.getClass().isAssignableFrom(this.componentClass);
    }

    public ComponentSystemEventListener getComponentSystemEventListener() {
        return this.listener;
    }

    @Override
    public void processEvent(SystemEvent event) {
        assert (event instanceof ComponentSystemEvent);
        this.listener.processEvent((ComponentSystemEvent)event);
    }

    @Override
    public void clearInitialState() {
        if ((this.listenerCapability & 2) != 0) {
            ((PartialStateHolder)((Object)this.listener)).clearInitialState();
        }
        this._initialStateMarked = false;
    }

    @Override
    public boolean initialStateMarked() {
        if ((this.listenerCapability & 2) != 0) {
            return ((PartialStateHolder)((Object)this.listener)).initialStateMarked();
        }
        return this._initialStateMarked;
    }

    @Override
    public void markInitialState() {
        if ((this.listenerCapability & 2) != 0) {
            ((PartialStateHolder)((Object)this.listener)).markInitialState();
        }
        this._initialStateMarked = true;
    }

    @Override
    public boolean isTransient() {
        if ((this.listenerCapability & 2) != 0 || (this.listenerCapability & 1) != 0) {
            return ((StateHolder)((Object)this.listener)).isTransient();
        }
        return false;
    }

    @Override
    public void restoreState(FacesContext context, Object state) {
        if (state == null) {
            return;
        }
        Object[] values = (Object[])state;
        this.componentClass = (Class)values[0];
        if (values[1] instanceof _AttachedDeltaWrapper) {
            ((StateHolder)((Object)this.listener)).restoreState(context, ((_AttachedDeltaWrapper)values[1]).getWrappedStateObject());
        } else {
            this.listenerCapability = (Integer)values[2];
            this._component = UIComponent.getCurrentComponent(context);
            if ((this.listenerCapability & 4) != 0) {
                this.listener = this._component;
            } else if ((this.listenerCapability & 8) != 0) {
                Renderer renderer = this._component.getRenderer(context);
                Integer i = (Integer)values[1];
                if (i != null && i >= 0) {
                    while (i > 0) {
                        renderer = ((RendererWrapper)renderer).getWrapped();
                        Integer n = i;
                        i = i - 1;
                    }
                }
                this.listener = (ComponentSystemEventListener)((Object)renderer);
            } else {
                this.listener = (ComponentSystemEventListener)UIComponentBase.restoreAttachedState(context, values[1]);
            }
        }
    }

    @Override
    public Object saveState(FacesContext context) {
        if (!this.initialStateMarked()) {
            Object[] state = new Object[3];
            state[0] = this.componentClass;
            if ((this.listenerCapability & 4) == 0 && (this.listenerCapability & 8) == 0) {
                state[1] = UIComponentBase.saveAttachedState(context, this.listener);
            } else if ((this.listenerCapability & 8) != 0) {
                UIComponent componentRef = this._component != null ? this._component : UIComponent.getCurrentComponent(context);
                Renderer renderer = componentRef.getRenderer(context);
                int i = 0;
                while (renderer != null && !renderer.getClass().equals(this.listener.getClass())) {
                    if (renderer instanceof RendererWrapper) {
                        renderer = ((RendererWrapper)renderer).getWrapped();
                        ++i;
                        continue;
                    }
                    renderer = null;
                    i = -1;
                }
                state[1] = i != -1 ? Integer.valueOf(i) : null;
            } else {
                state[1] = null;
            }
            state[2] = this.listenerCapability;
            return state;
        }
        if ((this.listenerCapability & 4) != 0) {
            return null;
        }
        if ((this.listenerCapability & 8) != 0) {
            return null;
        }
        if ((this.listenerCapability & 1) != 0 || (this.listenerCapability & 2) != 0) {
            Object listenerSaved = ((StateHolder)((Object)this.listener)).saveState(context);
            if (listenerSaved == null) {
                return null;
            }
            return new Object[]{this.componentClass, new _AttachedDeltaWrapper(this.listener.getClass(), listenerSaved)};
        }
        return null;
    }

    @Override
    public void setTransient(boolean newTransientValue) {
        if ((this.listenerCapability & 2) != 0 || (this.listenerCapability & 1) != 0) {
            ((StateHolder)((Object)this.listener)).setTransient(newTransientValue);
        }
    }

    public int getListenerCapability() {
        return this.listenerCapability;
    }
}

