/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.context.servlet;

import jakarta.faces.application.FacesMessage;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;

public class FacesMessageIterator
implements Iterator<FacesMessage> {
    private final Map<String, List<FacesMessage>> messages;
    private int outerIndex = -1;
    private final int messagesSize;
    private Iterator<FacesMessage> inner;
    private final Iterator<String> keys;

    FacesMessageIterator(Map<String, List<FacesMessage>> messages) {
        this.messages = messages;
        this.messagesSize = messages.size();
        this.keys = messages.keySet().iterator();
    }

    @Override
    public boolean hasNext() {
        if (this.outerIndex == -1) {
            ++this.outerIndex;
            this.inner = this.messages.get(this.keys.next()).iterator();
        }
        while (!this.inner.hasNext()) {
            ++this.outerIndex;
            if (this.outerIndex < this.messagesSize) {
                this.inner = this.messages.get(this.keys.next()).iterator();
                continue;
            }
            return false;
        }
        return this.inner.hasNext();
    }

    @Override
    public FacesMessage next() {
        if (this.outerIndex >= this.messagesSize) {
            throw new NoSuchElementException();
        }
        if (this.inner != null && this.inner.hasNext()) {
            return this.inner.next();
        }
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        return this.inner.next();
    }

    @Override
    public void remove() {
        if (this.outerIndex == -1) {
            throw new IllegalStateException();
        }
        this.inner.remove();
    }
}

