/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.renderkit.html.base;

import jakarta.faces.application.ProjectStage;
import jakarta.faces.component.UIComponent;
import jakarta.faces.component.UIPanel;
import jakarta.faces.component.behavior.ClientBehavior;
import jakarta.faces.component.behavior.ClientBehaviorHolder;
import jakarta.faces.component.html.HtmlPanelGrid;
import jakarta.faces.context.FacesContext;
import jakarta.faces.context.ResponseWriter;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.myfaces.core.api.shared.ComponentUtils;
import org.apache.myfaces.renderkit.RendererUtils;
import org.apache.myfaces.renderkit.html.base.HtmlRenderer;
import org.apache.myfaces.renderkit.html.util.ClientBehaviorRendererUtils;
import org.apache.myfaces.renderkit.html.util.CommonHtmlAttributesUtil;
import org.apache.myfaces.renderkit.html.util.CommonHtmlEventsUtil;
import org.apache.myfaces.renderkit.html.util.HTML;
import org.apache.myfaces.renderkit.html.util.HtmlRendererUtils;
import org.apache.myfaces.renderkit.html.util.ResourceUtils;
import org.apache.myfaces.util.lang.ArrayUtils;
import org.apache.myfaces.util.lang.StringUtils;

public class HtmlGridRendererBase
extends HtmlRenderer {
    private static final Logger log = Logger.getLogger(HtmlGridRendererBase.class.getName());
    private static final Integer[] ZERO_INT_ARRAY = new Integer[]{0};

    @Override
    public boolean getRendersChildren() {
        return true;
    }

    public void decode(FacesContext context, UIComponent component) {
        super.decode(context, component);
        ClientBehaviorRendererUtils.decodeClientBehaviors(context, component);
    }

    public void encodeBegin(FacesContext facesContext, UIComponent component) throws IOException {
    }

    public void encodeChildren(FacesContext context, UIComponent component) throws IOException {
    }

    public void encodeEnd(FacesContext facesContext, UIComponent component) throws IOException {
        int columns;
        RendererUtils.checkParamValidity(facesContext, component, UIPanel.class);
        if (component instanceof HtmlPanelGrid) {
            columns = ((HtmlPanelGrid)component).getColumns();
        } else {
            Integer i = (Integer)component.getAttributes().get("columns");
            int n = columns = i != null ? i : 0;
        }
        if (columns <= 0) {
            if (log.isLoggable(Level.SEVERE)) {
                log.severe("Wrong columns attribute for PanelGrid " + component.getClientId(facesContext) + ": " + columns);
            }
            columns = 1;
        }
        ResponseWriter writer = facesContext.getResponseWriter();
        Map<String, List<ClientBehavior>> behaviors = null;
        if (component instanceof ClientBehaviorHolder) {
            behaviors = ((ClientBehaviorHolder)((Object)component)).getClientBehaviors();
        }
        if (behaviors != null && !behaviors.isEmpty()) {
            ResourceUtils.renderDefaultJsfJsInlineIfNecessary(facesContext, writer);
        }
        writer.startElement("table", component);
        if (component instanceof ClientBehaviorHolder) {
            if (!behaviors.isEmpty()) {
                HtmlRendererUtils.writeIdAndName(writer, component, facesContext);
            } else {
                HtmlRendererUtils.writeIdIfNecessary(writer, component, facesContext);
            }
            long commonPropertiesMarked = 0L;
            if (this.isCommonPropertiesOptimizationEnabled(facesContext)) {
                commonPropertiesMarked = CommonHtmlAttributesUtil.getMarkedAttributes(component);
            }
            if (behaviors.isEmpty() && this.isCommonPropertiesOptimizationEnabled(facesContext)) {
                CommonHtmlAttributesUtil.renderEventProperties(writer, commonPropertiesMarked, component);
            } else if (this.isCommonEventsOptimizationEnabled(facesContext)) {
                CommonHtmlEventsUtil.renderBehaviorizedEventHandlers(facesContext, writer, commonPropertiesMarked, CommonHtmlEventsUtil.getMarkedEvents(component), component, behaviors);
            } else {
                HtmlRendererUtils.renderBehaviorizedEventHandlers(facesContext, writer, component, behaviors);
            }
            if (this.isCommonPropertiesOptimizationEnabled(facesContext)) {
                HtmlRendererUtils.renderHTMLAttributes(writer, component, HTML.TABLE_ATTRIBUTES);
                CommonHtmlAttributesUtil.renderCommonPassthroughPropertiesWithoutEvents(writer, commonPropertiesMarked, component);
            } else {
                HtmlRendererUtils.renderHTMLAttributes(writer, component, HTML.TABLE_PASSTHROUGH_ATTRIBUTES_WITHOUT_EVENTS);
            }
        } else {
            HtmlRendererUtils.writeIdIfNecessary(writer, component, facesContext);
            if (this.isCommonPropertiesOptimizationEnabled(facesContext)) {
                HtmlRendererUtils.renderHTMLAttributes(writer, component, HTML.TABLE_ATTRIBUTES);
                CommonHtmlAttributesUtil.renderCommonPassthroughProperties(writer, CommonHtmlAttributesUtil.getMarkedAttributes(component), component);
            } else {
                HtmlRendererUtils.renderHTMLAttributes(writer, component, HTML.TABLE_PASSTHROUGH_ATTRIBUTES);
            }
        }
        writer.flush();
        HtmlRendererUtils.renderTableCaption(facesContext, writer, component);
        this.renderHeaderOrFooter(facesContext, writer, component, columns, true);
        this.renderHeaderOrFooter(facesContext, writer, component, columns, false);
        this.renderChildren(facesContext, writer, component, columns);
        writer.endElement("table");
    }

    protected void renderHeaderOrFooter(FacesContext context, ResponseWriter writer, UIComponent component, int columns, boolean header) throws IOException {
        String styleClass;
        UIComponent facet = component.getFacet(header ? "header" : "footer");
        if (facet == null) {
            return;
        }
        writer.startElement(header ? "thead" : "tfoot", null);
        writer.startElement("tr", null);
        writer.startElement(header ? "th" : "td", null);
        String string = component instanceof HtmlPanelGrid ? (header ? ((HtmlPanelGrid)component).getHeaderClass() : ((HtmlPanelGrid)component).getFooterClass()) : (styleClass = header ? (String)component.getAttributes().get("headerClass") : (String)component.getAttributes().get("footerClass"));
        if (styleClass != null) {
            writer.writeAttribute("class", styleClass, header ? "headerClass" : "footerClass");
        }
        if (header) {
            writer.writeAttribute("scope", "colgroup", null);
        }
        writer.writeAttribute("colspan", Integer.toString(columns), null);
        facet.encodeAll(context);
        writer.endElement(header ? "th" : "td");
        writer.endElement("tr");
        writer.endElement(header ? "thead" : "tfoot");
    }

    protected int childAttributes(FacesContext context, ResponseWriter writer, UIComponent component, int columnIndex) throws IOException {
        return columnIndex;
    }

    protected void renderChildren(FacesContext context, ResponseWriter writer, UIComponent component, int columns) throws IOException {
        String rowClasses;
        String columnClasses;
        if (component instanceof HtmlPanelGrid) {
            columnClasses = ((HtmlPanelGrid)component).getColumnClasses();
            rowClasses = ((HtmlPanelGrid)component).getRowClasses();
        } else {
            columnClasses = (String)component.getAttributes().get("columnClasses");
            rowClasses = (String)component.getAttributes().get("rowClasses");
        }
        String[] columnClassesArray = columnClasses == null ? ArrayUtils.EMPTY_STRING_ARRAY : StringUtils.trim(StringUtils.splitShortString(columnClasses, ','));
        int columnClassesCount = columnClassesArray.length;
        String[] rowClassesArray = rowClasses == null ? ArrayUtils.EMPTY_STRING_ARRAY : StringUtils.trim(StringUtils.splitShortString(rowClasses, ','));
        int rowClassesCount = rowClassesArray.length;
        int childCount = this.getChildCount(component);
        if (childCount > 0) {
            Object[] bodyrows = null;
            String bodyrowsAttr = (String)component.getAttributes().get("bodyrows");
            if (bodyrowsAttr != null && !bodyrowsAttr.isEmpty()) {
                String[] bodyrowsString = StringUtils.trim(StringUtils.splitShortString(bodyrowsAttr, ','));
                bodyrows = new Integer[bodyrowsString.length];
                for (int i = 0; i < bodyrowsString.length; ++i) {
                    bodyrows[i] = Integer.valueOf(bodyrowsString[i]);
                }
            } else {
                bodyrows = ZERO_INT_ARRAY;
            }
            int bodyrowsCount = 0;
            int rowIndex = -1;
            int columnIndex = 0;
            int rowClassIndex = 0;
            boolean rowStarted = false;
            int size = component.getChildCount();
            for (int i = 0; i < size; ++i) {
                UIComponent child = component.getChildren().get(i);
                if (!child.isRendered()) continue;
                if (columnIndex == 0) {
                    ++rowIndex;
                    if (rowStarted) {
                        writer.endElement("tr");
                    }
                    if (ArrayUtils.contains(bodyrows, rowIndex)) {
                        if (bodyrowsCount != 0) {
                            writer.endElement("tbody");
                        }
                        writer.startElement("tbody", null);
                        ++bodyrowsCount;
                    }
                    writer.startElement("tr", null);
                    Object rowClass = null;
                    if (component instanceof HtmlPanelGrid) {
                        rowClass = ((HtmlPanelGrid)component).getRowClass();
                    }
                    if (rowClassIndex < rowClassesCount) {
                        rowClass = rowClass == null ? rowClassesArray[rowClassIndex] : (String)rowClass + " " + rowClassesArray[rowClassIndex];
                    }
                    if (rowClass != null) {
                        writer.writeAttribute("class", rowClass, null);
                    }
                    rowStarted = true;
                    if (++rowClassIndex == rowClassesCount) {
                        rowClassIndex = 0;
                    }
                }
                writer.startElement("td", null);
                if (columnIndex < columnClassesCount) {
                    writer.writeAttribute("class", columnClassesArray[columnIndex], null);
                }
                columnIndex = this.childAttributes(context, writer, child, columnIndex);
                child.encodeAll(context);
                writer.endElement("td");
                if (++columnIndex < columns) continue;
                columnIndex = 0;
            }
            if (rowStarted) {
                if (columnIndex > 0) {
                    Level level;
                    Level level2 = level = context.isProjectStage(ProjectStage.Production) ? Level.FINE : Level.WARNING;
                    if (log.isLoggable(level)) {
                        log.log(level, "PanelGrid " + ComponentUtils.getPathToComponent(component) + " has not enough children. Child count should be a multiple of the columns attribute.");
                    }
                    while (columnIndex < columns) {
                        writer.startElement("td", null);
                        if (columnIndex < columnClassesCount) {
                            writer.writeAttribute("class", columnClassesArray[columnIndex], null);
                        }
                        writer.endElement("td");
                        ++columnIndex;
                    }
                }
                writer.endElement("tr");
                if (bodyrowsCount != 0) {
                    writer.endElement("tbody");
                }
            }
        }
    }
}

